/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.ClassOrder;

public class ClassOrderTest
extends AbstractFilterTest {
    protected int m_ClassIndex = 4;

    public ClassOrderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(this.m_ClassIndex);
    }

    @Override
    public Filter getFilter() {
        return new ClassOrder();
    }

    protected void performTests(Instances result) {
        ClassOrderTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ClassOrderTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int i = 0;
        while (i < result.numAttributes()) {
            ClassOrderTest.assertEquals((int)this.m_Instances.attribute(i).type(), (int)result.attribute(i).type());
            ClassOrderTest.assertEquals((String)this.m_Instances.attribute(i).name(), (String)result.attribute(i).name());
            ++i;
        }
        boolean orderEqual = true;
        int i2 = 0;
        while (i2 < result.numClasses()) {
            if (!this.m_Instances.classAttribute().value(i2).equals(result.classAttribute().value(i2))) {
                orderEqual = false;
                break;
            }
            ++i2;
        }
        if (orderEqual) {
            ClassOrderTest.fail((String)"Order wasn't changed!");
        }
    }

    public void testRandom() {
        this.m_Filter = this.getFilter();
        ((ClassOrder)this.m_Filter).setClassOrder(2);
        Instances result = this.useFilter();
        this.performTests(result);
    }

    public void testFreqAscend() {
        this.m_Filter = this.getFilter();
        ((ClassOrder)this.m_Filter).setClassOrder(0);
        Instances result = this.useFilter();
        this.performTests(result);
    }

    public void testFreqDescend() {
        this.m_Filter = this.getFilter();
        ((ClassOrder)this.m_Filter).setClassOrder(1);
        Instances result = this.useFilter();
        this.performTests(result);
    }

    public static Test suite() {
        return new TestSuite(ClassOrderTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ClassOrderTest.suite());
    }
}

