/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.InterquartileRange;

public class InterquartileRangeTest
extends AbstractFilterTest {
    public InterquartileRangeTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new InterquartileRange();
    }

    public void testNominalClass() {
        this.m_Instances.setClassIndex(1);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            InterquartileRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        InterquartileRangeTest.assertEquals((int)(icopy.numAttributes() + 2), (int)result.numAttributes());
        InterquartileRangeTest.assertEquals((int)icopy.numInstances(), (int)result.numInstances());
    }

    public void testNominalClassSingleAttribute() {
        this.m_Instances.setClassIndex(1);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        ((InterquartileRange)this.m_Filter).setAttributeIndices("3");
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            InterquartileRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        InterquartileRangeTest.assertEquals((int)(icopy.numAttributes() + 2), (int)result.numAttributes());
        InterquartileRangeTest.assertEquals((int)icopy.numInstances(), (int)result.numInstances());
    }

    public void testNumericClass() {
        this.m_Instances.setClassIndex(2);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            InterquartileRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        InterquartileRangeTest.assertEquals((int)(icopy.numAttributes() + 2), (int)result.numAttributes());
        InterquartileRangeTest.assertEquals((int)icopy.numInstances(), (int)result.numInstances());
    }

    public void testWithoutClass() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            InterquartileRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        InterquartileRangeTest.assertEquals((int)(icopy.numAttributes() + 2), (int)result.numAttributes());
        InterquartileRangeTest.assertEquals((int)icopy.numInstances(), (int)result.numInstances());
    }

    public void testPerAttribute() {
        ((InterquartileRange)this.m_Filter).setDetectionPerAttribute(true);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            InterquartileRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        int count = 0;
        int i = 0;
        while (i < icopy.numAttributes()) {
            if (icopy.attribute(i).isNumeric()) {
                ++count;
            }
            ++i;
        }
        InterquartileRangeTest.assertEquals((int)(icopy.numAttributes() + 2 * count), (int)result.numAttributes());
        InterquartileRangeTest.assertEquals((int)icopy.numInstances(), (int)result.numInstances());
    }

    public void testOffset() {
        ((InterquartileRange)this.m_Filter).setDetectionPerAttribute(true);
        ((InterquartileRange)this.m_Filter).setOutputOffsetMultiplier(true);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            InterquartileRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InterquartileRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        int count = 0;
        int i = 0;
        while (i < icopy.numAttributes()) {
            if (icopy.attribute(i).isNumeric()) {
                ++count;
            }
            ++i;
        }
        InterquartileRangeTest.assertEquals((int)(icopy.numAttributes() + 3 * count), (int)result.numAttributes());
        InterquartileRangeTest.assertEquals((int)icopy.numInstances(), (int)result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(InterquartileRangeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)InterquartileRangeTest.suite());
    }
}

