/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.StringToNominal;

public class StringToNominalTest
extends AbstractFilterTest {
    public StringToNominalTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        StringToNominal f = new StringToNominal();
        f.setAttributeRange("1");
        return f;
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities((Capabilities)this.m_FilteredClassifier.getCapabilities());
        test.setNumRelational(0);
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        StringToNominalTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        StringToNominalTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        StringToNominalTest.assertEquals((String)"Attribute type should now be NOMINAL", (int)1, (int)result.attribute(0).type());
        StringToNominalTest.assertEquals((int)14, (int)result.attribute(0).numValues());
    }

    public void testMissing() {
        ((StringToNominal)this.m_Filter).setAttributeRange("4");
        Instances result = this.useFilter();
        StringToNominalTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        StringToNominalTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        StringToNominalTest.assertEquals((String)"Attribute type should now be NOMINAL", (int)1, (int)result.attribute(3).type());
        StringToNominalTest.assertEquals((int)8, (int)result.attribute(3).numValues());
        int i = 0;
        while (i < result.numInstances()) {
            StringToNominalTest.assertTrue((String)"Missing values should be preserved", (this.m_Instances.instance(i).isMissing(3) == result.instance(i).isMissing(3) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testRange() {
        ((StringToNominal)this.m_Filter).setAttributeRange("first-last");
        Instances result = this.useFilter();
        StringToNominalTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        StringToNominalTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        StringToNominalTest.assertEquals((String)"Attribute type should now be NOMINAL", (int)1, (int)result.attribute(0).type());
        StringToNominalTest.assertEquals((String)"Attribute type should still be NOMINAL", (int)1, (int)result.attribute(1).type());
        StringToNominalTest.assertEquals((String)"Attribute type should still be NUMERIC", (int)0, (int)result.attribute(2).type());
        StringToNominalTest.assertEquals((String)"Attribute type should now be NOMINAL", (int)1, (int)result.attribute(3).type());
        StringToNominalTest.assertEquals((String)"Attribute type should still be NOMINAL", (int)1, (int)result.attribute(4).type());
        StringToNominalTest.assertEquals((String)"Attribute type should still be NUMERIC", (int)0, (int)result.attribute(5).type());
        StringToNominalTest.assertEquals((String)"Attribute type should still be DATE", (int)3, (int)result.attribute(6).type());
        StringToNominalTest.assertEquals((int)14, (int)result.attribute(0).numValues());
        StringToNominalTest.assertEquals((int)8, (int)result.attribute(3).numValues());
        int i = 0;
        while (i < result.numInstances()) {
            StringToNominalTest.assertTrue((String)"Missing values should be preserved", (this.m_Instances.instance(i).isMissing(3) == result.instance(i).isMissing(3) ? 1 : 0) != 0);
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isString()) {
                    ((StringToNominal)this.m_FilteredClassifier.getFilter()).setAttributeRange("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            StringToNominalTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(StringToNominalTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StringToNominalTest.suite());
    }
}

