/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveFrequentValues;

public class RemoveFrequentValuesTest
extends AbstractFilterTest {
    private static final int indexString = 0;
    private static final int indexNumeric = 2;
    private static final int indexNominal = 4;

    public RemoveFrequentValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        RemoveFrequentValues f = new RemoveFrequentValues();
        f.setAttributeIndex(Integer.toString(5));
        f.setNumValues(3);
        return f;
    }

    public void testString() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((RemoveFrequentValues)this.m_Filter).setAttributeIndex(Integer.toString(1));
            this.m_Filter.setInputFormat(icopy);
            RemoveFrequentValuesTest.fail((String)"Should have thrown an exception selecting on a STRING attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNominal() {
        Instances result;
        ((RemoveFrequentValues)this.m_Filter).setAttributeIndex(Integer.toString(4));
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter();
        try {
            this.m_Filter.setInputFormat(icopy);
            result = this.useFilter();
            RemoveFrequentValuesTest.assertEquals((String)"Doesn't modify the header, i.e. removing labels", (int)this.m_Instances.attribute(4).numValues(), (int)result.attribute(4).numValues());
        }
        catch (Exception exception) {
            // empty catch block
        }
        icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter();
        try {
            ((RemoveFrequentValues)this.m_Filter).setModifyHeader(true);
            this.m_Filter.setInputFormat(icopy);
            result = this.useFilter();
            RemoveFrequentValuesTest.assertEquals((String)("Returns " + ((RemoveFrequentValues)this.m_Filter).getNumValues() + " out of the " + this.m_Instances.attribute(4).numValues() + " labels"), (int)((RemoveFrequentValues)this.m_Filter).getNumValues(), (int)result.attribute(4).numValues());
        }
        catch (Exception exception) {
            // empty catch block
        }
        icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter();
        try {
            ((RemoveFrequentValues)this.m_Filter).setModifyHeader(true);
            ((RemoveFrequentValues)this.m_Filter).setUseLeastValues(true);
            this.m_Filter.setInputFormat(icopy);
            result = this.useFilter();
            RemoveFrequentValuesTest.assertEquals((String)("Returns " + ((RemoveFrequentValues)this.m_Filter).getNumValues() + " out of the " + this.m_Instances.attribute(4).numValues() + " labels"), (int)((RemoveFrequentValues)this.m_Filter).getNumValues(), (int)result.attribute(4).numValues());
        }
        catch (Exception exception) {
            // empty catch block
        }
        icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter();
        try {
            ((RemoveFrequentValues)this.m_Filter).setModifyHeader(true);
            ((RemoveFrequentValues)this.m_Filter).setUseLeastValues(true);
            ((RemoveFrequentValues)this.m_Filter).setInvertSelection(true);
            ((RemoveFrequentValues)this.m_Filter).setNumValues(4);
            this.m_Filter.setInputFormat(icopy);
            result = this.useFilter();
            RemoveFrequentValuesTest.assertEquals((String)("Returns 1 out of the " + this.m_Instances.attribute(4).numValues() + " labels, even though we try to remove " + ((RemoveFrequentValues)this.m_Filter).getNumValues() + " labels, since it always returns at least 1 label"), (int)1, (int)result.attribute(4).numValues());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNumeric() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((RemoveFrequentValues)this.m_Filter).setAttributeIndex(Integer.toString(3));
            this.m_Filter.setInputFormat(icopy);
            RemoveFrequentValuesTest.fail((String)"Should have thrown an exception selecting on a NUMERIC attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((RemoveFrequentValues)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            RemoveFrequentValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(RemoveFrequentValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RemoveFrequentValuesTest.suite());
    }
}

