/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.PostProcessor;
import ai.djl.translate.PreProcessor;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;

public class BasicTranslator<I, O>
implements Translator<I, O> {
    private PreProcessor<I> preProcessor;
    private PostProcessor<O> postProcessor;
    private Batchifier batchifier;

    public BasicTranslator(PreProcessor<I> preProcessor, PostProcessor<O> postProcessor) {
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
    }

    public BasicTranslator(PreProcessor<I> preProcessor, PostProcessor<O> postProcessor, Batchifier batchifier) {
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.batchifier = batchifier;
    }

    @Override
    public O processOutput(TranslatorContext ctx, NDList list) throws Exception {
        return this.postProcessor.processOutput(ctx, list);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, I input) throws Exception {
        return this.preProcessor.processInput(ctx, input);
    }

    @Override
    public Batchifier getBatchifier() {
        if (this.batchifier != null) {
            return this.batchifier;
        }
        return Translator.super.getBatchifier();
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        if (this.preProcessor instanceof Translator) {
            ((Translator)this.preProcessor).prepare(ctx);
        }
        if (this.postProcessor instanceof Translator && this.postProcessor != this.preProcessor) {
            ((Translator)this.postProcessor).prepare(ctx);
        }
    }
}

