/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import ai.djl.util.PairList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class QaServingTranslator
implements NoBatchifyTranslator<Input, Output> {
    private static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    private Translator<QAInput, String> translator;

    public QaServingTranslator(Translator<QAInput, String> translator) {
        this.translator = translator;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        QAInput qa;
        block10: {
            int pos;
            PairList<String, BytesSupplier> content = input.getContent();
            if (content.isEmpty()) {
                throw new TranslateException("Input data is empty.");
            }
            String contentType = input.getProperty("Content-Type", null);
            if (contentType != null && (pos = contentType.indexOf(59)) > 0) {
                contentType = contentType.substring(0, pos);
            }
            if ("application/json".equals(contentType)) {
                String json = input.getData().getAsString();
                try {
                    JsonElement element = (JsonElement)JsonUtils.GSON.fromJson(json, JsonElement.class);
                    if (element.isJsonArray()) {
                        ctx.setAttachment("batch", Boolean.TRUE);
                        List inputs = (List)JsonUtils.GSON.fromJson(json, LIST_TYPE);
                        return this.translator.batchProcessInput(ctx, inputs);
                    }
                    qa = (QAInput)JsonUtils.GSON.fromJson(json, QAInput.class);
                    if (qa.getQuestion() == null || qa.getParagraph() == null) {
                        throw new TranslateException("Missing question or context in json.");
                    }
                    break block10;
                }
                catch (JsonParseException e) {
                    throw new TranslateException("Input is not a valid json.", e);
                }
            }
            String question = input.getAsString("question");
            String context = input.getAsString("context");
            if (context == null) {
                context = input.getAsString("paragraph");
            }
            if (question == null || context == null) {
                throw new TranslateException("Missing question or context in input.");
            }
            qa = new QAInput(question, context);
        }
        NDList ret = this.translator.processInput(ctx, qa);
        Batchifier batchifier = this.translator.getBatchifier();
        if (batchifier != null) {
            NDList[] batch = new NDList[]{ret};
            return batchifier.batchify(batch);
        }
        return ret;
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        output.addProperty("Content-Type", "application/json");
        if (ctx.getAttachment("batch") != null) {
            output.add(BytesSupplier.wrapAsJson(this.translator.batchProcessOutput(ctx, list)));
        } else {
            Batchifier batchifier = this.translator.getBatchifier();
            if (batchifier != null) {
                list = batchifier.unbatchify(list)[0];
            }
            output.add((String)this.translator.processOutput(ctx, list));
        }
        return output;
    }
}

