/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.rl.env;

import ai.djl.modality.rl.ActionSpace;
import ai.djl.modality.rl.agent.RlAgent;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;

public interface RlEnv
extends AutoCloseable {
    public void reset();

    public NDList getObservation();

    public ActionSpace getActionSpace();

    public Step step(NDList var1, boolean var2);

    default public float runEnvironment(RlAgent agent, boolean training) {
        Step step;
        float totalReward = 0.0f;
        this.reset();
        do {
            NDList action = agent.chooseAction(this, training);
            step = this.step(action, training);
            totalReward += step.getReward().getFloat(new long[0]);
        } while (!step.isDone());
        return totalReward;
    }

    public Step[] getBatch();

    @Override
    public void close();

    public static interface Step
    extends AutoCloseable {
        public NDList getPreObservation();

        public NDList getAction();

        public NDList getPostObservation();

        public ActionSpace getPostActionSpace();

        public NDArray getReward();

        public boolean isDone();

        @Override
        public void close();
    }
}

