/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.tabular.CsvDataset;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.Progress;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public final class MovieLens100k
extends CsvDataset {
    private static final String ARTIFACT_ID = "movielens-100k";
    private static final String VERSION = "1.0";
    private static final String[] USER_FEATURES = new String[]{"user_id", "user_age", "user_gender", "user_occupation", "user_zipcode"};
    private static final String[] MOVIE_FEATURES = new String[]{"movie_id", "movie_title", "movie_release_date", "movie_video_release_date", "imdb_url", "unknown", "action", "adventure", "animation", "childrens", "comedy", "crime", "documentary", "drama", "fantasy", "film-noir", "horror", "musical", "mystery", "romance", "sci-fi", "thriller", "war", "western"};
    private Dataset.Usage usage;
    private MRL mrl;
    private boolean prepared;
    private Map<String, Map<String, String>> userFeaturesMap;
    private Map<String, Map<String, String>> movieFeaturesMap;

    MovieLens100k(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    @Override
    protected String getCell(long rowIndex, String featureName) {
        CSVRecord record = (CSVRecord)this.csvRecords.get(Math.toIntExact(rowIndex));
        if (HeaderEnum.rating.toString().equals(featureName)) {
            return record.get((Enum)HeaderEnum.rating);
        }
        if (featureName.startsWith("user")) {
            String userId = record.get((Enum)HeaderEnum.user_id);
            return this.userFeaturesMap.get(userId).get(featureName);
        }
        String movieId = record.get((Enum)HeaderEnum.movie_id);
        return this.movieFeaturesMap.get(movieId).get(featureName);
    }

    @Override
    public void prepare(Progress progress) throws IOException {
        Path csvFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Path dir = this.mrl.getRepository().getResourceDirectory(artifact);
        Path root = dir.resolve("ml-100k/ml-100k");
        Path userFeaturesFile = root.resolve("u.user");
        this.userFeaturesMap = this.prepareFeaturesMap(userFeaturesFile, USER_FEATURES);
        Path movieFeaturesFile = root.resolve("u.item");
        this.movieFeaturesMap = this.prepareFeaturesMap(movieFeaturesFile, MOVIE_FEATURES);
        switch (this.usage) {
            case TRAIN: {
                csvFile = root.resolve("ua.base");
                break;
            }
            case TEST: {
                csvFile = root.resolve("ua.test");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available");
            }
        }
        this.csvUrl = csvFile.toUri().toURL();
        super.prepare(progress);
        this.prepared = true;
    }

    private Map<String, Map<String, String>> prepareFeaturesMap(Path featureFile, String[] featureNames) throws IOException {
        URL featureFileUrl = featureFile.toUri().toURL();
        CSVFormat format = CSVFormat.Builder.create((CSVFormat)CSVFormat.newFormat((char)'|')).build();
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(featureFileUrl.openStream()), StandardCharsets.UTF_8);
        CSVParser csvParser = new CSVParser((Reader)reader, format);
        List featureRecords = csvParser.getRecords();
        ConcurrentHashMap<String, Map<String, String>> featuresMap = new ConcurrentHashMap<String, Map<String, String>>();
        for (CSVRecord record : featureRecords) {
            ConcurrentHashMap<String, String> featureValues = new ConcurrentHashMap<String, String>();
            for (int i = 0; i < featureNames.length; ++i) {
                featureValues.put(featureNames[i], record.get(i));
            }
            featuresMap.put(record.get(0), featureValues);
        }
        return featuresMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvDataset.CsvBuilder<Builder> {
        Repository repository;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "movielens-100k";
        Dataset.Usage usage;
        List<String> featureArray = new ArrayList<String>(Arrays.asList("user_age", "user_gender", "user_occupation", "user_zipcode", "movie_title", "movie_genres"));
        List<String> movieGenres = new ArrayList<String>(Arrays.asList("unknown", "action", "adventure", "animation", "childrens", "comedy", "crime", "documentary", "drama", "fantasy", "film-noir", "horror", "musical", "mystery", "romance", "sci-fi", "thriller", "war", "western"));

        Builder() {
            this.repository = BasicDatasets.REPOSITORY;
            this.usage = Dataset.Usage.TRAIN;
            this.csvFormat = CSVFormat.TDF.builder().setHeader(HeaderEnum.class).setQuote(null).build();
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this.self();
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this.self();
        }

        public List<String> getAvailableFeatures() {
            return this.featureArray;
        }

        public Builder addFeature(String name) {
            if (this.getAvailableFeatures().contains(name)) {
                switch (name) {
                    case "user_age": {
                        this.addNumericFeature(name);
                        break;
                    }
                    case "user_gender": 
                    case "user_occupation": {
                        this.addCategoricalFeature(name, true);
                        break;
                    }
                    case "user_zipcode": 
                    case "movie_title": {
                        this.addCategoricalFeature(name, false);
                        break;
                    }
                    case "movie_genres": {
                        this.movieGenres.forEach(genre -> this.addNumericFeature((String)genre));
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException(String.format("Provided feature %s is not valid. Valid features are: %s", name, this.featureArray));
            }
            return this.self();
        }

        @Override
        public MovieLens100k build() {
            if (this.features.isEmpty()) {
                this.featureArray.forEach(feature -> this.addFeature((String)feature));
            }
            if (this.labels.isEmpty()) {
                this.addCategoricalLabel("rating", true);
            }
            return new MovieLens100k(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.Tabular.ANY, this.groupId, this.artifactId, MovieLens100k.VERSION);
        }
    }

    static enum HeaderEnum {
        user_id,
        movie_id,
        rating,
        timestamp;

    }
}

