/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.nlp;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.tabular.CsvDataset;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.csv.CSVFormat;

public class AmazonReview
extends CsvDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "amazon_reviews";
    private MRL mrl;
    private String datasetName;
    private boolean prepared;

    protected AmazonReview(Builder builder) {
        super(builder);
        this.mrl = builder.getMrl();
        this.datasetName = builder.datasetName;
    }

    @Override
    public void prepare(Progress progress) throws IOException {
        if (this.prepared) {
            return;
        }
        ConcurrentHashMap<String, String> filter = new ConcurrentHashMap<String, String>();
        filter.put("dataset", this.datasetName);
        Artifact artifact = Objects.requireNonNull(this.mrl.match(filter));
        this.mrl.prepare(artifact, progress);
        Path dir = this.mrl.getRepository().getResourceDirectory(artifact);
        Path csvFile = dir.resolve(((Artifact.Item)artifact.getFiles().values().iterator().next()).getName());
        this.csvUrl = csvFile.toUri().toURL();
        super.prepare(progress);
        this.prepared = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvDataset.CsvBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "amazon_reviews";
        String datasetName;

        Builder() {
            this.csvFormat = CSVFormat.TDF.builder().setQuote(null).setHeader(new String[0]).build();
            this.datasetName = "us_Digital_Software";
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optDatasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        @Override
        public AmazonReview build() {
            if (this.features.isEmpty()) {
                throw new IllegalStateException("Missing features.");
            }
            if (this.labels.isEmpty()) {
                this.addNumericLabel("star_rating");
            }
            return new AmazonReview(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.NLP.ANY, this.groupId, this.artifactId, AmazonReview.VERSION);
        }
    }
}

