/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.nlp;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.nlp.TextDataset;
import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.Record;
import ai.djl.util.Progress;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;

public class PennTreebankText
extends TextDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "penntreebank-unlabeled-processed";

    PennTreebankText(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Record get(NDManager manager, long index) throws IOException {
        NDList data = new NDList();
        NDList labels = null;
        data.add((Object)this.sourceTextData.getEmbedding(manager, index));
        return new Record(data, labels);
    }

    protected long availableSize() {
        return this.sourceTextData.getSize();
    }

    public void prepare(Progress progress) throws IOException, EmbeddingException {
        Artifact.Item item;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        switch (this.usage) {
            case TRAIN: {
                item = (Artifact.Item)artifact.getFiles().get("train");
                break;
            }
            case TEST: {
                item = (Artifact.Item)artifact.getFiles().get("test");
                break;
            }
            case VALIDATION: {
                item = (Artifact.Item)artifact.getFiles().get("valid");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported usage type.");
            }
        }
        Path path = this.mrl.getRepository().getFile(item, "").toAbsolutePath();
        ArrayList<String> lineArray = new ArrayList<String>();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String row;
            while ((row = reader.readLine()) != null) {
                lineArray.add(row);
            }
        }
        this.preprocess(lineArray, true);
        this.prepared = true;
    }

    public static class Builder
    extends TextDataset.Builder<Builder> {
        public Builder() {
            this.repository = BasicDatasets.REPOSITORY;
            this.groupId = "ai.djl.basicdataset";
            this.artifactId = PennTreebankText.ARTIFACT_ID;
            this.usage = Dataset.Usage.TRAIN;
        }

        public PennTreebankText build() {
            return new PennTreebankText(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.NLP.ANY, this.groupId, this.artifactId, PennTreebankText.VERSION);
        }

        protected Builder self() {
            return this;
        }
    }
}

