/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.zoo;

import ai.djl.repository.Repository;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.zoo.cv.classification.MlpModelLoader;
import ai.djl.zoo.cv.classification.ResNetModelLoader;
import ai.djl.zoo.cv.object_detection.ssd.SingleShotDetectionModelLoader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public interface ModelZoo {
    public static final String REPO_URL = "https://mlrepo.djl.ai/";
    public static final Repository REPOSITORY = Repository.newInstance((String)"zoo", (String)"https://mlrepo.djl.ai/");
    public static final String GROUP_ID = "ai.djl.zoo";
    public static final ResNetModelLoader RESNET = new ResNetModelLoader(REPOSITORY);
    public static final MlpModelLoader MLP = new MlpModelLoader(REPOSITORY);
    public static final SingleShotDetectionModelLoader SSD = new SingleShotDetectionModelLoader(REPOSITORY);

    public static <I, O> ModelLoader<I, O> getModelLoader(String name) throws ModelNotFoundException {
        try {
            Field field = ModelZoo.class.getDeclaredField(name);
            return (ModelLoader)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new ModelNotFoundException("Model: " + name + " is not defined in MxModelZoo.", (Throwable)e);
        }
    }

    public static List<ModelLoader<?, ?>> listModels() {
        ArrayList list = new ArrayList();
        try {
            Field[] fields;
            for (Field field : fields = ModelZoo.class.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(ModelLoader.class)) continue;
                list.add((ModelLoader)field.get(null));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return list;
    }
}

