/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.Device;

public final class DeviceType {
    private static final String CPU_PINNED = "cpu_pinned";

    private DeviceType() {
    }

    public static int toDeviceType(Device device) {
        String deviceType = device.getDeviceType();
        if (Device.cpu().getDeviceType().equals(deviceType)) {
            return 1;
        }
        if (Device.gpu().getDeviceType().equals(deviceType)) {
            return 2;
        }
        if (CPU_PINNED.equals(deviceType)) {
            return 3;
        }
        throw new IllegalArgumentException("Unsupported device: " + device.toString());
    }

    public static String fromDeviceType(int deviceType) {
        switch (deviceType) {
            case 1: {
                return Device.cpu().getDeviceType();
            }
            case 2: {
                return Device.gpu().getDeviceType();
            }
            case 3: {
                return CPU_PINNED;
            }
        }
        throw new IllegalArgumentException("Unsupported deviceType: " + deviceType);
    }
}

