/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo;

import ai.djl.mxnet.zoo.cv.actionrecognition.ActionRecognitionModelLoader;
import ai.djl.mxnet.zoo.cv.classification.Mlp;
import ai.djl.mxnet.zoo.cv.classification.Resnet;
import ai.djl.mxnet.zoo.cv.classification.Resnext;
import ai.djl.mxnet.zoo.cv.classification.SeResnext;
import ai.djl.mxnet.zoo.cv.classification.Senet;
import ai.djl.mxnet.zoo.cv.classification.Squeezenet;
import ai.djl.mxnet.zoo.cv.objectdetection.SingleShotDetectionModelLoader;
import ai.djl.mxnet.zoo.cv.poseestimation.SimplePoseModelLoader;
import ai.djl.mxnet.zoo.cv.segmentation.InstanceSegmentationModelLoader;
import ai.djl.mxnet.zoo.nlp.qa.BertQAModelLoader;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public interface MxModelZoo {
    public static final String MXNET_REPO_URL = "https://mlrepo.djl.ai/";
    public static final Repository REPOSITORY = Repository.newInstance((String)"MxNet", (String)"https://mlrepo.djl.ai/");
    public static final String GROUP_ID = "ai.djl.mxnet";
    public static final Mlp MLP = new Mlp(REPOSITORY);
    public static final SingleShotDetectionModelLoader SSD = new SingleShotDetectionModelLoader(REPOSITORY);
    public static final Resnet RESNET = new Resnet(REPOSITORY);
    public static final Resnext RESNEXT = new Resnext(REPOSITORY);
    public static final Senet SENET = new Senet(REPOSITORY);
    public static final SeResnext SE_RESNEXT = new SeResnext(REPOSITORY);
    public static final Squeezenet SQUEEZENET = new Squeezenet(REPOSITORY);
    public static final SimplePoseModelLoader SIMPLE_POSE = new SimplePoseModelLoader(REPOSITORY);
    public static final InstanceSegmentationModelLoader MASK_RCNN = new InstanceSegmentationModelLoader(REPOSITORY);
    public static final ActionRecognitionModelLoader ACTION_RECOGNITION = new ActionRecognitionModelLoader(REPOSITORY);
    public static final BertQAModelLoader BERT_QA = new BertQAModelLoader(REPOSITORY);

    public static <I, O> ModelLoader<I, O> getModelLoader(String name) throws ModelNotFoundException {
        try {
            Field field = MxModelZoo.class.getDeclaredField(name);
            return (ModelLoader)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new ModelNotFoundException("Model: " + name + " is not defined in MxModelZoo.", (Throwable)e);
        }
    }

    public static List<ModelLoader<?, ?>> listModels() {
        ArrayList list = new ArrayList();
        try {
            Field[] fields;
            for (Field field : fields = MxModelZoo.class.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(ModelLoader.class)) continue;
                list.add((ModelLoader)field.get(null));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return list;
    }
}

