/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.cv.classification;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.ImageClassificationTranslator;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.repository.Anchor;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import java.awt.image.BufferedImage;
import java.util.Map;

public abstract class ImageClassificationModelLoader
extends BaseModelLoader<BufferedImage, Classifications> {
    private static final Anchor BASE_ANCHOR = MRL.Model.CV.IMAGE_CLASSIFICATION;
    private static final String GROUP_ID = "ai.djl.mxnet";

    public ImageClassificationModelLoader(Repository repository, String artifactId, String version) {
        super(repository, new MRL(BASE_ANCHOR, GROUP_ID, artifactId), version);
    }

    public Translator<BufferedImage, Classifications> getTranslator(Artifact artifact) {
        Map arguments = artifact.getArguments();
        int width = arguments.getOrDefault("width", 224.0).intValue();
        int height = arguments.getOrDefault("height", 224.0).intValue();
        String flag = arguments.getOrDefault("flag", NDImageUtils.Flag.COLOR.name());
        Pipeline pipeline = new Pipeline();
        pipeline.add((Transform)new CenterCrop()).add((Transform)new Resize(width, height)).add((Transform)new ToTensor());
        return ((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)new ImageClassificationTranslator.Builder().optFlag(NDImageUtils.Flag.valueOf((String)flag))).setPipeline(pipeline)).setSynsetArtifactName("synset.txt").build();
    }
}

