/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.cv.objectdetection;

import ai.djl.modality.cv.DetectedObjects;
import ai.djl.modality.cv.SingleShotDetectionTranslator;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.Anchor;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import java.awt.image.BufferedImage;
import java.util.Map;

public class SingleShotDetectionModelLoader
extends BaseModelLoader<BufferedImage, DetectedObjects> {
    private static final Anchor BASE_ANCHOR = MRL.Model.CV.OBJECT_DETECTION;
    private static final String GROUP_ID = "ai.djl.mxnet";
    private static final String ARTIFACT_ID = "ssd";
    private static final String VERSION = "0.0.1";

    public SingleShotDetectionModelLoader(Repository repository) {
        super(repository, new MRL(BASE_ANCHOR, GROUP_ID, ARTIFACT_ID), VERSION);
    }

    public Translator<BufferedImage, DetectedObjects> getTranslator(Artifact artifact) {
        Map arguments = artifact.getArguments();
        int width = arguments.getOrDefault("width", 512.0).intValue();
        int height = arguments.getOrDefault("height", 512.0).intValue();
        double threshold = arguments.getOrDefault("threshold", 0.2);
        Pipeline pipeline = new Pipeline();
        pipeline.add((Transform)new Resize(width, height)).add((Transform)new ToTensor());
        return ((SingleShotDetectionTranslator.Builder)new SingleShotDetectionTranslator.Builder().setPipeline(pipeline)).setSynsetArtifactName("classes.txt").optThreshold((float)threshold).optRescaleSize((double)width, (double)height).build();
    }
}

