/*
 * Decompiled with CFR 0.152.
 */
package hex.anovaglm;

import hex.DataInfo;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsRegressionGLM;
import hex.anovaglm.ANOVAGLMModel;
import hex.gam.MatrixFrameUtils.GAMModelUtils;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.genmodel.utils.MathUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.fvec.Frame;

public class ANOVAGLMUtils {
    public static String[] extractPredNames(DataInfo dinfo, int numOfPredictors) {
        String[] predNames = new String[numOfPredictors];
        String[] frameNames = dinfo._adaptedFrame.names();
        System.arraycopy(frameNames, 0, predNames, 0, numOfPredictors);
        return predNames;
    }

    public static String[][] generatePredictorCombos(String[] predNamesIndividual, int maxPredInt) {
        ArrayList<String[]> predCombo = new ArrayList<String[]>();
        ANOVAGLMUtils.addIndividualPred(predNamesIndividual, predCombo);
        for (int index = 2; index <= maxPredInt; ++index) {
            ANOVAGLMUtils.generateOneCombo(predNamesIndividual, index, predCombo);
        }
        return (String[][])predCombo.toArray((T[])new String[0][0]);
    }

    public static void addIndividualPred(String[] predNames, List<String[]> predCombo) {
        int numPred = predNames.length;
        for (int index = 0; index < numPred; ++index) {
            predCombo.add(new String[]{predNames[index]});
        }
    }

    public static void generateOneCombo(String[] predNames, int numInteract, List<String[]> predCombo) {
        int predNum = predNames.length;
        int[] predInd = IntStream.range(0, numInteract).toArray();
        int zeroBound = predNum - numInteract;
        int[] bounds = IntStream.range(zeroBound, predNum).toArray();
        int numCombo = MathUtils.combinatorial((int)predNum, (int)numInteract);
        for (int index = 0; index < numCombo; ++index) {
            predCombo.add(ANOVAGLMUtils.predCombo(predNames, predInd));
            if (!ANOVAGLMUtils.updatePredCombo(predInd, bounds)) break;
        }
    }

    public static boolean updatePredCombo(int[] predInd, int[] bounds) {
        int predNum;
        for (int index = predNum = predInd.length - 1; index >= 0; --index) {
            if (predInd[index] >= bounds[index]) continue;
            int n = index;
            predInd[n] = predInd[n] + 1;
            ANOVAGLMUtils.updateLaterBits(predInd, bounds, index, predNum);
            return true;
        }
        return false;
    }

    public static void updateLaterBits(int[] predInd, int[] bounds, int index, int predNum) {
        if (index < predNum) {
            for (int ind = index + 1; ind <= predNum; ++ind) {
                predInd[ind] = predInd[ind - 1] + 1;
            }
        }
    }

    public static String[] predCombo(String[] predNames, int[] predInd) {
        int predNum = predInd.length;
        String[] predCombos = new String[predNum];
        for (int index = 0; index < predNum; ++index) {
            predCombos[index] = predNames[predInd[index]];
        }
        return predCombos;
    }

    public static int calculatePredComboNumber(int numPred, int highestInteractionTerms) {
        int numCombo = numPred;
        for (int index = 2; index <= highestInteractionTerms; ++index) {
            numCombo += MathUtils.combinatorial((int)numPred, (int)index);
        }
        return numCombo;
    }

    public static Frame[] buildTrainingFrames(Key<Frame> transformedCols, int numberOfModels, String[][] transformedColNames, ANOVAGLMModel.ANOVAGLMParameters parms) {
        int index;
        Frame allCols;
        Frame[] trainingFrames = new Frame[numberOfModels];
        int numFrames2Build = numberOfModels - 1;
        trainingFrames[numFrames2Build] = allCols = (Frame)DKV.getGet(transformedCols);
        int[][] predNums = new int[numFrames2Build][];
        for (index = 0; index < numFrames2Build; ++index) {
            predNums[index] = ANOVAGLMUtils.oneIndexOut(index, numFrames2Build);
        }
        for (index = 0; index < numFrames2Build; ++index) {
            trainingFrames[index] = ANOVAGLMUtils.buildSpecificFrame(predNums[index], allCols, transformedColNames, parms);
            DKV.put((Keyed)trainingFrames[index]);
        }
        return trainingFrames;
    }

    public static int[] oneIndexOut(int currIndex, int indexRange) {
        int[] indexArray = new int[indexRange - 1];
        int count = 0;
        for (int index = 0; index < indexRange; ++index) {
            if (index == currIndex) continue;
            indexArray[count++] = index;
        }
        return indexArray;
    }

    public static void fillModelMetrics(ANOVAGLMModel aModel, GLMModel glmModel, Frame trainingFrame) {
        ((ANOVAGLMModel.ANOVAGLMModelOutput)aModel._output)._training_metrics = ((GLMModel.GLMOutput)glmModel._output)._training_metrics;
        for (Key modelMetricsKey : ((GLMModel.GLMOutput)glmModel._output).getModelMetrics()) {
            aModel.addModelMetrics(((ModelMetrics)modelMetricsKey.get()).deepCloneWithDifferentModelAndFrame((Model)glmModel, trainingFrame));
        }
        ((ANOVAGLMModel.ANOVAGLMModelOutput)aModel._output)._scoring_history = GAMModelUtils.copyTwoDimTable(((GLMModel.GLMOutput)glmModel._output)._scoring_history, "glm scoring history");
    }

    public static GLMModel[] extractGLMModels(GLM[] glmResults) {
        int numberModel = glmResults.length;
        GLMModel[] models = new GLMModel[numberModel];
        for (int index = 0; index < numberModel; ++index) {
            models[index] = (GLMModel)glmResults[index].get();
            Scope.track_generic((Keyed)models[index]);
        }
        return models;
    }

    public static void removeFromDKV(Frame[] trainingFrames, int numFrame2Delete) {
        for (int index = 0; index < numFrame2Delete; ++index) {
            DKV.remove((Key)trainingFrames[index]._key);
        }
    }

    public static Frame buildSpecificFrame(int[] predNums, Frame allCols, String[][] transformedColNames, ANOVAGLMModel.ANOVAGLMParameters parms) {
        Frame predVecs = new Frame(Key.make());
        for (int predVecNum : predNums) {
            predVecs.add(allCols.subframe(transformedColNames[predVecNum]));
        }
        if (parms._weights_column != null) {
            predVecs.add(parms._weights_column, allCols.vec(parms._weights_column));
        }
        if (parms._offset_column != null) {
            predVecs.add(parms._offset_column, allCols.vec(parms._offset_column));
        }
        predVecs.add(parms._response_column, allCols.vec(parms._response_column));
        return predVecs;
    }

    public static GLMModel.GLMParameters[] buildGLMParameters(Frame[] trainingFrames, ANOVAGLMModel.ANOVAGLMParameters parms) {
        int numberOfModels = trainingFrames.length;
        GLMModel.GLMParameters[] glmParams = new GLMModel.GLMParameters[numberOfModels];
        List<String> anovaglmOnlyList = Arrays.asList("save_transformed_framekeys", "type");
        Field[] field1 = ANOVAGLMModel.ANOVAGLMParameters.class.getDeclaredFields();
        Field[] field2 = Model.Parameters.class.getDeclaredFields();
        for (int index = 0; index < numberOfModels; ++index) {
            glmParams[index] = new GLMModel.GLMParameters();
            GamUtils.setParamField(parms, glmParams[index], false, field1, anovaglmOnlyList);
            GamUtils.setParamField(parms, glmParams[index], true, field2, Collections.emptyList());
            glmParams[index]._train = trainingFrames[index]._key;
            glmParams[index]._family = parms._family;
        }
        return glmParams;
    }

    public static double[] generateGLMSS(GLMModel[] glmModels, GLMModel.GLMParameters.Family family) {
        int index;
        int numModels = glmModels.length;
        int lastModelIndex = numModels - 1;
        double[] modelSS = new double[numModels];
        double[] rss = new double[numModels];
        for (index = 0; index < numModels; ++index) {
            rss[index] = GLMModel.GLMParameters.Family.binomial.equals((Object)family) || GLMModel.GLMParameters.Family.quasibinomial.equals((Object)family) || GLMModel.GLMParameters.Family.fractionalbinomial.equals((Object)family) ? ((ModelMetricsBinomialGLM)((GLMModel.GLMOutput)glmModels[index]._output)._training_metrics).residual_deviance() : ((ModelMetricsRegressionGLM)((GLMModel.GLMOutput)glmModels[index]._output)._training_metrics).residual_deviance();
        }
        for (index = 0; index < lastModelIndex; ++index) {
            modelSS[index] = rss[index] - rss[lastModelIndex];
        }
        modelSS[lastModelIndex] = rss[lastModelIndex];
        return modelSS;
    }

    public static GLM[] buildGLMBuilders(GLMModel.GLMParameters[] glmParams) {
        int numModel = glmParams.length;
        GLM[] builder = new GLM[numModel];
        for (int index = 0; index < numModel; ++index) {
            builder[index] = new GLM(glmParams[index]);
        }
        return builder;
    }

    public static void generatePredictorNames(String[][] predComboNames, String[][] predictorNames, int[] predColumnStart, int[] degreeOfFreedom, DataInfo dinfo) {
        int predNums = predComboNames.length;
        int colStart = 0;
        for (int predInd = 0; predInd < predNums; ++predInd) {
            predictorNames[predInd] = predComboNames[predInd].length == 1 ? (dinfo._adaptedFrame.vec(predComboNames[predInd][0]).domain() == null ? new String[]{predComboNames[predInd][0]} : ANOVAGLMUtils.transformOneCol(dinfo._adaptedFrame, predComboNames[predInd][0])) : ANOVAGLMUtils.transformMultipleCols(dinfo._adaptedFrame, predComboNames, predInd, predictorNames);
            colStart = ANOVAGLMUtils.updateDOFColInfo(predInd, predictorNames[predInd], degreeOfFreedom, predColumnStart, colStart);
        }
    }

    public static int updateDOFColInfo(int predInd, String[] predComboNames, int[] dof, int[] predCS, int offset) {
        dof[predInd] = predComboNames.length;
        predCS[predInd] = offset;
        return dof[predInd] + offset;
    }

    public static int findComboMatch(String[][] predComboNames, int currIndex) {
        String[] currCombo = predComboNames[currIndex];
        int startPos = 1;
        for (int comboSize = currCombo.length - 1; comboSize >= 0; --comboSize) {
            Object[] smallerCurrCombo = Arrays.copyOfRange(currCombo, startPos++, currCombo.length);
            for (int sInd = currIndex - 1; sInd >= 0; --sInd) {
                if (!Arrays.equals(smallerCurrCombo, predComboNames[sInd])) continue;
                return sInd;
            }
        }
        return -1;
    }

    public static String[] combineAndFlat(String[][] predictComboNames) {
        int numCombos = predictComboNames.length;
        String[] finalPredNames = new String[numCombos];
        for (int index = 0; index < numCombos; ++index) {
            String start = predictComboNames[index][0];
            if (predictComboNames[index].length > 1) {
                for (int subIndex = 1; subIndex < predictComboNames[index].length; ++subIndex) {
                    start = start + ":" + predictComboNames[index][subIndex];
                }
            }
            finalPredNames[index] = start;
        }
        return finalPredNames;
    }

    public static String[] transformMultipleCols(Frame vec2Transform, String[][] predComboNames, int currIndex, String[][] predNames) {
        String[] currPredCombo = predComboNames[currIndex];
        int matchPreviousCombo = ANOVAGLMUtils.findComboMatch(predComboNames, currIndex);
        String[] matchPredNames = predNames[matchPreviousCombo];
        String[] searchPair = new String[]{currPredCombo[0], currPredCombo[1]};
        return ANOVAGLMUtils.transformTwoCols(vec2Transform, searchPair, matchPredNames);
    }

    public static String[] transformTwoCols(Frame vec2Transform, String[] vecNames, String[] lastComboNames) {
        String[] domains1 = vec2Transform.vec(vecNames[0]).domain();
        String[] domains2 = lastComboNames == null ? vec2Transform.vec(vecNames[1]).domain() : lastComboNames;
        String colName1 = vecNames[0];
        String colName2 = vecNames[1];
        int degOfFreedomC1 = domains1 == null ? 1 : domains1.length - 1;
        int degOfFreedomC2 = lastComboNames == null ? domains2.length - 1 : domains2.length;
        String[] newColNames = new String[degOfFreedomC1 * degOfFreedomC2];
        int colIndex = 0;
        for (int col1 = 0; col1 < degOfFreedomC1; ++col1) {
            String part1 = colName1;
            if (domains1 != null) {
                part1 = colName1 + "_" + domains1[col1];
            }
            for (int col2 = 0; col2 < degOfFreedomC2; ++col2) {
                if (lastComboNames == null) {
                    if (domains2 == null) {
                        newColNames[colIndex++] = part1 + ":" + colName2;
                        continue;
                    }
                    newColNames[colIndex++] = part1 + ":" + colName2 + "_" + domains2[col2];
                    continue;
                }
                newColNames[colIndex++] = part1 + ":" + domains2[col2];
            }
        }
        return newColNames;
    }

    public static String[] transformOneCol(Frame vec2Transform, String vecName) {
        String[] domains = vec2Transform.vec(vecName).domain();
        int degOfFreedom = domains.length - 1;
        String[] newColNames = new String[degOfFreedom];
        for (int domainInd = 0; domainInd < degOfFreedom; ++domainInd) {
            newColNames[domainInd] = vecName + "_" + domains[domainInd];
        }
        return newColNames;
    }

    public static String[] generateModelNames(String[][] predictComboNames) {
        int numPredCombo = predictComboNames.length;
        String[] modelNames = new String[numPredCombo + 1];
        for (int index = 0; index < numPredCombo; ++index) {
            modelNames[index] = predictComboNames[index].length == 1 ? "GLM model built without predictor " + predictComboNames[index][0] : "GLM model built without predictors interactions " + Stream.of(predictComboNames[index]).collect(Collectors.joining(":"));
        }
        modelNames[numPredCombo] = "GLM model built with all predictors";
        return modelNames;
    }
}

