/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.gam.GAMModel;
import hex.genmodel.utils.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.ArrayUtils;

public class ThinPlateRegressionUtils {
    public static int calculatem(int d) {
        return (int)Math.floor(((double)d + 1.0) * 0.5) + 1;
    }

    public static int calculateM(int d, int m) {
        int topComb = d + m - 1;
        return MathUtils.combinatorial((int)topComb, (int)d);
    }

    public static List<Integer[]> findPolyBasis(int d, int m) {
        int polyOrder = m - 1;
        int[] possibleDegree = new int[polyOrder];
        for (int index = 1; index < m; ++index) {
            possibleDegree[index - 1] = index;
        }
        Integer[] basisPolyOrder = new Integer[d];
        ArrayList<Integer[]> totPolyBasis = new ArrayList<Integer[]>();
        for (int degree : possibleDegree) {
            ArrayList<int[]> oneCombo = new ArrayList<int[]>();
            ThinPlateRegressionUtils.findOnePerm(degree, possibleDegree, 0, oneCombo, null);
            ThinPlateRegressionUtils.mergeCombos(oneCombo, basisPolyOrder, possibleDegree, totPolyBasis);
        }
        return ThinPlateRegressionUtils.findAllPolybasis(totPolyBasis);
    }

    public static List<Integer[]> findAllPolybasis(List<Integer[]> onePolyBasis) {
        int listSize = onePolyBasis.size();
        ArrayList<Integer[]> allPermutes = new ArrayList<Integer[]>();
        for (int index = 0; index < listSize; ++index) {
            Integer[] oneBasis = onePolyBasis.get(index);
            int[] freqTable = ThinPlateRegressionUtils.generateOrderFreq(oneBasis);
            ArrayList<List<Integer>> basisPermuations = new ArrayList<List<Integer>>();
            ArrayList<Integer> prefix = new ArrayList<Integer>();
            ThinPlateRegressionUtils.findPermute(freqTable, prefix, oneBasis.length, basisPermuations);
            ThinPlateRegressionUtils.addPermutationList(allPermutes, basisPermuations);
        }
        Integer[] allZeros = new Integer[onePolyBasis.get(0).length];
        for (int index = 0; index < allZeros.length; ++index) {
            allZeros[index] = 0;
        }
        allPermutes.add(0, allZeros);
        return allPermutes;
    }

    public static void addPermutationList(List<Integer[]> onePolyBasis, List<List<Integer>> permute1Basis) {
        for (List<Integer> onePermute : permute1Basis) {
            Integer[] oneCombo = onePermute.toArray(new Integer[0]);
            onePolyBasis.add(oneCombo);
        }
    }

    public static void findPermute(int[] freqMap, List<Integer> prefix, int remaining, List<List<Integer>> basisPerm) {
        if (remaining == 0) {
            basisPerm.add(prefix);
        } else {
            for (int index = 0; index < freqMap.length; ++index) {
                int val = freqMap[index];
                if (val <= 0) continue;
                int n = index;
                freqMap[n] = freqMap[n] - 1;
                ArrayList<Integer> newPrefix = new ArrayList<Integer>(prefix);
                newPrefix.add(index);
                ThinPlateRegressionUtils.findPermute(freqMap, newPrefix, remaining - 1, basisPerm);
                freqMap[index] = val;
            }
        }
    }

    public static int[] generateOrderFreq(Integer[] oneBasis) {
        int maxVal = ArrayUtils.maxValue((Integer[])oneBasis);
        int[] mapFreq = new int[maxVal + 1];
        Integer[] integerArray = oneBasis;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int val;
            int n2 = val = integerArray[i].intValue();
            mapFreq[n2] = mapFreq[n2] + 1;
        }
        return mapFreq;
    }

    public static void mergeCombos(ArrayList<int[]> oneCombo, Integer[] basisOrder, int[] polyBasis, List<Integer[]> polyBasisSet) {
        for (int[] oneList : oneCombo) {
            Arrays.fill((Object[])basisOrder, (Object)0);
            ThinPlateRegressionUtils.expandCombo(oneList, polyBasis, basisOrder);
            polyBasisSet.add((Integer[])basisOrder.clone());
        }
    }

    public static void expandCombo(int[] oneList, int[] polyBasis, Integer[] basisOrder) {
        int expandIndex = 0;
        for (int index = 0; index < polyBasis.length; ++index) {
            if (oneList[index] == 0) {
                basisOrder[expandIndex++] = 0;
                continue;
            }
            for (int count = 0; count < oneList[index]; ++count) {
                basisOrder[expandIndex++] = polyBasis[index];
            }
        }
    }

    public static void findOnePerm(int totDegree, int[] degreeCombo, int index, ArrayList<int[]> allCombos, int[] currCombo) {
        if (totDegree == 0) {
            if (currCombo != null) {
                allCombos.add((int[])currCombo.clone());
            }
        } else if (totDegree >= 0 && index < degreeCombo.length) {
            int totPass = totDegree / degreeCombo[index];
            int degreeCount = 0;
            if (currCombo == null) {
                currCombo = (int[])degreeCombo.clone();
            }
            while (degreeCount <= totPass) {
                ThinPlateRegressionUtils.setCombo(currCombo, index, degreeCount);
                ThinPlateRegressionUtils.findOnePerm(totDegree - degreeCount * degreeCombo[index], degreeCombo, index + 1, allCombos, currCombo);
                ++degreeCount;
            }
        }
    }

    public static void setCombo(int[] currCombo, int index, int degreeCount) {
        currCombo[index] = degreeCount;
        int combSize = currCombo.length;
        for (int tempIndex = index + 1; tempIndex < combSize; ++tempIndex) {
            currCombo[tempIndex] = 0;
        }
    }

    public static double[][] generateStarT(double[][] knots, List<Integer[]> polyBasisDegree, double[] gamColMeanRaw, double[] oneOColStd, boolean standardizeTPSmoothers) {
        int numKnots = knots[0].length;
        int M = polyBasisDegree.size();
        int d = knots.length;
        double[][] knotsDemean = new double[d][numKnots];
        for (int predInd = 0; predInd < d; ++predInd) {
            for (int index = 0; index < numKnots; ++index) {
                knotsDemean[predInd][index] = standardizeTPSmoothers ? (knots[predInd][index] - gamColMeanRaw[predInd]) * oneOColStd[predInd] : knots[predInd][index] - gamColMeanRaw[predInd];
            }
        }
        double[][] starT = new double[numKnots][M];
        for (int rowInd = 0; rowInd < numKnots; ++rowInd) {
            for (int polyBasisInd = 0; polyBasisInd < M; ++polyBasisInd) {
                Integer[] oneBasis = polyBasisDegree.get(polyBasisInd);
                double polyBasisVal = 1.0;
                for (int predInd = 0; predInd < d; ++predInd) {
                    polyBasisVal *= Math.pow(knotsDemean[predInd][rowInd], oneBasis[predInd].intValue());
                }
                starT[rowInd][polyBasisInd] = polyBasisVal;
            }
        }
        return starT;
    }

    public static void fillRowOneValue(NewChunk[] newChk, int colWidth, double fillValue) {
        for (int colInd = 0; colInd < colWidth; ++colInd) {
            newChk[colInd].addNum(fillValue);
        }
    }

    public static void fillRowArray(NewChunk[] newChk, int colWidth, double[] fillValue) {
        for (int colInd = 0; colInd < colWidth; ++colInd) {
            newChk[colInd].addNum(fillValue[colInd]);
        }
    }

    public static boolean checkRowNA(Chunk[] chk, int rowIndex) {
        int numCol = chk.length;
        for (int colIndex = 0; colIndex < numCol; ++colIndex) {
            if (!Double.isNaN(chk[colIndex].atd(rowIndex))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkFrameRowNA(Frame chk, long rowIndex) {
        int numCol = chk.numCols();
        for (int colIndex = 0; colIndex < numCol; ++colIndex) {
            if (!Double.isNaN(chk.vec(colIndex).at(rowIndex))) continue;
            return true;
        }
        return false;
    }

    public static String genThinPlateNameStart(GAMModel.GAMParameters parms, int gamColIndex) {
        StringBuffer colNameStub = new StringBuffer();
        for (int gColInd = 0; gColInd < parms._gam_columns_sorted[gamColIndex].length; ++gColInd) {
            colNameStub.append(parms._gam_columns_sorted[gamColIndex][gColInd]);
            colNameStub.append("_");
        }
        colNameStub.append(parms._bs_sorted[gamColIndex]);
        colNameStub.append("_");
        return colNameStub.toString();
    }

    public static String[] extractColNames(String[] src, int srcStart, int destStart, int length) {
        String[] distanceColNames = new String[length];
        System.arraycopy(src, srcStart, distanceColNames, destStart, length);
        return distanceColNames;
    }

    public static int[][] convertList2Array(List<Integer[]> list2Convert, int M, int d) {
        int[][] polyBasisArr = new int[M][d];
        for (int index = 0; index < M; ++index) {
            List<Object> oneList = Arrays.asList((Object[])list2Convert.get(index));
            polyBasisArr[index] = oneList.stream().mapToInt(Integer::intValue).toArray();
        }
        return polyBasisArr;
    }

    public static double[][] genKnotsMultiplePreds(Frame predictVec, GAMModel.GAMParameters parms, int predIndex) {
        Frame sortedFirstDim = predictVec.sort(new int[]{0});
        double stepProb = 1.0 / (double)parms._num_knots[predIndex];
        long rowSteps = (long)Math.floor(stepProb * (double)sortedFirstDim.numRows());
        int numPred = parms._gam_columns[predIndex].length;
        double[][] knots = new double[numPred][parms._num_knots[predIndex]];
        long nrow = sortedFirstDim.numRows();
        long nextRow = 1L;
        long currRow = 0L;
        block0: for (int knotIndex = 0; knotIndex < parms._num_knots[predIndex]; ++knotIndex) {
            nextRow = (long)(knotIndex + 1) * rowSteps;
            for (currRow = (long)knotIndex * rowSteps; currRow < nrow && currRow < nextRow; ++currRow) {
                if (ThinPlateRegressionUtils.checkFrameRowNA(sortedFirstDim, currRow)) continue;
                for (int colIndex = 0; colIndex < numPred; ++colIndex) {
                    knots[colIndex][knotIndex] = sortedFirstDim.vec(colIndex).at(currRow);
                }
                continue block0;
            }
        }
        sortedFirstDim.remove();
        parms._num_knots[predIndex] = knots[0].length;
        return knots;
    }

    public static class ScaleTPPenalty
    extends MRTask<ScaleTPPenalty> {
        public double[][] _penaltyMat;
        double[] _maxAbsRowSum;
        public int _initChunks;
        public double _s_scale;

        public ScaleTPPenalty(double[][] origPenaltyMat, Frame distancePlusPoly) {
            this._penaltyMat = origPenaltyMat;
            this._initChunks = distancePlusPoly.vec(0).nChunks();
        }

        public void map(Chunk[] chk, NewChunk[] newGamCols) {
            this._maxAbsRowSum = new double[this._initChunks];
            int cIndex = chk[0].cidx();
            this._maxAbsRowSum[cIndex] = Double.NEGATIVE_INFINITY;
            int numRow = chk[0]._len;
            for (int rowIndex = 0; rowIndex < numRow; ++rowIndex) {
                double rowSum = 0.0;
                for (int colIndex = 0; colIndex < chk.length; ++colIndex) {
                    rowSum += Math.abs(chk[colIndex].atd(rowIndex));
                }
                if (!(rowSum > this._maxAbsRowSum[cIndex])) continue;
                this._maxAbsRowSum[cIndex] = rowSum;
            }
        }

        public void reduce(ScaleTPPenalty other) {
            ArrayUtils.add((double[])this._maxAbsRowSum, (double[])other._maxAbsRowSum);
        }

        public void postGlobal() {
            double tempMaxValue = ArrayUtils.maxValue((double[])this._maxAbsRowSum);
            this._s_scale = tempMaxValue * tempMaxValue / ArrayUtils.rNorm((double[][])this._penaltyMat, (char)'i');
            ArrayUtils.mult((double[][])this._penaltyMat, (double)this._s_scale);
            this._s_scale = 1.0 / this._s_scale;
        }
    }
}

