/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.gam.GamSplines.CubicRegressionSplines;
import hex.genmodel.algos.gam.GamUtilsCubicRegression;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.ArrayUtils;

public class AddCSGamColumns
extends MRTask<AddCSGamColumns> {
    double[][][] _binvD;
    double[][][] _knotsMat;
    double[][][] _ztransp;
    int[] _numKnots;
    public int _numGAMcols;
    public int _gamCols2Add = 0;
    double[] _vmax;
    double[] _vmin;
    int[] _gamColsOffsets;
    Frame _gamFrame;

    public AddCSGamColumns(double[][][] binvD, double[][][] ztransp, double[][][] knotsMat, int[] numKnots, Frame gamColFrames, int[] bsSorted) {
        this._numGAMcols = gamColFrames.numCols();
        this._binvD = new double[this._numGAMcols][][];
        this._knotsMat = new double[this._numGAMcols][][];
        this._ztransp = new double[this._numGAMcols][][];
        this._numKnots = new int[this._numGAMcols];
        int numTotGamCols = numKnots.length;
        this._vmax = MemoryManager.malloc8d((int)this._numGAMcols);
        this._vmin = MemoryManager.malloc8d((int)this._numGAMcols);
        this._gamColsOffsets = MemoryManager.malloc4((int)this._numGAMcols);
        this._gamFrame = gamColFrames;
        int countCSGam = 0;
        for (int ind = 0; ind < numTotGamCols; ++ind) {
            if (bsSorted[ind] != 0) continue;
            this._vmax[countCSGam] = gamColFrames.vec(countCSGam).max();
            this._vmin[countCSGam] = gamColFrames.vec(countCSGam).min();
            this._ztransp[countCSGam] = ztransp[ind];
            this._binvD[countCSGam] = binvD[ind];
            this._knotsMat[countCSGam] = knotsMat[ind];
            this._numKnots[countCSGam] = numKnots[ind];
            int n = countCSGam++;
            this._gamColsOffsets[n] = this._gamColsOffsets[n] + this._gamCols2Add;
            this._gamCols2Add += this._numKnots[ind] - 1;
        }
    }

    public void map(Chunk[] chk, NewChunk[] newChunks) {
        CubicRegressionSplines[] crSplines = new CubicRegressionSplines[this._numGAMcols];
        double[][] basisVals = new double[this._numGAMcols][];
        double[][] basisValsCenter = new double[this._numGAMcols][];
        for (int gcolInd = 0; gcolInd < this._numGAMcols; ++gcolInd) {
            crSplines[gcolInd] = new CubicRegressionSplines(this._numKnots[gcolInd], this._knotsMat[gcolInd][0]);
            basisValsCenter[gcolInd] = MemoryManager.malloc8d((int)(this._numKnots[gcolInd] - 1));
            basisVals[gcolInd] = MemoryManager.malloc8d((int)this._numKnots[gcolInd]);
        }
        int chkLen = chk[0]._len;
        for (int rInd = 0; rInd < chkLen; ++rInd) {
            for (int cInd = 0; cInd < this._numGAMcols; ++cInd) {
                this.generateOneGAMcols(cInd, this._gamColsOffsets[cInd], basisVals[cInd], basisValsCenter[cInd], this._binvD[cInd], crSplines[cInd], chk[cInd].atd(rInd), newChunks);
            }
        }
    }

    public void generateOneGAMcols(int colInd, int colOffset, double[] basisVals, double[] basisValCenter, double[][] bInvD, CubicRegressionSplines splines, double xval, NewChunk[] newChunks) {
        int centerKnots = this._numKnots[colInd] - 1;
        if (!Double.isNaN(xval)) {
            int binIndex = GamUtilsCubicRegression.locateBin((double)xval, (double[])splines._knots);
            GamUtilsCubicRegression.updateFMatrixCFunc((double[])basisVals, (double)xval, (int)binIndex, (double[])splines._knots, (double[])splines._hj, (double[][])bInvD);
            GamUtilsCubicRegression.updateAFunc((double[])basisVals, (double)xval, (int)binIndex, (double[])splines._knots, (double[])splines._hj);
            basisValCenter = ArrayUtils.multArrVec((double[][])this._ztransp[colInd], (double[])basisVals, (double[])basisValCenter);
            for (int colIndex = 0; colIndex < centerKnots; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(basisValCenter[colIndex]);
            }
        } else {
            for (int colIndex = 0; colIndex < centerKnots; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(Double.NaN);
            }
        }
    }
}

