/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.gam.GAMModel;
import hex.gam.GamSplines.NBSplinesTypeIDerivative;
import hex.genmodel.algos.gam.ISplines;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.ArrayUtils;

public class GenISplineGamOneColumn
extends MRTask<GenISplineGamOneColumn> {
    private final double[] _knots;
    private final int _order;
    double[] _maxAbsRowSum;
    public double _s_scale;
    private final int _gamColNChunks;
    public double[][] _penaltyMat;
    public final int _numBasis;
    public final int _totKnots;

    public GenISplineGamOneColumn(GAMModel.GAMParameters parm, double[] knots, int gamColIndex, Frame gamCol, int nBasis, int totKnots) {
        this._knots = knots;
        this._order = parm._spline_orders_sorted[gamColIndex];
        this._numBasis = nBasis > 0 ? nBasis : knots.length + this._order - 2;
        this._totKnots = totKnots > 0 ? totKnots : knots.length + 2 * this._order - 2;
        this._gamColNChunks = gamCol.vec(0).nChunks();
        this._penaltyMat = NBSplinesTypeIDerivative.genISPenaltyMatrix(knots, parm._spline_orders_sorted[gamColIndex]);
    }

    public void map(Chunk[] chk, NewChunk[] newGamCols) {
        ISplines basisFuncs = new ISplines(this._order, this._knots);
        this._maxAbsRowSum = new double[this._gamColNChunks];
        double[] basisVals = new double[this._numBasis];
        int cIndex = chk[0].cidx();
        this._maxAbsRowSum[cIndex] = Double.NEGATIVE_INFINITY;
        int chkRows = chk[0].len();
        for (int rowIndex = 0; rowIndex < chkRows; ++rowIndex) {
            double gamRowSum = 0.0;
            if (chk[1].atd(rowIndex) != 0.0) {
                int colIndex;
                double xval = chk[0].atd(rowIndex);
                if (Double.isNaN(xval)) {
                    for (colIndex = 0; colIndex < this._numBasis; ++colIndex) {
                        newGamCols[colIndex].addNum(Double.NaN);
                    }
                    continue;
                }
                basisFuncs.gamifyVal(basisVals, xval);
                for (colIndex = 0; colIndex < this._numBasis; ++colIndex) {
                    newGamCols[colIndex].addNum(basisVals[colIndex]);
                    gamRowSum += Math.abs(basisVals[colIndex]);
                }
                if (!(gamRowSum > this._maxAbsRowSum[cIndex])) continue;
                this._maxAbsRowSum[cIndex] = gamRowSum;
                continue;
            }
            for (int colIndex = 0; colIndex < this._numBasis; ++colIndex) {
                newGamCols[colIndex].addNum(0.0);
            }
        }
    }

    public void reduce(GenISplineGamOneColumn other) {
        ArrayUtils.add((double[])this._maxAbsRowSum, (double[])other._maxAbsRowSum);
    }

    public void postGlobal() {
        double tempMaxValue = ArrayUtils.maxValue((double[])this._maxAbsRowSum);
        this._s_scale = tempMaxValue * tempMaxValue / ArrayUtils.rNorm((double[][])this._penaltyMat, (char)'i');
        if (Double.isFinite(this._s_scale)) {
            ArrayUtils.mult((double[][])this._penaltyMat, (double)this._s_scale);
        }
        this._s_scale = 1.0 / this._s_scale;
    }
}

