/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import org.apache.commons.math3.special.Gamma;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.fp.Function2;
import water.util.fp.Function3;

public class TweedieEstimator
extends MRTask<TweedieEstimator> {
    private final long _max_iter_cnt;
    double _loglikelihood;
    double _llhDp;
    double _llhDpDp;
    final double _p;
    final double _phi;
    private final double _pp;
    private final double _ppp;
    private final double _p1;
    private final double _p2;
    private final double _p1sq;
    private final double _p2sq;
    private final double _invp1;
    private final double _invp1sq;
    private final double _invp2;
    private final double _invp2sq;
    private final double _logp1;
    private final double _logp2;
    private final double _log_phi;
    private final double _alpha;
    private final double _logDenom_p;
    private final double _logPhip1inv;
    private final double _pialpha;
    private final double _logInvDenom2ConstPart;
    private final double _pisq;
    private final double _epsilon = 1.0E-12;
    private double _wSum;
    private double _wDpSum;
    private double _wDpDpSum;
    private double _logWMax;
    double _logVSum;
    double _logVDpSum;
    double _logVDpDpSum;
    double _logVMax;
    private double _vDpSumSgn;
    private double _vDpDpSumSgn;
    private final boolean _useSaddlepoint;
    private final boolean _needDp;
    private final boolean _needDpDp;
    private final boolean _forceInversion;
    public long _skippedRows;
    public long _totalRows;
    public LikelihoodEstimator _method;
    private static final double[] absc = new double[]{0.0030649621851593996, 0.009194771386432906, 0.015324235084898183, 0.021453122959774876, 0.027581204711919792, 0.03370825007248059, 0.03983402881154845, 0.04595831074680906, 0.05208086575219207, 0.058201463766518226, 0.06431987480214424, 0.07043586895360467, 0.07654921640625105, 0.08265968744488716, 0.08876705246240103, 0.09487108196839254, 0.10097154659779678, 0.10706821711950266, 0.11316086444496654, 0.1192492596368204, 0.12533317391747448, 0.13141237867771371, 0.1374866454852881, 0.14355574609349603, 0.14961945244976127, 0.15567753670420187, 0.1617297712181921, 0.16777592857291612, 0.17381578157791344, 0.17984910327961592, 0.1858756669698757, 0.19189524619448403, 0.19790761476168048, 0.20391254675065237, 0.20990981652002394, 0.21589919871633503, 0.22188046828250904, 0.22785340046630959, 0.23381777082878585, 0.23977335525270618, 0.24571992995097924, 0.25165727147506334, 0.25758515672336263, 0.2635033629496103, 0.2694116677712386, 0.27530984917773504, 0.28119768553898467, 0.28707495561359797, 0.29294143855722443, 0.2987969139308507, 0.30464116170908423, 0.31047396228842045, 0.31629509649549487, 0.3221043455953188, 0.3279014912994984, 0.33368631577443714, 0.339458601649521, 0.3452181320252867, 0.3509646904815714, 0.3566980610856456, 0.36241802840032644, 0.3681243774920731, 0.37381689393906337, 0.37949536383925053, 0.3851595738184011, 0.3908093110381125, 0.39644436320381055, 0.40206451857272696, 0.40766956596185555, 0.41325929475588763, 0.4188334949151263, 0.42439195698337867, 0.4299344720958266, 0.43546083198687474, 0.44097082899797657, 0.4464642560854375, 0.4519409068281941, 0.4574005754355713, 0.4628430567550148, 0.46826814627979996, 0.47367564015671665, 0.47906533519372846, 0.48443702886760864, 0.4897905193315499, 0.49512560542274864, 0.5004420866699644, 0.5057397633010522, 0.5110184362504699, 0.5162779071667575, 0.5215179784199908, 0.5267384531092077, 0.5319391350698066, 0.5371198288809178, 0.5422803398727462, 0.5474204741338866, 0.5525400385186102, 0.557638840654122, 0.562716688947789, 0.5677733925943407, 0.5728087615830374, 0.5778226067048111, 0.5828147395593745, 0.5877849725623008, 0.5927331189520721, 0.5976589927970977, 0.6025624090026994, 0.6074431833180683, 0.612301132343187, 0.6171360735357212, 0.6219478252178794, 0.6267362065832393, 0.6315010377035416, 0.6362421395354517, 0.6409593339272864, 0.645652443625709, 0.6503212922823891, 0.6549657044606303, 0.6595855056419603, 0.6641805222326905, 0.6687505815704384, 0.6732955119306152, 0.6778151425328788, 0.6823093035475509, 0.6867778261019991, 0.6912205422869816, 0.695637285162957, 0.7000278887663572, 0.7043921881158238, 0.7087300192184071, 0.7130412190757285, 0.7173256256901053, 0.7215830780706379, 0.7258134162392593, 0.7300164812367466, 0.734192115128693, 0.7383401610114442, 0.7424604630179923, 0.7465528663238341, 0.7506172171527881, 0.7546533627827725, 0.7586611515515449, 0.7626404328624002, 0.7665910571898299, 0.7705128760851405, 0.7744057421820317, 0.7782695092021338, 0.7821040319605042, 0.785909166371083, 0.7896847694521072, 0.793430699331483, 0.7971468152521175, 0.8008329775772071, 0.8044890477954846, 0.8081148885264243, 0.8117103635254043, 0.8152753376888249, 0.8188096770591868, 0.8223132488301236, 0.8257859213513925, 0.8292275641338213, 0.8326380478542114, 0.8360172443601974, 0.8393650266750627, 0.8426812690025105, 0.8459658467313906, 0.8492186364403826, 0.8524395159026327, 0.8556283640903465, 0.8587850611793373, 0.861909488553529, 0.8650015288094115, 0.8680610657604539, 0.8710879844414698, 0.8740821711129373, 0.8770435132652723, 0.8799718996230571, 0.882867220149221, 0.8857293660491754, 0.8885582297749018, 0.8913537050289927, 0.8941156867686465, 0.8968440712096138, 0.8995387558300979, 0.9021996393746068, 0.904826621857758, 0.9074196045680355, 0.9099784900714992, 0.912503182215446, 0.9149935861320229, 0.9174496082417911, 0.9198711562572436, 0.9222581391862719, 0.9246104673355856, 0.9269280523140828, 0.9292108070361711, 0.9314586457250403, 0.9336714839158854, 0.9358492384590805, 0.9379918275233031, 0.9400991705986094, 0.9421711884994589, 0.9442078033676905, 0.946208938675448, 0.9481745192280551, 0.9501044711668419, 0.9519987219719198, 0.953857200464906, 0.9556798368115988, 0.9574665625246019, 0.9592173104658972, 0.9609320148493677, 0.9626106112432703, 0.964253036572656, 0.9658592291217407, 0.9674291285362238, 0.9689626758255566, 0.9704598133651587, 0.9719204848985836, 0.9733446355396325, 0.974732211774417, 0.9760831614633703, 0.9773974338432059, 0.9786749795288263, 0.9799157505151782, 0.9811197001790571, 0.9822867832808596, 0.983416955966284, 0.9845101757679784, 0.9855664016071379, 0.9865855937950492, 0.9875677140345829, 0.988512725421635, 0.9894205924465157, 0.9902912809952868, 0.9911247583510481, 0.9919209931951715, 0.9926799556084865, 0.9934016170724148, 0.9940859504700559, 0.9947329300872282, 0.9953425316134658, 0.9959147321429772, 0.9964495101755774, 0.9969468456176038, 0.9974067197828498, 0.9978291153935629, 0.9982140165816128, 0.9985614088900397, 0.9988712792754494, 0.9991436161123782, 0.9993784092025992, 0.9995756497983108, 0.9997353306710427, 0.9998574463699794, 0.9999419946068456, 0.9999889909843819};
    private static final double[] weights = new double[]{0.006129905175405764, 0.0061296748380364925, 0.006129214171953069, 0.00612852319446553, 0.0061276019315380315, 0.0061264504177879495, 0.006125068696484562, 0.006123456819547497, 0.006121614847544606, 0.006119542849689839, 0.006117240903840641, 0.0061147090964949035, 0.006111947522787883, 0.006108956286488515, 0.006105735499995449, 0.00610228528433306, 0.006098605769146657, 0.006094697092697685, 0.006090559401858643, 0.006086192852107507, 0.006081597607521639, 0.00607677384077209, 0.0060717217331167665, 0.006066441474393664, 0.006060933263013821, 0.006055197305953896, 0.0060492338187481415, 0.006043043025480823, 0.006036625158776994, 0.006029980459794645, 0.006023109178214985, 0.006016011572233289, 0.006008687908549399, 0.00600113846235717, 0.0059933635173348146, 0.005985363365633674, 0.005977138307867539, 0.005968688653101249, 0.005960014718839098, 0.005951116831012847, 0.005941995323969674, 0.0059326505404594864, 0.0059230828316218075, 0.005913292556972981, 0.00590328008439251, 0.005893045790109108, 0.005882590058686673, 0.005871913283009922, 0.005861015864269402, 0.005849898211946678, 0.005838560743798747, 0.005827003885842344, 0.005815228072338094, 0.005803233745774117, 0.005791021356849214, 0.005778591364456384, 0.005765944235664991, 0.005753080445703687, 0.005740000477942362, 0.005726704823874018, 0.005713193983096204, 0.005699468463292456, 0.005685528780212968, 0.005671375457655505, 0.0056570090274452875, 0.005642430029415475, 0.0056276390113866375, 0.005612636529146218, 0.005597423146427572, 0.0055819994348889155, 0.005566365974091758, 0.005550523351479156, 0.005534472162353648, 0.005518213009854875, 0.0055017465049368225, 0.005485073266345073, 0.005468193920593388, 0.005451109101940145, 0.005433819452364726, 0.0054163256215430475, 0.005398628266823573, 0.005380728053202113, 0.005362625653297344, 0.005344321747325165, 0.005325817023073333, 0.005307112175875509, 0.005288207908585203, 0.005269104931549262, 0.0052498039625814, 0.005230305726934938, 0.005210610957275768, 0.005190720393654706, 0.005170634783479783, 0.005150354881487986, 0.005129881449717141, 0.005109215257477111, 0.005088357081320884, 0.005067307705015408, 0.005046067919512329, 0.005024638522917937, 0.0050030203204634695, 0.004981214124474674, 0.004959220754341321, 0.004937041036486573, 0.00491467580433555, 0.004892125898284491, 0.004869392165668925, 0.004846475460731645, 0.004823376644591045, 0.004800096585208414, 0.004776636157355449, 0.0047529962425814, 0.004729177729179922, 0.0047051815121556696, 0.004681008493190663, 0.004656659580610529, 0.004632135689350182, 0.004607437740919579, 0.004582566663369058, 0.004557523391254391, 0.004532308865601841, 0.004506924033872596, 0.004481369849927315, 0.004455647273990272, 0.004429757272613176, 0.004403700818638966, 0.004377478891165112, 0.00435109247550706, 0.004324542563160945, 0.004297830151766558, 0.004270956245069621, 0.004243921852884336, 0.0042167279910552274, 0.004189375681419113, 0.00416186595176654, 0.004134199835803465, 0.004106378373112004, 0.00407840260911173, 0.004050273595020141, 0.00402199238781341, 0.003993560050186265, 0.0039649776505126175, 0.003936246262804875, 0.003907366966673973, 0.00387834084728852, 0.003849168995334298, 0.0038198525069730116, 0.0037903924838012964, 0.0037607900328092687, 0.0037310462663388486, 0.003701162302042068, 0.0036711392628390052, 0.0036409782768756995, 0.0036106804774816118, 0.003580247003126992, 0.0035496789973804817, 0.0035189776088657173, 0.0034881439912182936, 0.003457179303042459, 0.0034260847078676675, 0.0033948613741046903, 0.0033635104750017694, 0.0033320331886005747, 0.0033004306976918956, 0.003268704189771169, 0.003236854856993954, 0.0032048838961311198, 0.003172792508523682, 0.0031405819000379486, 0.0031082532810200268, 0.0030758078662503486, 0.003043246874898156, 0.0030105715304755425, 0.0029777830607914772, 0.0029448826979058713, 0.0029118716780830002, 0.002878751241745274, 0.0028455226334264927, 0.0028121871017250805, 0.002778745899257361, 0.002745200282610227, 0.0027115515122940964, 0.002677800852695408, 0.002643949572029331, 0.0026099989422918163, 0.0025759502392121475, 0.0025418047422046154, 0.0025075637343207778, 0.002473228502201044, 0.002438800336026468, 0.0024042805294701257, 0.002369670379648584, 0.002334971187073221, 0.0023001842556012015, 0.002265310892386644, 0.0022303524078313786, 0.0021953101155357795, 0.0021601853322493893, 0.0021249793778214715, 0.0020896935751513477, 0.002054329250138732, 0.002018887731633921, 0.0019833703513878046, 0.001947778444001947, 0.0019121133468782672, 0.0018763764001689621, 0.0018405689467260334, 0.0018046923320508598, 0.001768747904243635, 0.0017327370139527665, 0.0016966610143241104, 0.0016605212609500915, 0.0016243191118187018, 0.001588055927262729, 0.0015517330699084241, 0.0015153519046243473, 0.001478913798470224, 0.0014424201206453657, 0.0014058722424375109, 0.0013692715371710978, 0.0013326193801558115, 0.001295917148634918, 0.0012591662217335507, 0.0012223679804069503, 0.0011855238073886665, 0.0011486350871386423, 0.0011117032057914328, 0.0010747295511041187, 0.0010377155124045104, 0.0010006624805390973, 9.635718478211849E-4, 9.26445007979157E-4, 8.892833561045142E-4, 8.520882886004818E-4, 8.148612031307728E-4, 7.776034985686756E-4, 7.403165749469858E-4, 7.030018334087591E-4, 6.656606761599339E-4, 6.28294506424452E-4, 5.909047284032244E-4, 5.534927472404095E-4, 5.1605996900076E-4, 4.78607800667961E-4, 4.411376501795522E-4, 4.036509265333141E-4, 3.6614904003562826E-4, 3.2863340285231026E-4, 2.911054302514888E-4, 2.5356654357060237E-4, 2.1601817797696772E-4, 1.784618055459722E-4, 1.4089901738819017E-4, 1.0333190349693183E-4, 6.576573165923677E-5, 2.8252637373961186E-5};

    TweedieEstimator(double variancePower, double dispersion) {
        this(variancePower, dispersion, false, false, false, false);
    }

    TweedieEstimator(double variancePower, double dispersion, boolean forceInversion) {
        this(variancePower, dispersion, false, false, false, forceInversion);
    }

    TweedieEstimator(double variancePower, double dispersion, boolean useSaddlepointApprox, boolean needDp, boolean needDpDp, boolean forceInversion) {
        assert (variancePower >= 1.0) : "Tweedie variance power has to be greater than 1!";
        assert ((forceInversion || useSaddlepointApprox) && !needDp && !needDpDp || !forceInversion || !useSaddlepointApprox);
        this._p = variancePower;
        this._phi = dispersion;
        this._max_iter_cnt = 25000L;
        this._pp = this._p * this._p;
        this._ppp = this._pp * this._p;
        this._p1 = this._p - 1.0;
        this._p2 = this._p - 2.0;
        this._p1sq = this._p1 * this._p1;
        this._p2sq = this._p2 * this._p2;
        this._invp1 = 1.0 / this._p1;
        this._invp1sq = this._invp1 * this._invp1;
        this._invp2 = 1.0 / this._p2;
        this._invp2sq = this._invp2 * this._invp2;
        this._logp1 = Math.log(this._p1);
        this._logp2 = Math.log(Math.abs(this._p2));
        this._log_phi = Math.log(this._phi);
        this._alpha = this._p2 / this._p1;
        this._logDenom_p = (2.0 * this._p * this._invp1 + 4.0) * this._logp1 + 2.0 * this._logp2;
        this._logPhip1inv = -this._invp1 * this._log_phi;
        this._pialpha = -Math.PI * this._alpha;
        this._logInvDenom2ConstPart = -4.0 * this._logp1 - 2.0 * this._logp2;
        this._pisq = Math.PI * Math.PI;
        this._useSaddlepoint = useSaddlepointApprox;
        this._needDp = needDp;
        this._needDpDp = needDpDp;
        this._forceInversion = forceInversion;
    }

    public double logLikelihood(double y, double mu) {
        return this.logLikelihood(y, mu, 1.0);
    }

    public double logLikelihood(double y, double mu, double w) {
        return this.logLikelihood(y, mu, w, false);
    }

    public static double logLikelihood(double y, double mu, double p, double phi) {
        TweedieEstimator tweedieVariancePowerMLEstimator = new TweedieEstimator(p, phi);
        return tweedieVariancePowerMLEstimator.logLikelihood(y, mu);
    }

    public static double deviance(double y, double mu, double p) {
        double dev;
        if (p == 1.0) {
            dev = y != 0.0 ? y * Math.log(y / mu) - (y - mu) : mu;
        } else if (p == 2.0) {
            dev = Math.log(mu / y) + y / mu - 1.0;
        } else if (p == 0.0) {
            dev = Math.pow(y - mu, 2.0);
            dev /= 2.0;
        } else {
            dev = Math.pow(y, 2.0 - p) / ((p - 1.0) * (p - 2.0)) + y * Math.pow(mu, 1.0 - p) / (p - 1.0) - Math.pow(mu, 2.0 - p) / (p - 2.0);
        }
        return 2.0 * dev;
    }

    private double gammaLLH(double y, double mu, double w) {
        double a = 1.0 / this._phi;
        double b = 1.0 / (this._phi * mu);
        if (y == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return w * (a * Math.log(b) - Gamma.logGamma((double)a) + Math.log(y) * (a - 1.0) + -b * y);
    }

    private double poissonLLH(double y, double mu, double w) {
        double lambda = mu / this._phi;
        if (Math.abs(y / this._phi - (double)Math.round(y / this._phi)) > 1.0E-12) {
            return 0.0;
        }
        return w * (y / this._phi * Math.log(lambda) - Gamma.logGamma((double)((y + 1.0) / this._phi)) - lambda);
    }

    private double invGaussLLH(double y, double mu, double w) {
        if (y == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double dispersion = this._phi * mu;
        return w * ((-Math.log(dispersion) - Math.log(Math.PI * 2) - 3.0 * Math.log(y /= mu) - Math.pow(y - 1.0, 2.0) / dispersion / y) / 2.0 - Math.log(mu));
    }

    private void accumulate(double llh, double grad, double hess) {
        this._loglikelihood += llh;
        if (Double.isFinite(grad)) {
            this._llhDp += grad;
        }
        if (Double.isFinite(hess)) {
            this._llhDpDp += hess;
        }
    }

    private double logLikelihood(double y, double mu, double w, boolean accumulate) {
        if (w == 0.0) {
            return 0.0;
        }
        if (this._p >= 2.0 && y <= 0.0) {
            if (accumulate) {
                this.accumulate(Double.NEGATIVE_INFINITY, 0.0, 0.0);
            }
            return Double.NEGATIVE_INFINITY;
        }
        double[] llh_llhDp_llhDpDp = MemoryManager.malloc8d((int)3);
        if (!this._useSaddlepoint) {
            this._method = LikelihoodEstimator.series;
            double xi = this._phi / Math.pow(y, 2.0 - this._p);
            if (this._p == 1.0) {
                llh_llhDp_llhDpDp[0] = this.poissonLLH(y, mu, w);
                this._method = LikelihoodEstimator.poisson;
            } else if (this._p == 2.0) {
                llh_llhDp_llhDpDp[0] = this.gammaLLH(y, mu, w);
                this._method = LikelihoodEstimator.gamma;
            } else if (this._p == 3.0) {
                llh_llhDp_llhDpDp[0] = this.invGaussLLH(y, mu, w);
                this._method = LikelihoodEstimator.invGaussian;
            } else if (this._p < 2.0) {
                if (xi <= 0.01) {
                    this._method = LikelihoodEstimator.inversion;
                }
            } else if (this._p > 2.0 && xi <= 1.0) {
                this._method = LikelihoodEstimator.inversion;
            }
            if (this._forceInversion) {
                this._method = LikelihoodEstimator.inversion;
            }
            if (LikelihoodEstimator.series.equals((Object)this._method)) {
                this.tweedieSeries(y, mu, w, llh_llhDp_llhDpDp);
            }
            if ((LikelihoodEstimator.inversion.equals((Object)this._method) || Double.isNaN(llh_llhDp_llhDpDp[0])) && this._p != 1.0 && this._p != 2.0) {
                llh_llhDp_llhDpDp[0] = this.tweedieInversion(y, mu, w);
                this._method = LikelihoodEstimator.inversion;
                if (!Double.isFinite(llh_llhDp_llhDpDp[0])) {
                    this.tweedieSeries(y, mu, w, llh_llhDp_llhDpDp);
                    this._method = LikelihoodEstimator.series;
                } else if (this._needDp || this._needDpDp) {
                    double llh = llh_llhDp_llhDpDp[0];
                    this.tweedieSeries(y, mu, w, llh_llhDp_llhDpDp);
                    llh_llhDp_llhDpDp[0] = llh;
                }
            }
        }
        if (this._useSaddlepoint || Double.isNaN(llh_llhDp_llhDpDp[0])) {
            this._method = LikelihoodEstimator.saddlepoint;
            if (y == 0.0) {
                llh_llhDp_llhDpDp[0] = this._p > 1.0 && this._p < 2.0 ? Math.pow(mu, 2.0 - this._p) / (this._phi * (2.0 - this._p)) : Double.NEGATIVE_INFINITY;
            } else {
                double dev = TweedieEstimator.deviance(mu, y, this._p);
                if (this._p < 2.0) {
                    y += 0.16666666666666666;
                }
                llh_llhDp_llhDpDp[0] = -0.5 * (Math.log(Math.PI * 2 * this._phi) + this._p * Math.log(y)) + -dev / (2.0 * this._phi);
            }
        }
        if (accumulate) {
            this.accumulate(llh_llhDp_llhDpDp[0], llh_llhDp_llhDpDp[1], llh_llhDp_llhDpDp[2]);
        }
        return llh_llhDp_llhDpDp[0];
    }

    private void tweedieSeries(double y, double mu, double w, double[] out_llh_dp_dpdp) {
        out_llh_dp_dpdp[0] = 0.0;
        out_llh_dp_dpdp[1] = 0.0;
        out_llh_dp_dpdp[2] = 0.0;
        double llhDpPart = (Math.pow(mu, -this._p1) * y * Math.log(mu) * this._invp1 - Math.pow(mu, -this._p2) * Math.log(mu) * this._invp2 + Math.pow(mu, -this._p1) * y * this._invp1sq - Math.pow(mu, -this._p2) * this._invp2sq) * w / this._phi;
        double llhDpDpPart = -(Math.pow(mu, -this._p1) * y * Math.pow(Math.log(mu), 2.0) * this._invp1 - Math.pow(mu, -this._p2) * Math.pow(Math.log(mu), 2.0) * this._invp2 + 2.0 * (Math.pow(mu, -this._p1) * y * Math.log(mu) * this._invp1sq - Math.pow(mu, -this._p2) * Math.log(mu) * this._invp2sq + Math.pow(mu, -this._p1) * y * this._invp1sq * this._invp1 - Math.pow(mu, -this._p2) * this._invp2sq * this._invp2)) * w / this._phi;
        if (this._p < 2.0) {
            if (y == 0.0) {
                out_llh_dp_dpdp[0] = -w * Math.pow(mu, 2.0 - this._p) / (this._phi * (2.0 - this._p));
                if (this._needDp) {
                    out_llh_dp_dpdp[1] = -(Math.pow(mu, -this._p2) * w * Math.log(mu) * this._invp2 + Math.pow(mu, -this._p2) * w * this._invp2sq) / this._phi;
                }
                if (this._needDpDp) {
                    out_llh_dp_dpdp[2] = (Math.pow(mu, -this._p2) * w * Math.pow(Math.log(mu), 2.0) * this._invp2 + 2.0 * Math.pow(mu, -this._p2) * w * Math.log(mu) * this._invp2sq + 2.0 * Math.pow(mu, -this._p2) * w * this._invp2sq * this._invp2) / this._phi;
                }
            } else {
                this.calculateWjSums(y, w);
                out_llh_dp_dpdp[0] = -Math.log(y) + Math.log(this._wSum) + this._logWMax - w * (Math.pow(mu, -this._p1) * y * this._invp1 - Math.pow(mu, -this._p2) / this._p2) / this._phi;
                if (out_llh_dp_dpdp[0] == Double.POSITIVE_INFINITY) {
                    out_llh_dp_dpdp[0] = Double.NEGATIVE_INFINITY;
                }
                if (this._needDp) {
                    out_llh_dp_dpdp[1] = llhDpPart + this._wDpSum / this._wSum;
                }
                if (this._needDpDp) {
                    out_llh_dp_dpdp[2] = llhDpDpPart + (this._wDpDpSum / this._wSum - this._wDpSum / this._wSum * this._wDpSum / this._wSum);
                }
            }
        } else {
            if (y == 0.0) {
                return;
            }
            this.calculateVkSums(y, w);
            out_llh_dp_dpdp[0] = -Math.log(Math.PI * y) + this._logVSum + this._logVMax - w * (Math.pow(mu, -this._p1) * y * this._invp1 - Math.pow(mu, -this._p2) / this._p2) / this._phi;
            if (this._needDp) {
                out_llh_dp_dpdp[1] = llhDpPart + Math.exp(this._logVDpSum - this._logVSum) * this._vDpSumSgn;
            }
            if (this._needDpDp) {
                out_llh_dp_dpdp[2] = llhDpDpPart + (Math.exp(this._logVDpDpSum - this._logVSum) * this._vDpDpSumSgn - Math.exp(this._logVDpSum - this._logVSum + this._logVDpSum - this._logVSum));
            }
        }
    }

    public TweedieEstimator compute(Vec mu, Vec y, Vec weights) {
        if (this._p >= 2.0 && y.min() <= 0.0) {
            this._loglikelihood = Double.NEGATIVE_INFINITY;
            this._llhDp = 0.0;
            this._llhDpDp = 0.0;
            return this;
        }
        return (TweedieEstimator)this.doAll(new Vec[]{mu, y, weights});
    }

    public void map(Chunk[] cs) {
        this._totalRows += (long)cs[0]._len;
        for (int i = 0; i < cs[0]._len; ++i) {
            double w;
            double mu = Math.max(0.0, cs[0].atd(i));
            if (!Double.isFinite(mu)) {
                ++this._skippedRows;
                continue;
            }
            double y = cs[1].atd(i);
            double llh = this.logLikelihood(y, mu, w = cs[2].atd(i), true);
            if (llh == 0.0 || !Double.isFinite(llh)) {
                ++this._skippedRows;
            }
            if (Double.isFinite(llh) || this._needDp && Double.isFinite(this._llhDp) || this._needDpDp && Double.isFinite(this._llhDpDp)) continue;
            this._skippedRows += (long)(cs[0]._len - i);
            return;
        }
    }

    public void reduce(TweedieEstimator mrt) {
        this._loglikelihood += mrt._loglikelihood;
        this._llhDp += mrt._llhDp;
        this._llhDpDp += mrt._llhDpDp;
        this._skippedRows += mrt._skippedRows;
        this._totalRows += mrt._totalRows;
    }

    void cleanSums() {
        this._logVSum = 0.0;
        this._logVDpSum = 0.0;
        this._logVDpDpSum = 0.0;
        this._logVMax = 0.0;
        this._logWMax = 0.0;
        this._wSum = 0.0;
        this._wDpSum = 0.0;
        this._wDpDpSum = 0.0;
    }

    void calculateWjSums(double y, double w) {
        assert (y > 0.0);
        double negwy = -1.0 * Math.pow(w, this._invp1) * Math.pow(y, 2.0 * this._invp1);
        double denom_W_dp_dp_exped = Math.pow(this._p1, 2.0 * this._invp1) * this._p2 * Math.pow(this._phi, this._invp1) * Math.pow(y, this._p * this._invp1);
        double log_p1_phi_wy = Math.log(this._p1 * this._phi / (w * y));
        double logs_sumWdp = -(2.0 - Math.log(this._p1 * this._phi / (w * y))) * this._p + 3.0 + 2.0 * Math.log(w * y / (this._p1 * this._phi));
        double p1alphaw = Math.pow(this._p1, this._alpha) * Math.pow(w, this._invp1);
        double ps_sumWdp = this._p1sq * this._p2;
        double pphiy_sumWdp = -this._p2 * Math.pow(this._phi, this._invp1) * Math.pow(y, this._alpha);
        double log_y = Math.log(y);
        double log_w = Math.log(w);
        boolean WjLB = false;
        boolean WjUB = false;
        boolean WjDpLB = !this._needDp;
        boolean WjDpUB = !this._needDp;
        boolean WjDpDpLB = !this._needDpDp;
        boolean WjDpDpUB = !this._needDpDp;
        this.cleanSums();
        long jMax = Math.max(2L, (long)Math.ceil(w * Math.pow(y, 2.0 - this._p) / ((2.0 - this._p) * this._phi)));
        int cnt = 0;
        while (!(WjLB && WjUB && WjDpLB && WjDpUB && WjDpDpLB && WjDpDpUB || (long)cnt >= this._max_iter_cnt)) {
            long j = jMax + (long)cnt;
            if (!WjUB) {
                WjUB = this.Wj(log_y, log_w, j);
            }
            if (!WjDpUB) {
                WjDpUB = this.WjDp(logs_sumWdp, p1alphaw, ps_sumWdp, pphiy_sumWdp, j);
            }
            if (!WjDpDpUB) {
                WjDpDpUB = this.WjDpDp(y, w, negwy, denom_W_dp_dp_exped, log_p1_phi_wy, j);
            }
            if ((j = jMax - (long)cnt - 1L) < 1L) {
                WjLB = true;
                WjDpLB = true;
                WjDpDpLB = true;
            } else {
                if (!WjLB) {
                    WjLB = this.Wj(log_y, log_w, j);
                }
                if (!WjDpLB) {
                    WjDpLB = this.WjDp(logs_sumWdp, p1alphaw, ps_sumWdp, pphiy_sumWdp, j);
                }
                if (!WjDpDpLB) {
                    WjDpDpLB = this.WjDpDp(y, w, negwy, denom_W_dp_dp_exped, log_p1_phi_wy, j);
                }
            }
            ++cnt;
        }
    }

    private boolean Wj(double log_y, double log_w, long j) {
        double expInner = (1.0 - this._alpha) * (double)j * log_w + this._alpha * (double)j * (this._logp1 - log_y) - (double)j * (1.0 - this._alpha) * this._log_phi - (double)j * this._logp2 - Gamma.logGamma((double)(j + 1L)) - Gamma.logGamma((double)((double)(-j) * this._alpha));
        if (this._logWMax == 0.0) {
            this._logWMax = expInner;
        }
        double wSumInc = Math.exp(expInner - this._logWMax);
        this._wSum += wSumInc;
        if (this._needDp || this._needDpDp) {
            return (Math.abs(wSumInc) + 1.0E-12) / (Math.abs(this._wSum) + 1.0E-12) < 1.0E-12 && expInner - this._logWMax < -37.0;
        }
        return expInner - this._logWMax < -37.0;
    }

    private boolean WjDp(double logs_sumWdp, double p1alphaw, double ps_sumWdp, double pphiy_sumWdp, long j) {
        double log2_inner = this._p2 * Gamma.digamma((double)((double)(-j) * this._alpha)) + logs_sumWdp;
        double wDpSumInc = Math.signum(log2_inner) * Math.signum(ps_sumWdp) * Math.exp(Math.log(j) + Math.log(Math.abs(log2_inner)) + (double)j * Math.log(p1alphaw) - Math.log(Math.abs(ps_sumWdp)) - (double)j * Math.log(pphiy_sumWdp) - Gamma.logGamma((double)(j + 1L)) - Gamma.logGamma((double)((double)(-j) * this._alpha)) - this._logWMax);
        this._wDpSum += wDpSumInc;
        return (Math.abs(wDpSumInc) + 1.0E-12) / (Math.abs(this._wDpSum) + 1.0E-12) < 1.0E-12;
    }

    private boolean WjDpDp(double y, double w, double negwy, double denom_W_dp_dp_exped, double log_p1_phi_wy, long j) {
        if (j <= 1L) {
            return false;
        }
        double mja = -(this._alpha * (double)j);
        double psi_mja = Gamma.digamma((double)mja);
        double p1jp2p = Math.pow(this._p1, ((double)j * this._p + 2.0 * this._p) * this._invp1);
        double p1jp2 = Math.pow(this._p1, ((double)j * this._p + 2.0) * this._invp1);
        double jlogp1 = (double)j * Math.log(this._p - 1.0);
        double logdpdp1 = (this._p * (psi_mja - 2.0) + this._p * log_p1_phi_wy - 2.0 * psi_mja + 3.0) * (double)j * p1jp2p * this._p2 * Math.log(y) - this._p1sq * this._p2 * (this._p1 + this._p2 - this._p2 * psi_mja) * (double)j * p1jp2 * Math.log(w) - (this._p2sq * (double)j * Math.pow(psi_mja, 2.0) - 2.0 * (jlogp1 - (double)(2L * j) + 11.0) * Math.pow(this._p, 2.0) + 5.0 * Math.pow(this._p, 3.0) - ((this._p1 + this._p2) * this._p2 - this._p2sq * psi_mja) * (double)j * Math.log(this._phi) - this._p2sq * (double)j * Gamma.trigamma((double)mja) + (7.0 * jlogp1 - (double)(12L * j) + 32.0) * this._p - 6.0 * jlogp1 + ((jlogp1 - (double)(4L * j) + 10.0) * Math.pow(this._p, 2.0) - 2.0 * Math.pow(this._p, 3.0) - 2.0 * (2.0 * jlogp1 - (double)(7L * j) + 8.0) * this._p + 4.0 * jlogp1 - (double)(12L * j) + 8.0) * psi_mja + (double)(9L * j) - 15.0) * p1jp2p + (this._p1sq * this._p2 * (double)j * p1jp2 * this._p * Math.log(w) - ((double)j * this._p2 * this._p * Math.log(this._phi) + (double)j * this._p2 * this._p * psi_mja + (jlogp1 - (double)(2L * j) + 4.0) * Math.pow(this._p, 2.0) - 2.0 * Math.pow(this._p, 3.0) - (double)j * this._p * (2.0 * Math.log(this._p - 1.0) - 3.0) - 2.0) * p1jp2p) * log_p1_phi_wy + 2.0 * (this._p1sq * this._p2 * (double)j * p1jp2 * Math.log(w) + (double)j * p1jp2p * this._p2 * Math.log(y) - ((double)j * this._p2 * Math.log(this._phi) + (double)j * this._p2 * psi_mja + (jlogp1 - (double)(2L * j) + 8.0) * this._p - 3.0 * Math.pow(this._p, 2.0) - 2.0 * jlogp1 + (double)(3L * j) - 5.0) * p1jp2p) * -log_p1_phi_wy;
        double wDpDpSumInc = -Math.signum(logdpdp1) * Math.pow(Math.signum(negwy) * Math.signum(denom_W_dp_dp_exped), j) * Math.exp(Math.log(Math.abs(logdpdp1)) + (double)j * Math.log(Math.abs(negwy)) - this._logDenom_p - Math.log(j - 1L) - (double)j * Math.log(Math.abs(denom_W_dp_dp_exped)) - Gamma.logGamma((double)(j - 1L)) - Gamma.logGamma((double)mja) - this._logWMax);
        this._wDpDpSum += wDpDpSumInc;
        return (Math.abs(wDpDpSumInc) + 1.0E-12) / (Math.abs(this._wDpDpSum) + 1.0E-12) < 1.0E-12;
    }

    void calculateVkSums(double y, double w) {
        assert (y > 0.0);
        double logs = this._logp1 + Math.log(this._phi) - Math.log(w) - Math.log(y);
        double logssq = -Math.pow(this._logp1, 2.0) - Math.pow(Math.log(this._phi), 2.0) - Math.pow(Math.log(w), 2.0) - Math.pow(Math.log(y), 2.0);
        double log_w = Math.log(w);
        double log_y = Math.log(y);
        double log_pwy = this._logp2 + (this._alpha - 1.0) * log_w + this._alpha * log_y;
        double vkR = (this._alpha - 1.0) * this._log_phi + this._alpha * this._logp1 - (this._alpha - 1.0) * log_w - this._logp2 - this._alpha * log_y;
        boolean VkLB = false;
        boolean VkUB = false;
        boolean VkDpLB = !this._needDp;
        boolean VkDpUB = !this._needDp;
        boolean VkDpDpLB = !this._needDpDp;
        boolean VkDpDpUB = !this._needDpDp;
        this.cleanSums();
        long kMax = Math.max(1L, (long)(w * Math.pow(y, 2.0 - this._p) / ((this._p - 2.0) * this._phi)));
        for (long cnt = 0L; !(VkLB && VkUB && VkDpLB && VkDpUB && VkDpDpLB && VkDpDpUB || cnt >= this._max_iter_cnt); ++cnt) {
            long k = kMax + cnt;
            double mPiAlphaK = this._pialpha * (double)k;
            if (k > Integer.MAX_VALUE) {
                this._logVSum = Double.NEGATIVE_INFINITY;
                this._logVMax = 0.0;
                this._logVDpSum = Double.NaN;
                this._logVDpDpSum = Double.NaN;
                break;
            }
            double logGammaK1 = Gamma.logGamma((double)(k + 1L));
            double logGammaKalpha1 = Gamma.logGamma((double)((double)k * this._alpha + 1.0));
            double digammaKalpha1 = Gamma.digamma((double)((double)k * this._alpha + 1.0));
            if (!VkUB) {
                VkUB = this.Vk(vkR, k, mPiAlphaK, logGammaKalpha1, logGammaK1);
            }
            if (!VkDpUB) {
                VkDpUB = this.VkDp(log_y, log_w, k, log_pwy, mPiAlphaK, logGammaKalpha1, logGammaK1, digammaKalpha1);
            }
            if (!VkDpDpUB) {
                VkDpDpUB = this.VkDpDp(k, log_y, log_w, logs, logssq, mPiAlphaK, logGammaKalpha1, digammaKalpha1);
            }
            if ((k = kMax - cnt - 1L) < 1L) {
                VkLB = true;
                VkDpLB = true;
                VkDpDpLB = true;
                continue;
            }
            mPiAlphaK = this._pialpha * (double)k;
            logGammaK1 = Gamma.logGamma((double)(k + 1L));
            logGammaKalpha1 = Gamma.logGamma((double)((double)k * this._alpha + 1.0));
            digammaKalpha1 = Gamma.digamma((double)((double)k * this._alpha + 1.0));
            if (!VkLB) {
                VkLB = this.Vk(vkR, k, mPiAlphaK, logGammaKalpha1, logGammaK1);
            }
            if (!VkDpLB) {
                VkDpLB = this.VkDp(log_y, log_w, k, log_pwy, mPiAlphaK, logGammaKalpha1, logGammaK1, digammaKalpha1);
            }
            if (VkDpDpLB) continue;
            VkDpDpLB = this.VkDpDp(k, log_y, log_w, logs, logssq, mPiAlphaK, logGammaKalpha1, digammaKalpha1);
        }
        this._vDpSumSgn = Math.signum(this._logVDpSum);
        this._vDpDpSumSgn = Math.signum(this._logVDpDpSum);
        this._logVSum = Math.log(Math.max(0.0, this._logVSum));
        this._logVDpSum = Math.log(Math.abs(this._logVDpSum));
        this._logVDpDpSum = Math.log(Math.abs(this._logVDpDpSum));
    }

    boolean Vk(double r, long k, double mPiAlphaK, double logGammaKalpha1, double logGammaK1) {
        double expInner = logGammaKalpha1 - logGammaK1 + (double)k * r;
        if (this._logVMax == 0.0) {
            this._logVMax = expInner;
        }
        double vSumInc = Math.exp(expInner - this._logVMax) * Math.sin(mPiAlphaK);
        if (k % 2L == 1L) {
            vSumInc *= -1.0;
        }
        this._logVSum += vSumInc;
        if (this._needDp || this._needDpDp) {
            return (Math.abs(vSumInc) + 1.0E-12) / (Math.abs(this._logVSum) + 1.0E-12) < 1.0E-12 && expInner - this._logVMax < -37.0;
        }
        return expInner - this._logVMax < -37.0;
    }

    boolean VkDp(double log_y, double log_w, long k, double log_pwy, double mPiAlphaK, double logGammaKalpha1, double logGammaK1, double digammaKalpha1) {
        double logInvDenom = (double)(-k) * log_pwy - logGammaK1;
        double logInner = Math.sin(mPiAlphaK) * (this._invp1sq * (this._log_phi - log_w - log_y + digammaKalpha1) - this._invp2 + this._invp1sq * (this._logp1 + this._p2)) - Math.PI * this._invp1sq * Math.cos(mPiAlphaK);
        double vDpSumInc = Math.signum(logInner) * Math.exp((double)k * this._alpha * this._logp1 + logInvDenom + logGammaKalpha1 + Math.log(Math.abs(logInner)) + Math.log(k) + (double)k * this._logPhip1inv - this._logVMax);
        if (k % 2L == 1L) {
            vDpSumInc *= -1.0;
        }
        this._logVDpSum += vDpSumInc;
        return (Math.abs(vDpSumInc) + 1.0E-12) / (Math.abs(this._logVDpSum) + 1.0E-12) < 1.0E-12;
    }

    boolean VkDpDp(long k, double log_y, double log_w, double logs, double logssq, double mPiAlphaK, double logGammaKalpha1, double digammaKalpha1) {
        if (k < 1L) {
            return true;
        }
        double vDpDpSumInc = -(Math.PI * 2 * ((double)k * this._p2 * digammaKalpha1 + (this._p * (logs - 2.0) - 2.0 * logs + 3.0) * (double)k - this._p2sq - this._p2) * this._p2 * Math.cos(mPiAlphaK) - (this._ppp * (2.0 * logs - 5.0) - this._p2sq * (double)k * Math.pow(digammaKalpha1, 2.0) + 4.0 * this._pisq * (double)k + (this._pisq * (double)k + (double)k * logssq - 2.0 * ((double)k * this._log_phi - (double)k * log_w - (double)k * log_y - (double)(2L * k) + 5.0) * this._logp1 + 2.0 * ((double)k * log_w + (double)k * log_y + (double)(2L * k) - 5.0) * this._log_phi - 2.0 * ((double)k * log_y + (double)(2L * k) - 5.0) * log_w - (double)(2L * (2L * k - 5L)) * log_y - (double)(4L * k) + 22.0) * this._pp + (double)(4L * k) * logssq - this._p2sq * (double)k * Gamma.trigamma((double)((double)k * this._alpha + 1.0)) - 2.0 * (2.0 * this._pisq * (double)k + (double)(2L * k) * logssq - ((double)(4L * k) * this._log_phi - (double)(4L * k) * log_w - (double)(4L * k) * log_y - (double)(7L * k) + 8.0) * this._logp1 + ((double)(4L * k) * log_w + (double)(4L * k) * log_y + (double)(7L * k) - 8.0) * this._log_phi - ((double)(4L * k) * log_y + (double)(7L * k) - 8.0) * log_w - (double)(7L * k - 8L) * log_y - (double)(6L * k) + 16.0) * this._p - 4.0 * ((double)(2L * k) * this._log_phi - (double)(2L * k) * log_w - (double)(2L * k) * log_y - (double)(3L * k) + 2.0) * this._logp1 + 4.0 * ((double)(2L * k) * log_w + (double)(2L * k) * log_y + (double)(3L * k) - 2.0) * this._log_phi - 4.0 * ((double)(2L * k) * log_y + (double)(3L * k) - 2.0) * log_w - (double)(4L * (3L * k - 2L)) * log_y - 2.0 * (((double)k * logs - (double)(2L * k) + 5.0) * this._pp - this._ppp - ((double)(4L * k) * logs - (double)(7L * k) + 8.0) * this._p + (double)(4L * k) * logs - (double)(6L * k) + 4.0) * digammaKalpha1 - (double)(9L * k) + 15.0) * Math.sin(-mPiAlphaK)) * Math.pow(-1.0, k) * Math.exp((double)k * this._alpha * this._logp1 + ((double)k - (double)k * this._alpha) * log_w + (double)(-k) * this._alpha * log_y + logGammaKalpha1 + this._logInvDenom2ConstPart - (double)k * this._logp2 - (double)k * this._invp1 * this._log_phi - Gamma.logGamma((double)k) - this._logVMax);
        this._logVDpDpSum += vDpDpSumInc;
        return (Math.abs(vDpDpSumInc) + 1.0E-12) / (Math.abs(this._logVDpDpSum) + 1.0E-12) < 1.0E-12;
    }

    private double tweedieInversion(double y, double mu, double w) {
        assert (this._p != 1.0 && this._p != 2.0);
        if (this._p < 2.0 && this._p > 1.0) {
            if (y < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (y == 0.0) {
                return Math.pow(mu, 2.0 - this._p) / (this._phi * this._p2);
            }
        } else if (this._p > 2.0 && y <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double dev = TweedieEstimator.deviance(y, mu, this._p);
        double phi = this._phi / Math.pow(y, -this._p2);
        if (this._p > 1.0 && this._p < 2.0) {
            return w * (Math.log(Math.max(0.0, this.smallP(1.0, 1.0, phi))) - Math.log(y) - dev / (2.0 * this._phi));
        }
        if (this._p > 2.0) {
            return w * (Math.log(Math.max(0.0, this.bigP(1.0, 1.0, phi))) - Math.log(y) - dev / (2.0 * this._phi));
        }
        return 0.0;
    }

    double calcCGFRe(double x, double phi) {
        double psi = Math.atan((1.0 - this._p) * x * phi);
        double front = 1.0 / (phi * (2.0 - this._p));
        double denom = Math.pow(Math.cos(psi), this._alpha);
        return front * Math.cos(psi * this._alpha) / denom - front;
    }

    double calcCGFIm(double y, double x, double phi) {
        double psi = Math.atan((1.0 - this._p) * x * phi);
        double front = 1.0 / (phi * (2.0 - this._p));
        double denom = Math.pow(Math.cos(psi), this._alpha);
        return front * Math.sin(psi * this._alpha) / denom - x * y;
    }

    double calcDCGFRe(double x, double phi) {
        double psi = Math.atan((1.0 - this._p) * x * phi);
        double alpha = 1.0 / (1.0 - this._p);
        double denom = Math.pow(Math.cos(psi), alpha);
        return -(Math.sin(psi * alpha) / denom);
    }

    double calcDCGFIm(double y, double x, double phi) {
        double psi = Math.atan((1.0 - this._p) * x * phi);
        double alpha = 1.0 / (1.0 - this._p);
        double denom = Math.pow(Math.cos(psi), alpha);
        return Math.cos(psi * alpha) / denom - y;
    }

    double imgdcgf(double x, double phi) {
        double psi = Math.atan((1.0 - this._p) * x * phi);
        double alpha = 1.0 / (1.0 - this._p);
        return Math.cos(psi * alpha) / Math.exp(alpha * Math.log(Math.cos(psi)));
    }

    private FindKMaxResult findKMax(double y, double phi) {
        int mMax;
        double tMax;
        double kMax;
        double fHi;
        double fLo;
        double zHi;
        double zLo;
        double dz;
        double z;
        double largest = 1.0E30;
        int largeInt = 100000000;
        double psi = 1.5707963267948966 * (1.0 - this._p) / (2.0 * this._p - 1.0);
        double z2 = 1.0 / (phi * (1.0 - this._p)) * Math.tan(psi);
        double dz2 = this.imgdcgf(z2, phi) - y;
        DK dk = new DK(phi);
        if (this._p > 2.0) {
            double front = -1.0 / (phi * (1.0 - this._p));
            double inner = 1.0 / y * Math.cos(-Math.PI / (2.0 * (1.0 - this._p)));
            double z1 = front * Math.pow(inner, this._p - 1.0);
            double dz1 = this.imgdcgf(z1, phi) - y;
            if (dz1 > 0.0) {
                if (z1 > z2) {
                    z = z1;
                    dz = dz1;
                } else {
                    z = z2;
                    dz = dz2;
                }
            } else if (dz2 < 0.0) {
                if (z1 > z2) {
                    z = z2;
                    dz = dz2;
                } else {
                    z = z1;
                    dz = dz1;
                }
            } else {
                z = z2;
                dz = dz2;
            }
        } else {
            z = z2;
            dz = dz2;
        }
        if (dz > 0.0) {
            zLo = z;
            zHi = z + 10.0;
            fLo = dk.apply(y, zLo);
            fHi = dk.apply(y, zHi);
            while (fHi > 0.0 && zHi <= 1.0000000000000001E29) {
                zLo = zHi;
                zHi = 1.1 * zHi + 1.0;
                fLo = fHi;
                fHi = dk.apply(y, zHi);
            }
        } else {
            zLo = z / 2.0;
            zHi = z;
            fLo = dk.apply(y, zLo);
            fHi = dk.apply(y, zHi);
            while (fLo < 0.0) {
                zHi = zLo;
                fHi = fLo;
                fLo = dk.apply(y, zLo /= 2.0);
            }
        }
        if ((kMax = this.calcCGFIm(y, tMax = (z = this.newtonMethodWithBisection(y, zLo, zHi, z = zLo == zHi ? zLo : zLo - fLo * (zHi - zLo) / (fHi - fLo), dk, new ImgDDCGF(phi))), phi)) < 0.0) {
            kMax = Math.abs(kMax);
            mMax = 100000000;
        } else {
            int dpmMax = (int)(kMax / Math.PI - 0.5);
            mMax = Math.min(dpmMax, 100000000);
        }
        return new FindKMaxResult(kMax, tMax, mMax);
    }

    private double otherZero(double y, double phi) {
        double tHi;
        double tLo;
        int m;
        double psi = 1.5707963267948966 * (1.0 - this._p) / (2.0 * this._p - 1.0);
        double inflec = Math.atan(psi) / ((1.0 - this._p) * phi);
        double smallest = 1.0E-30;
        IntegrateImCGF intIm = new IntegrateImCGF(phi);
        DK dk = new DK(phi);
        if (y >= 1.0) {
            m = -1;
            tLo = Math.min(1.0E-5, inflec);
            tHi = Math.max(inflec, 1.0E-5);
        } else {
            FindKMaxResult fndKMaxRes = this.findKMax(y, phi);
            double kMax = fndKMaxRes._kMax;
            double tMax = fndKMaxRes._tMax;
            if (kMax >= 1.5707963267948966) {
                m = 0;
                tLo = smallest;
                tHi = tMax;
            } else {
                m = -1;
                tLo = Math.min(tMax, inflec);
                tHi = Math.max(tMax, inflec);
            }
        }
        double fLo = intIm.apply(y, tLo, m);
        double fHi = intIm.apply(y, tHi, m);
        double zStep = Math.abs(tHi - tLo);
        while (fLo * fHi > 0.0) {
            tLo = tHi;
            fLo = intIm.apply(y, tLo, m);
            fHi = intIm.apply(y, tHi += 0.2 * zStep, m);
        }
        double t0 = tLo - fLo * (tHi - tLo) / (fHi - fLo);
        return this.newtonMethodWithBisectionWithM(y, tLo, tHi, t0, intIm, dk, m);
    }

    private ZeroBounds findBounds(double y, double phi) {
        ZeroFunction zeroFunction = new ZeroFunction(phi);
        double t = Math.PI / y;
        double f1 = zeroFunction.apply(y, 0.01);
        double t3 = this.otherZero(y, phi);
        double tOld = t;
        t = Math.min(t, t3);
        double f2 = zeroFunction.apply(y, t);
        double tStep = 0.2 * t;
        while (f1 * f2 > 0.0 && f1 != f2) {
            tOld = t;
            t = tOld + tStep;
            f1 = f2;
            f2 = zeroFunction.apply(y, t);
        }
        return new ZeroBounds(tOld, t, f1, f2);
    }

    private double newtonMethodWithBisection(double y, double x1, double x2, double x0, Function2<Double, Double, Double> fun, Function2<Double, Double, Double> dfun) {
        double dxOld;
        double xh;
        double xl;
        double maxit = 100.0;
        double fl = (Double)fun.apply((Object)y, (Object)x1);
        double fh = (Double)fun.apply((Object)y, (Object)x2);
        if (fl == 0.0) {
            return x1;
        }
        if (fh == 0.0) {
            return x2;
        }
        if (fl < 0.0) {
            xl = x1;
            xh = x2;
        } else {
            xl = x2;
            xh = x1;
        }
        double result = x0;
        double dx = dxOld = Math.abs(x2 - x1);
        double f = (Double)fun.apply((Object)y, (Object)result);
        double df = (Double)dfun.apply((Object)y, (Object)result);
        int i = 0;
        while ((double)i < maxit) {
            if ((result - xh * df - f) * (result - xl) * df - f > 0.0 || Math.abs(2.0 * f) > Math.abs(dxOld * df)) {
                dxOld = dx;
                dx = 0.5 * (xh - xl);
                result = xl + dx;
                if (xl == result) {
                    return result;
                }
            } else {
                dxOld = dx;
                if (df == 0.0) {
                    return result;
                }
                dx = f / df;
                if (result == result - dx) {
                    return result;
                }
            }
            f = (Double)fun.apply((Object)y, (Object)result);
            df = (Double)dfun.apply((Object)y, (Object)result);
            if (f < 0.0) {
                xl = result;
            } else {
                xh = result;
            }
            ++i;
        }
        return result;
    }

    private double newtonMethodWithBisectionWithM(double y, double x1, double x2, double x0, Function3<Double, Double, Integer, Double> fun, Function2<Double, Double, Double> dfun, int m) {
        double dxOld;
        double xh;
        double xl;
        int maxit = 100;
        double fl = (Double)fun.apply((Object)y, (Object)x1, (Object)m);
        double fh = (Double)fun.apply((Object)y, (Object)x2, (Object)m);
        if (fl == 0.0) {
            return x1;
        }
        if (fh == 0.0) {
            return x2;
        }
        if (fl < 0.0) {
            xl = x1;
            xh = x2;
        } else {
            xl = x2;
            xh = x1;
        }
        double result = x0 > xl && x0 < xh ? x0 : (xl + xh) / 2.0;
        double dx = dxOld = Math.abs(x2 - x1);
        double f = (Double)fun.apply((Object)y, (Object)result, (Object)m);
        double df = (Double)dfun.apply((Object)y, (Object)result);
        for (int i = 0; i < maxit; ++i) {
            if ((result - xh * df - f) * (result - xl) * df - f > 0.0 || Math.abs(2.0 * f) > Math.abs(dxOld * df)) {
                dxOld = dx;
                dx = 0.5 * (xh - xl);
                result = xl + dx;
                if (xl == result) {
                    return result;
                }
            } else {
                dxOld = dx;
                dx = f / df;
                if (result == result - dx) {
                    return result;
                }
            }
            if (Math.abs(dx) < 1.0E-11) {
                return result;
            }
            f = (Double)fun.apply((Object)y, (Object)result, (Object)m);
            df = (Double)dfun.apply((Object)y, (Object)result);
            if (f < 0.0) {
                xl = result;
                continue;
            }
            xh = result;
        }
        return result;
    }

    private double gaussQuad(Function3<Double, Double, Double, Double> fun, double a, double b, double y, double mu) {
        double sum = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            double xLower = (b - a) / 2.0 * absc[i] + (b + a) / 2.0;
            double xUpper = (a - b) / 2.0 * absc[i] + (b + a) / 2.0;
            sum += weights[i] * ((Double)fun.apply((Object)y, (Object)mu, (Object)xLower) + (Double)fun.apply((Object)y, (Object)mu, (Object)xUpper));
        }
        return sum * (b - a) / 2.0;
    }

    private double smallP(double y, double mu, double phi) {
        double result;
        int i;
        double[][] mMatrix = MemoryManager.malloc8d((int)2, (int)101);
        double[][] nMatrix = MemoryManager.malloc8d((int)2, (int)101);
        double area0 = 0.0;
        double area1 = 0.0;
        double w = 0.0;
        ZeroFunction zeroFunction = new ZeroFunction(phi);
        ZeroDerivFunction zeroDerivFunction = new ZeroDerivFunction(phi);
        ZeroBounds zb = this.findBounds(y, phi);
        double upper = zb.upperBound;
        double lower = zb.lowerBound;
        double fHi = zb.funcHi;
        double fLo = zb.funcLo;
        double t0 = upper - fHi * (upper - lower) / (fHi - fLo);
        double zero2 = this.newtonMethodWithBisection(y, lower, upper, t0, zeroFunction, zeroDerivFunction);
        double[] wOld = new double[3];
        int numZr = 20;
        double zDelta = zero2 / (double)numZr;
        double z1Hi = 0.0;
        FunctionForVariancePowerBetween1And2 f2 = new FunctionForVariancePowerBetween1And2(phi);
        for (i = 0; i < numZr; ++i) {
            double z1Lo = z1Hi;
            area0 += this.gaussQuad(f2, z1Lo, z1Hi += zDelta, y, mu);
        }
        double zero1 = zero2;
        double tStep = zero2 / 2.0;
        for (i = 0; i < 4; ++i) {
            lower = zero1 + tStep * 0.05;
            upper = zero1 + tStep * 0.3;
            fLo = zeroFunction.apply(y, lower);
            fHi = zeroFunction.apply(y, upper);
            while (fLo * fHi > 0.0 && lower != upper) {
                lower = upper;
                fLo = zeroFunction.apply(y, lower);
                fHi = zeroFunction.apply(y, upper += 0.5 * tStep);
            }
            zero2 = this.newtonMethodWithBisection(y, lower, upper, t0, zeroFunction, zeroDerivFunction);
            result = this.gaussQuad(f2, zero1, zero2, y, mu);
            area1 += result;
            tStep = zero2 - zero1;
            zero1 = zero2;
            t0 = zero2 + 0.8 * tStep;
        }
        int iteration = 0;
        double area = 0.0;
        double[] xVec = MemoryManager.malloc8d((int)101);
        xVec[0] = zero2;
        double relErr = Double.POSITIVE_INFINITY;
        SidiAcceleration sidi = new SidiAcceleration(mMatrix, nMatrix, wOld, xVec);
        while (iteration < 3 || iteration < 100 && Math.abs(relErr) > 1.0E-10) {
            ++iteration;
            lower = zero1 + 0.05 * tStep;
            upper = zero1 + 0.8 * tStep;
            fLo = zeroFunction.apply(y, lower);
            fHi = zeroFunction.apply(y, upper);
            while (fLo * fHi > 0.0 && lower != upper) {
                lower = upper;
                fLo = zeroFunction.apply(y, lower);
                fHi = zeroFunction.apply(y, upper += 0.5 * tStep);
            }
            t0 = lower - fLo * (upper - lower) / (fHi - fLo);
            zero2 = this.newtonMethodWithBisection(y, lower, upper, t0, zeroFunction, zeroDerivFunction);
            result = this.gaussQuad(f2, zero1, zero2, y, mu);
            xVec[iteration] = zero2;
            sidi.apply(area, result, w, iteration);
            w = sidi._w;
            relErr = sidi._relErr;
            if (iteration >= 3) {
                relErr = area0 + area1 + w == 0.0 ? Double.POSITIVE_INFINITY : (Math.abs(w - wOld[0]) + Math.abs(w - wOld[1])) / (area0 + area1 + w);
            }
            area += result;
            tStep = zero2 - zero1;
            zero1 = zero2;
        }
        result = (area0 + area1 + w) / Math.PI;
        return result;
    }

    private double bigP(double y, double mu, double phi) {
        double result;
        int maxit = 100;
        double aimRelErr = 1.0E-10;
        double[][] mMatrix = MemoryManager.malloc8d((int)2, (int)101);
        double[][] nMatrix = MemoryManager.malloc8d((int)2, (int)101);
        double w = 0.0;
        IntegrateImCGF intIm = new IntegrateImCGF(phi);
        DK dk = new DK(phi);
        FunctionForVariancePowerGreaterThan2 f = new FunctionForVariancePowerGreaterThan2(phi);
        double largest = 1.0E30;
        double smallest = 1.0E-30;
        int m = -1;
        double area = 0.0;
        int iteration = 0;
        double relErr = 1.0;
        double[] wOld = new double[3];
        if (y >= 1.0) {
            double fHi;
            double zHi;
            double zero1 = 0.0;
            double zero = Math.PI / (2.0 * y);
            double zLo = 2.827433388230814 / (2.0 * y);
            if (y > 1.0) {
                zHi = Math.PI / (2.0 * (y - 1.0));
                fHi = intIm.apply(y, zHi, m);
            } else {
                zHi = zero * 2.0;
                fHi = intIm.apply(y, zHi, m);
            }
            double fLo = intIm.apply(y, zLo, m);
            boolean allOk = true;
            while (allOk && fHi * fLo > 0.0 && zHi != zLo) {
                zLo = zHi;
                fLo = intIm.apply(y, zLo, m);
                fHi = intIm.apply(y, zHi *= 1.5, m);
                if (!(zHi > largest / 10.0)) continue;
                allOk = false;
            }
            if (zHi > largest / 10.0) {
                allOk = false;
            }
            if (!allOk) {
                double result2 = 0.0;
                return result2;
            }
            double zero2 = this.newtonMethodWithBisectionWithM(y, zLo, zHi, zero, intIm, dk, m);
            double[] xVec = MemoryManager.malloc8d((int)101);
            xVec[0] = zero2;
            SidiAcceleration sidi = new SidiAcceleration(mMatrix, nMatrix, wOld, xVec);
            double area0 = this.gaussQuad(f, zero1, zero2, y, mu);
            while (iteration < 4 || iteration < 100 && Math.abs(relErr) > 1.0E-10) {
                --m;
                zero1 = zero2;
                zero = zero2;
                zLo = zero2;
                zHi = zero2 * 1.5;
                if (zHi > largest / 10.0) {
                    allOk = false;
                    fLo = 0.0;
                    fHi = 0.0;
                } else {
                    fLo = intIm.apply(y, zLo, m);
                    fHi = intIm.apply(y, zHi, m);
                }
                while (allOk && fHi * fLo > 0.0 && zHi != zLo) {
                    zLo = zHi;
                    fLo = intIm.apply(y, zLo, m);
                    fHi = intIm.apply(y, zHi *= 1.5, m);
                    zero = zHi - fHi * (zHi - zLo) / (fHi - fLo);
                    if (!(zHi > largest / 10.0)) continue;
                    allOk = false;
                }
                if (zHi > largest / 10.0) {
                    allOk = false;
                }
                if (!allOk) {
                    result = 0.0;
                    return result;
                }
                zero2 = this.newtonMethodWithBisectionWithM(y, zLo, zHi, zero, intIm, dk, m);
                result = this.gaussQuad(f, zero1, zero2, y, mu);
                xVec[++iteration] = zero2;
                sidi.apply(area, result, w, iteration);
                w = sidi._w;
                relErr = area0 + w == 0.0 ? Double.POSITIVE_INFINITY : (Math.abs(w - wOld[0]) + Math.abs(w - wOld[1])) / (area0 + w);
                area += result;
            }
            result = area0 + w;
        } else {
            FindKMaxResult fndKmax = this.findKMax(y, phi);
            double kMax = fndKmax._kMax;
            double tMax = fndKmax._tMax;
            double mMax = fndKmax._mMax;
            if (kMax < 1.5707963267948966) {
                double fHi;
                double fLo;
                boolean allOk;
                double zero1 = 0.0;
                double zero = tMax + Math.PI / (2.0 * y);
                double zLo = tMax;
                double zHi = zero * 2.0;
                if (zHi > largest / 10.0) {
                    allOk = false;
                    fLo = 0.0;
                    fHi = 0.0;
                } else {
                    allOk = true;
                    fLo = intIm.apply(y, zLo, m);
                    fHi = intIm.apply(y, zHi, m);
                }
                while (allOk && fHi * fLo > 0.0 && zHi != zLo) {
                    zLo = zHi;
                    fLo = intIm.apply(y, zLo, m);
                    fHi = intIm.apply(y, zHi *= 1.5, m);
                    if (!(zHi > largest / 10.0)) continue;
                    allOk = false;
                }
                if (zHi > largest / 10.0) {
                    allOk = false;
                }
                if (!allOk) {
                    double result3 = 0.0;
                    return result3;
                }
                double zero2 = this.newtonMethodWithBisectionWithM(y, zLo, zHi, zero, intIm, dk, m);
                double[] xVec = MemoryManager.malloc8d((int)101);
                xVec[0] = zero2;
                SidiAcceleration sidi = new SidiAcceleration(mMatrix, nMatrix, wOld, xVec);
                double area0 = this.gaussQuad(f, zero1, zero2, y, mu);
                while (iteration < 4 || iteration < 100 && Math.abs(relErr) > 1.0E-10) {
                    --m;
                    double diff = zero2 - zero1;
                    zero1 = zero2;
                    zLo = zero2 - 0.01 * diff;
                    zHi = zero2 + 2.0 * diff;
                    if (zHi > largest / 10.0) {
                        allOk = false;
                        fLo = 0.0;
                        fHi = 0.0;
                    } else {
                        fLo = intIm.apply(y, zLo, m);
                        fHi = intIm.apply(y, zHi, m);
                    }
                    while (allOk && fHi * fLo > 0.0 && zHi != zLo) {
                        zLo = zHi;
                        fLo = intIm.apply(y, zLo, m);
                        fHi = intIm.apply(y, zHi *= 1.5, m);
                        if (!(zHi > largest / 10.0)) continue;
                        allOk = false;
                    }
                    if (zHi > largest / 10.0) {
                        allOk = false;
                    }
                    if (!allOk) {
                        result = 0.0;
                        return result;
                    }
                    zero = zLo - fLo * (zHi - zLo) / (fHi - fLo);
                    zero2 = this.newtonMethodWithBisectionWithM(y, zLo, zHi, zero, intIm, dk, m);
                    result = this.gaussQuad(f, zero1, zero2, y, mu);
                    xVec[++iteration] = zero2;
                    sidi.apply(area, result, w, iteration);
                    w = sidi._w;
                    relErr = area0 + w == 0.0 ? Double.POSITIVE_INFINITY : (Math.abs(w - wOld[0]) + Math.abs(w - wOld[1])) / (area0 + w);
                    area += result;
                }
                result = area0 + w;
            } else {
                double fHi;
                double fLo;
                boolean allOk;
                double zero1 = 0.0;
                double zero = Math.PI / (2.0 * (1.0 - y));
                m = 0;
                int firstM = 1;
                double zLo = smallest;
                double zHi = tMax;
                if (zHi > largest / 10.0) {
                    allOk = false;
                    fLo = 0.0;
                    fHi = 0.0;
                } else {
                    allOk = true;
                    fLo = intIm.apply(y, zLo, m);
                    fHi = intIm.apply(y, zHi, m);
                }
                double diff = zHi - zLo;
                while (allOk && fHi * fLo > 0.0 && zHi != zLo) {
                    zLo = zHi;
                    fLo = intIm.apply(y, zLo, m);
                    fHi = intIm.apply(y, zHi += 0.1 * diff, m);
                    if (!(zHi > largest / 10.0)) continue;
                    allOk = false;
                }
                if (zHi > largest / 10.0) {
                    allOk = false;
                }
                if (!allOk) {
                    double result4 = 0.0;
                    return result4;
                }
                double zero2 = this.newtonMethodWithBisectionWithM(y, zLo, zHi, zero, intIm, dk, m);
                double[] xVec = MemoryManager.malloc8d((int)101);
                xVec[0] = zero2;
                double area0 = this.gaussQuad(f, zero1, zero2, y, mu);
                diff = zero2 - zero1;
                while (iteration < 4 || iteration < 100 && Math.abs(relErr) > 1.0E-10) {
                    zLo = zero2 - 1.0E-5 * diff;
                    zHi = zero2 + 2.0 * diff;
                    zero1 = zero2;
                    if ((double)m < mMax) {
                        if (firstM == 1) {
                            ++m;
                            zHi = tMax;
                        } else {
                            --m;
                            zLo = Math.max(zLo, tMax);
                        }
                    } else if ((double)m == mMax) {
                        if (firstM == 1) {
                            ++firstM;
                            zero = tMax + (tMax - zero2);
                            zLo = tMax;
                        } else {
                            --m;
                        }
                    }
                    if (zHi > largest / 10.0) {
                        allOk = false;
                        fLo = 0.0;
                        fHi = 0.0;
                    } else {
                        fLo = intIm.apply(y, zLo, m);
                        fHi = intIm.apply(y, zHi, m);
                    }
                    while (allOk && fHi * fLo > 0.0 && zHi != zLo) {
                        zLo = zHi;
                        fLo = intIm.apply(y, zLo, m);
                        fHi = intIm.apply(y, zHi *= 1.5, m);
                        if (!(zHi > largest / 10.0)) continue;
                        allOk = false;
                    }
                    if (zHi > largest / 10.0) {
                        allOk = false;
                    }
                    if (!allOk) {
                        result = 0.0;
                        return result;
                    }
                    zero2 = this.newtonMethodWithBisectionWithM(y, zLo, zHi, zero, intIm, dk, m);
                    result = this.gaussQuad(f, zero1, zero2, y, mu);
                    xVec[++iteration] = zero2;
                    SidiAcceleration sidi = new SidiAcceleration(mMatrix, nMatrix, wOld, xVec);
                    sidi.apply(area, result, w, iteration);
                    w = sidi._w;
                    relErr = sidi._relErr;
                    area += result;
                }
                result = area0 + w;
            }
        }
        result = Math.abs(result / Math.PI);
        return result;
    }

    private static class SidiAcceleration {
        final double[][] _mMatrix;
        final double[][] _nMatrix;
        final double[] _wOld;
        final double[] _xVec;
        double _w;
        double _relErr;
        double _absErr;

        private SidiAcceleration(double[][] mMatrix, double[][] nMatrix, double[] wOld, double[] xVec) {
            this._mMatrix = mMatrix;
            this._nMatrix = nMatrix;
            this._wOld = wOld;
            this._xVec = xVec;
        }

        void apply(double FF, double psi, double w, int znum) {
            double largest = 1.0E30;
            this._w = w;
            if (Math.abs(psi) < 1.0E-31) {
                this._w = FF;
                this._relErr = 0.0;
                return;
            }
            this._mMatrix[1][0] = FF / psi;
            this._nMatrix[1][0] = 1.0 / psi;
            for (int i = 1; i < znum; ++i) {
                double denom = 1.0 / this._xVec[znum - i] - 1.0 / this._xVec[znum];
                this._mMatrix[1][i] = (this._mMatrix[0][i - 1] - this._mMatrix[1][i - 1]) / denom;
                this._nMatrix[1][i] = (this._nMatrix[0][i - 1] - this._nMatrix[1][i - 1]) / denom;
            }
            if (!(Math.abs(this._mMatrix[1][znum - 1]) > 1.0E30) && !(Math.abs(this._nMatrix[1][znum - 1]) > 1.0E30)) {
                if (znum > 1) {
                    this._w = this._mMatrix[1][znum - 1] / this._nMatrix[1][znum - 1];
                }
                this._wOld[0] = this._wOld[1];
                this._wOld[1] = this._wOld[2];
                this._wOld[2] = this._w;
            }
            if (znum > 2) {
                this._relErr = Math.abs(this._w - this._wOld[0]) + Math.abs(this._w - this._wOld[1]) / this._w;
                this._absErr = Math.abs(this._wOld[2] - this._wOld[1]);
            } else {
                this._relErr = 1.0;
            }
            System.arraycopy(this._mMatrix[1], 0, this._mMatrix[0], 0, znum);
            System.arraycopy(this._nMatrix[1], 0, this._nMatrix[0], 0, znum);
        }
    }

    private final class ZeroDerivFunction
    implements Function2<Double, Double, Double> {
        private final double _transformedPhi;

        public ZeroDerivFunction(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double y, Double x) {
            double rl = TweedieEstimator.this.calcCGFRe(x, this._transformedPhi);
            double im = TweedieEstimator.this.calcCGFIm(y, x, this._transformedPhi);
            double drl = TweedieEstimator.this.calcDCGFRe(x, this._transformedPhi);
            double dim = TweedieEstimator.this.calcDCGFIm(y, x, this._transformedPhi);
            double lambda = 1.0 / (this._transformedPhi * (2.0 - TweedieEstimator.this._p));
            return Math.exp(rl) * (-dim * Math.sin(im)) + Math.exp(rl) * drl * Math.cos(im) + Math.exp(-lambda) * y * Math.sin(x * y);
        }
    }

    private final class ZeroFunction
    implements Function2<Double, Double, Double> {
        private final double _transformedPhi;

        public ZeroFunction(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double y, Double x) {
            double rl = TweedieEstimator.this.calcCGFRe(x, this._transformedPhi);
            double im = TweedieEstimator.this.calcCGFIm(y, x, this._transformedPhi);
            double lambda = 1.0 / (this._transformedPhi * (2.0 - TweedieEstimator.this._p));
            return Math.exp(rl) * Math.cos(im) - Math.exp(-lambda) * Math.cos(x * y);
        }
    }

    private final class FunctionForVariancePowerGreaterThan2
    implements Function3<Double, Double, Double, Double> {
        private final double _transformedPhi;

        public FunctionForVariancePowerGreaterThan2(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double y, Double mu, Double x) {
            double rl = TweedieEstimator.this.calcCGFRe(x, this._transformedPhi);
            double im = TweedieEstimator.this.calcCGFIm(y, x, this._transformedPhi);
            return Math.exp(rl) * Math.cos(im);
        }
    }

    private final class FunctionForVariancePowerBetween1And2
    implements Function3<Double, Double, Double, Double> {
        private final double _transformedPhi;

        public FunctionForVariancePowerBetween1And2(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double y, Double mu, Double x) {
            double lambda = Math.pow(mu, 2.0 - TweedieEstimator.this._p) / (this._transformedPhi * (2.0 - TweedieEstimator.this._p));
            if (x == 0.0) {
                return 1.0;
            }
            double rl = TweedieEstimator.this.calcCGFRe(x, this._transformedPhi);
            double im = TweedieEstimator.this.calcCGFIm(y, x, this._transformedPhi);
            return Math.exp(rl) * Math.cos(im) - Math.exp(-lambda) * Math.cos(x * y);
        }
    }

    private final class IntegrateImCGF
    implements Function3<Double, Double, Integer, Double> {
        private final double _transformedPhi;

        public IntegrateImCGF(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double y, Double x, Integer m) {
            double im = TweedieEstimator.this.calcCGFIm(y, x, this._transformedPhi);
            return -1.5707963267948966 - (double)m.intValue() * Math.PI + im;
        }
    }

    private final class DK
    implements Function2<Double, Double, Double> {
        private final double _transformedPhi;

        public DK(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double y, Double x) {
            return TweedieEstimator.this.calcDCGFIm(y, x, this._transformedPhi);
        }
    }

    private final class ImgDDCGF
    implements Function2<Double, Double, Double> {
        private final double _transformedPhi;

        public ImgDDCGF(double phi) {
            this._transformedPhi = phi;
        }

        public Double apply(Double x, Double unusedHere) {
            double psi = Math.atan((1.0 - TweedieEstimator.this._p) * x * this._transformedPhi);
            double alpha = TweedieEstimator.this._p / (1.0 - TweedieEstimator.this._p);
            double top = Math.sin(psi * alpha);
            double bottom = Math.exp(alpha * Math.log(Math.abs(Math.cos(psi))));
            return -this._transformedPhi * top / bottom;
        }
    }

    private static final class FindKMaxResult {
        int _mMax;
        double _kMax;
        double _tMax;

        FindKMaxResult(double kMax, double tMax, int mMax) {
            this._kMax = kMax;
            this._tMax = tMax;
            this._mMax = mMax;
        }
    }

    private static final class ZeroBounds {
        final double lowerBound;
        final double upperBound;
        final double funcLo;
        final double funcHi;

        private ZeroBounds(double lowerBound, double upperBound, double funcLo, double funcHi) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.funcLo = funcLo;
            this.funcHi = funcHi;
        }
    }

    static enum LikelihoodEstimator {
        series,
        inversion,
        saddlepoint,
        gamma,
        poisson,
        invGaussian;

    }
}

