/*
 * Decompiled with CFR 0.152.
 */
package hex.gram;

import hex.DataInfo;
import hex.FrameTask2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Future;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.Futures;
import water.H2O;
import water.H2ORuntime;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.util.ArrayUtils;

public final class Gram
extends Iced<Gram> {
    boolean _hasIntercept;
    public double[][] _xx;
    public double[] _diag;
    public double[][] _frame2DProduce;
    public int _diagN;
    final int _denseN;
    int _fullN;
    static final int MIN_TSKSZ = 10000;
    public transient XXCache _xxCache;
    public double _diagAdded;
    private static double r2_eps = 1.0E-7;
    private static final int MIN_PAR = 1000;
    private double[][] XX = null;

    public Gram(DataInfo dinfo) {
        this(dinfo.fullN(), dinfo.largestCat(), dinfo.numNums(), dinfo._cats, true);
    }

    public Gram(int N, int diag, int dense, int sparse, boolean hasIntercept) {
        this._hasIntercept = hasIntercept;
        this._fullN = N + (this._hasIntercept ? 1 : 0);
        this._xx = new double[this._fullN - diag][];
        this._diagN = diag;
        this._diag = MemoryManager.malloc8d((int)this._diagN);
        this._denseN = dense;
        for (int i = 0; i < this._fullN - this._diagN; ++i) {
            this._xx[i] = MemoryManager.malloc8d((int)(diag + i + 1));
        }
    }

    public Gram(double[][] xxCacheNew) {
        this._xx = xxCacheNew;
        this._xxCache = new XXCache(xxCacheNew, false, false);
        this._denseN = xxCacheNew.length;
        this._fullN = xxCacheNew.length;
    }

    public void dropIntercept() {
        if (!this._hasIntercept) {
            throw new IllegalArgumentException("Has no intercept");
        }
        double[][] xx = new double[this._xx.length - 1][];
        for (int i = 0; i < xx.length; ++i) {
            xx[i] = this._xx[i];
        }
        this._xx = xx;
        this._hasIntercept = false;
        --this._fullN;
    }

    public Gram deep_clone() {
        Gram res = (Gram)this.clone();
        if (this._xx != null) {
            res._xx = ArrayUtils.deepClone((double[][])this._xx);
        }
        if (this._diag != null) {
            res._diag = (double[])res._diag.clone();
        }
        return res;
    }

    public final int fullN() {
        return this._fullN;
    }

    public void addDiag(double[] ds) {
        int i;
        for (i = 0; i < Math.min(this._diagN, ds.length); ++i) {
            int n = i;
            this._diag[n] = this._diag[n] + ds[i];
        }
        while (i < ds.length) {
            double[] dArray = this._xx[i - this._diagN];
            int n = i;
            dArray[n] = dArray[n] + ds[i];
            ++i;
        }
    }

    public void addGAMPenalty(Integer[] activeColumns, double[][][] ds, int[][] gamIndices) {
        int numGamCols = gamIndices.length;
        for (int gamInd = 0; gamInd < numGamCols; ++gamInd) {
            int numKnots = gamIndices[gamInd].length;
            for (int betaInd = 0; betaInd < numKnots; ++betaInd) {
                Integer betaIndex = gamIndices[gamInd][betaInd];
                if (activeColumns != null && (betaIndex = Integer.valueOf(Arrays.binarySearch((Object[])activeColumns, betaIndex))) < 0) continue;
                for (int betaIndj = 0; betaIndj <= betaInd; ++betaIndj) {
                    Integer betaIndexJ = gamIndices[gamInd][betaIndj];
                    if (activeColumns != null && (betaIndexJ = Integer.valueOf(Arrays.binarySearch((Object[])activeColumns, betaIndexJ))) < 0) continue;
                    int rowLen = this._xx[betaIndex - this._diagN].length;
                    if (betaIndexJ >= rowLen) continue;
                    double[] dArray = this._xx[betaIndex - this._diagN];
                    int n = betaIndexJ;
                    dArray[n] = dArray[n] + 2.0 * ds[gamInd][betaInd][betaIndj];
                }
            }
        }
    }

    public double get(int i, int j) {
        if (j > i) {
            int k = i;
            i = j;
            j = k;
        }
        if (i < this._diagN) {
            return j == i ? this._diag[i] : 0.0;
        }
        return this._xx[i - this._diagN][j];
    }

    public void addDiag(double d) {
        this.addDiag(d, false);
    }

    public void addDiag(double d, boolean add2Intercept) {
        this._diagAdded += d;
        int i = 0;
        while (i < this._diag.length) {
            int n = i++;
            this._diag[n] = this._diag[n] + d;
        }
        int ii = !this._hasIntercept || add2Intercept ? 0 : 1;
        for (int i2 = 0; i2 < this._xx.length - ii; ++i2) {
            double[] dArray = this._xx[i2];
            int n = this._xx[i2].length - 1;
            dArray[n] = dArray[n] + d;
        }
    }

    public double sparseness() {
        double[][] xx = this.getXX();
        double nzs = 0.0;
        for (int i = 0; i < xx.length; ++i) {
            for (int j = 0; j < xx[i].length; ++j) {
                if (xx[i][j] == 0.0) continue;
                nzs += 1.0;
            }
        }
        return nzs / (double)(xx.length * xx.length);
    }

    public double diagSum() {
        double res = 0.0;
        if (this._diag != null) {
            for (double d : this._diag) {
                res += d;
            }
        }
        if (this._xx != null) {
            for (double[] x : this._xx) {
                res += x[x.length - 1];
            }
        }
        return res;
    }

    private final void updateZij(int i, int j, double[][] Z, double[] gamma) {
        double[] Zi = Z[i];
        double Zij = Zi[j];
        for (int k = 0; k < j; ++k) {
            Zij -= gamma[k] * Zi[k];
        }
        Zi[j] = Zij;
    }

    private final void updateZ(double[] gamma, double[][] Z, int j) {
        for (int i = j + 1; i < Z.length; ++i) {
            this.updateZij(i, j, Z, gamma);
        }
    }

    public Cholesky qrCholesky(ArrayList<Integer> dropped_cols, boolean standardized) {
        int i;
        final double[][] Z = this.getXX(true, true);
        double[][] R = new double[Z.length][];
        double[] Zdiag = new double[Z.length];
        double[] ZdiagInv = new double[Z.length];
        for (i = 0; i < Z.length; ++i) {
            Zdiag[i] = Z[i][i];
            ZdiagInv[i] = 1.0 / Zdiag[i];
        }
        for (int j = 0; j < Z.length; ++j) {
            double rs_tot;
            R[j] = new double[j + 1];
            final double[] gamma = R[j];
            for (int l = 0; l <= j; ++l) {
                gamma[l] = Z[j][l] * ZdiagInv[l];
            }
            double zjj = Z[j][j];
            for (int k = 0; k < j; ++k) {
                zjj += gamma[k] * (gamma[k] * Z[k][k] - 2.0 * Z[j][k]);
            }
            double d = rs_tot = standardized ? ZdiagInv[j] : 1.0 / (Zdiag[j] - Z[j][0] * ZdiagInv[0] * Z[j][0]);
            if (j > 0 && zjj * rs_tot < r2_eps) {
                zjj = 0.0;
                dropped_cols.add(j - 1);
                ZdiagInv[j] = 0.0;
            } else {
                ZdiagInv[j] = 1.0 / zjj;
            }
            Z[j][j] = zjj;
            int jchunk = Math.max(1, 1000 / (Z.length - j));
            int nchunks = (Z.length - j - 1) / jchunk;
            nchunks = Math.min(nchunks, H2O.NUMCPUS);
            if (nchunks <= 1) {
                this.updateZ(gamma, Z, j);
                continue;
            }
            final int fjchunk = (Z.length - 1 - j) / nchunks;
            int rem = Z.length - 1 - j - fjchunk * nchunks;
            for (int i2 = Z.length - rem; i2 < Z.length; ++i2) {
                this.updateZij(i2, j, Z, gamma);
            }
            RecursiveAction[] ras = new RecursiveAction[nchunks];
            final int fj = j;
            int k = 0;
            for (int i3 = j + 1; i3 < Z.length - rem; i3 += fjchunk) {
                final int fi = i3;
                ras[k++] = new RecursiveAction(){

                    protected final void compute() {
                        int max_i = Math.min(fi + fjchunk, Z.length);
                        for (int i = fi; i < max_i; ++i) {
                            Gram.this.updateZij(i, fj, Z, gamma);
                        }
                    }
                };
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])ras);
        }
        if (R.length < 500) {
            for (i = 0; i < R.length; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double[] dArray = R[i];
                    int n = j;
                    dArray[n] = dArray[n] * Math.sqrt(Z[j][j]);
                }
            }
        } else {
            RecursiveAction[] ras = new RecursiveAction[R.length];
            for (int i4 = 0; i4 < ras.length; ++i4) {
                final int fi = i4;
                final double[] Rrow = R[i4];
                ras[i4] = new RecursiveAction(){

                    protected void compute() {
                        for (int j = 0; j <= fi; ++j) {
                            int n = j;
                            Rrow[n] = Rrow[n] * Math.sqrt(Z[j][j]);
                        }
                    }
                };
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])ras);
        }
        if (dropped_cols.isEmpty()) {
            return new Cholesky(R, new double[0], true);
        }
        double[][] Rnew = new double[R.length - dropped_cols.size()][];
        for (int i5 = 0; i5 < Rnew.length; ++i5) {
            Rnew[i5] = new double[i5 + 1];
        }
        int j = 0;
        for (int i6 = 0; i6 < R.length; ++i6) {
            if (Z[i6][i6] == 0.0) continue;
            int k = 0;
            for (int l = 0; l <= i6; ++l) {
                if (k < dropped_cols.size() && l == dropped_cols.get(k) + 1) {
                    ++k;
                    continue;
                }
                Rnew[j][l - k] = R[i6][l];
            }
            ++j;
        }
        return new Cholesky(Rnew, new double[0], true);
    }

    public void dropCols(int[] cols) {
        int i;
        int diagCols = 0;
        for (int i2 = 0; i2 < cols.length && cols[i2] < this._diagN; ++i2) {
            ++diagCols;
        }
        int j = 0;
        if (diagCols > 0) {
            double[] diag = MemoryManager.malloc8d((int)(this._diagN - diagCols));
            int k = 0;
            for (i = 0; i < this._diagN; ++i) {
                if (j < cols.length && cols[j] == i) {
                    ++j;
                    continue;
                }
                diag[k++] = this._diag[i];
            }
            this._diag = diag;
        }
        double[][] xxNew = new double[this._xx.length - cols.length + diagCols][];
        int iNew = 0;
        for (i = 0; i < this._xx.length; ++i) {
            if (j < cols.length && this._diagN + i == cols[j]) {
                ++j;
                continue;
            }
            if (j == 0) {
                xxNew[iNew++] = this._xx[i];
                continue;
            }
            int l = 0;
            int m = 0;
            double[] x = MemoryManager.malloc8d((int)(this._xx[i].length - j));
            for (int k = 0; k < this._xx[i].length; ++k) {
                if (l < cols.length && k == cols[l]) {
                    ++l;
                    continue;
                }
                x[m++] = this._xx[i][k];
            }
            xxNew[iNew++] = x;
        }
        this._xx = xxNew;
        this._diagN = this._diag.length;
        this._fullN = this._xx[this._xx.length - 1].length;
    }

    public int[] findZeroCols() {
        int i;
        ArrayList<Integer> zeros = new ArrayList<Integer>();
        if (this._diag != null) {
            for (i = 0; i < this._diag.length; ++i) {
                if (this._diag[i] != 0.0) continue;
                zeros.add(i);
            }
        }
        for (i = 0; i < this._xx.length; ++i) {
            if (this._xx[i][this._xx[i].length - 1] != 0.0) continue;
            zeros.add(this._xx[i].length - 1);
        }
        if (zeros.size() == 0) {
            return new int[0];
        }
        int[] ary = new int[zeros.size()];
        for (int i2 = 0; i2 < zeros.size(); ++i2) {
            ary[i2] = (Integer)zeros.get(i2);
        }
        return ary;
    }

    public String toString() {
        if (this._fullN >= 1000) {
            return "Gram(" + this._fullN + ")";
        }
        return ArrayUtils.pprint((double[][])this.getXX(true, false));
    }

    public Cholesky cholesky(Cholesky chol) {
        return this.cholesky(chol, true, "");
    }

    public Cholesky cholesky(Cholesky chol, boolean parallelize, String id) {
        int fi;
        int i;
        long start = System.currentTimeMillis();
        if (chol == null) {
            double[][] xx = (double[][])this._xx.clone();
            for (int i2 = 0; i2 < xx.length; ++i2) {
                xx[i2] = (double[])xx[i2].clone();
            }
            chol = new Cholesky(xx, (double[])this._diag.clone());
        }
        final Cholesky fchol = chol;
        final int sparseN = this._diag.length;
        int denseN = this._fullN - sparseN;
        if (this._diag != null) {
            for (int i3 = 0; i3 < sparseN; ++i3) {
                chol._diag[i3] = Math.sqrt(this._diag[i3]);
                double d = 1.0 / chol._diag[i3];
                for (int j = 0; j < denseN; ++j) {
                    chol._xx[j][i3] = d * this._xx[j][i3];
                }
            }
        }
        ForkJoinTask[] fjts = new ForkJoinTask[denseN];
        final int[][] nz = new int[denseN][];
        for (i = 0; i < denseN; ++i) {
            fi = i;
            fjts[i] = new RecursiveAction(){

                protected void compute() {
                    int[] tmp = new int[sparseN];
                    double[] rowi = fchol._xx[fi];
                    int n = 0;
                    for (int k = 0; k < sparseN; ++k) {
                        if (rowi[k] == 0.0) continue;
                        tmp[n++] = k;
                    }
                    nz[fi] = Arrays.copyOf(tmp, n);
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])fjts);
        for (i = 0; i < denseN; ++i) {
            fi = i;
            fjts[i] = new RecursiveAction(){

                protected void compute() {
                    double[] rowi = fchol._xx[fi];
                    int[] nzi = nz[fi];
                    for (int j = 0; j <= fi; ++j) {
                        double[] rowj = fchol._xx[j];
                        int[] nzj = nz[j];
                        double s = 0.0;
                        int t = 0;
                        int z = 0;
                        while (t < nzi.length && z < nzj.length) {
                            int k1 = nzi[t];
                            int k2 = nzj[z];
                            if (k1 < k2) {
                                ++t;
                                continue;
                            }
                            if (k1 > k2) {
                                ++z;
                                continue;
                            }
                            s += rowi[k1] * rowj[k1];
                            ++t;
                            ++z;
                        }
                        rowi[j + sparseN] = Gram.this._xx[fi][j + sparseN] - s;
                    }
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])fjts);
        Object arr = new double[denseN][];
        for (int i4 = 0; i4 < ((double[][])arr).length; ++i4) {
            arr[i4] = Arrays.copyOfRange(fchol._xx[i4], sparseN, sparseN + denseN);
        }
        int p = H2ORuntime.availableProcessors();
        InPlaceCholesky d = InPlaceCholesky.decompose_2(arr, 10, p);
        fchol.setSPD(d.isSPD());
        arr = d.getL();
        for (int i5 = 0; i5 < ((double[][])arr).length; ++i5) {
            for (int j = 0; j < i5 + 1; ++j) {
                fchol._xx[i5][sparseN + j] = arr[i5][j];
            }
        }
        return chol;
    }

    public double[][] getXX() {
        return this.getXX(false, false);
    }

    public double[][] getXX(boolean lowerDiag, boolean icptFist) {
        if (this._xxCache != null && this._xxCache.match(lowerDiag, icptFist)) {
            return this._xxCache.xx;
        }
        int N = this._fullN;
        double[][] xx = new double[N][];
        for (int i = 0; i < N; ++i) {
            xx[i] = MemoryManager.malloc8d((int)(lowerDiag ? i + 1 : N));
        }
        return this.getXX(xx, lowerDiag, icptFist);
    }

    public double[][] getXX(double[][] xalloc) {
        return this.getXX(xalloc, false, false);
    }

    public double[][] getXX(double[][] xalloc, boolean lowerDiag, boolean icptFist) {
        int i;
        int N = this._fullN;
        double[][] xx = xalloc;
        int off = 0;
        if (this._hasIntercept && icptFist) {
            double[] icptRow = this._xx[this._xx.length - 1];
            xx[0][0] = icptRow[icptRow.length - 1];
            for (int i2 = 0; i2 < icptRow.length - 1; ++i2) {
                xx[i2 + 1][0] = icptRow[i2];
            }
            off = 1;
        }
        for (i = 0; i < this._diag.length; ++i) {
            xx[i + off][i + off] = this._diag[i];
            if (lowerDiag) continue;
            int col = i + off;
            double[] xrow = xx[i + off];
            for (int j = off; j < this._xx.length; ++j) {
                xrow[j + this._diagN] = this._xx[j][col];
            }
        }
        for (i = 0; i < this._xx.length - off; ++i) {
            double[] xrow = xx[i + this._diag.length + off];
            double[] xrowOld = this._xx[i];
            System.arraycopy(xrowOld, 0, xrow, off, xrowOld.length);
            if (lowerDiag) continue;
            int col = xrowOld.length - 1;
            int row = i + 1;
            for (int j = col + 1; j < xrow.length; ++j) {
                xrow[j] = this._xx[row++][col];
            }
        }
        this._xxCache = new XXCache(xx, lowerDiag, icptFist);
        return xx;
    }

    public double[][] getXXCPM(double[][] xalloc, boolean lowerDiag, boolean icptFirst) {
        int i;
        double[][] xx = xalloc;
        int off = 0;
        if (this._hasIntercept && icptFirst) {
            double[] icptRow = this._xx[this._xx.length - 1];
            xx[0][0] = icptRow[icptRow.length - 1];
            for (int i2 = 0; i2 < icptRow.length - 1; ++i2) {
                xx[i2 + 1][0] = icptRow[i2];
            }
            off = 1;
        }
        for (i = 0; i < this._diag.length; ++i) {
            xx[i + off][i + off] = this._diag[i];
            if (lowerDiag) continue;
            int col = i + off;
            double[] xrow = xx[i + off];
            for (int j = off; j < this._xx.length; ++j) {
                xrow[j + this._diagN] = this._xx[j][col];
            }
        }
        for (i = 0; i < this._xx.length - off; ++i) {
            double[] xrow = xx[i + this._diag.length + off];
            double[] xrowOld = this._xx[i];
            System.arraycopy(xrowOld, 0, xrow, off, xrowOld.length);
            if (lowerDiag) continue;
            int col = xrowOld.length - 1;
            int row = i + 1;
            int xrowLen = xrow.length - 1;
            for (int j = col + 1; j < xrowLen; ++j) {
                xrow[j] = this._xx[row++][col];
            }
        }
        return xx;
    }

    public void add(Gram grm) {
        ArrayUtils.add((double[][])this._xx, (double[][])grm._xx);
        ArrayUtils.add((double[])this._diag, (double[])grm._diag);
    }

    public final boolean hasNaNsOrInfs() {
        for (int i = 0; i < this._xx.length; ++i) {
            for (int j = 0; j < this._xx[i].length; ++j) {
                if (!Double.isInfinite(this._xx[i][j]) && !Double.isNaN(this._xx[i][j])) continue;
                return true;
            }
        }
        for (double d : this._diag) {
            if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
            return true;
        }
        return false;
    }

    public final void addRowSparse(DataInfo.Row r, double w) {
        int i;
        double[] mrow;
        int intercept = this._hasIntercept ? 1 : 0;
        int denseRowStart = this._fullN - this._denseN - this._diagN - intercept;
        assert (this._denseN + denseRowStart == this._xx.length - intercept);
        double[] interceptRow = this._hasIntercept ? this._xx[this._xx.length - 1] : null;
        for (int i2 = 0; i2 < r.nNums; ++i2) {
            int j;
            int cid = r.numIds[i2];
            mrow = this._xx[cid - this._diagN];
            double d = w * r.numVals[i2];
            for (j = 0; j <= i2; ++j) {
                int n = r.numIds[j];
                mrow[n] = mrow[n] + d * r.numVals[j];
            }
            if (this._hasIntercept) {
                int n = cid;
                interceptRow[n] = interceptRow[n] + d;
            }
            for (j = 0; j < r.nBins; ++j) {
                int n = r.binIds[j];
                mrow[n] = mrow[n] + d;
            }
        }
        if (this._hasIntercept) {
            int n = interceptRow.length - 1;
            interceptRow[n] = interceptRow[n] + w;
            for (int j = 0; j < r.nBins; ++j) {
                int n2 = r.binIds[j];
                interceptRow[n2] = interceptRow[n2] + w;
            }
        }
        boolean hasDiag = this._diagN > 0 && r.nBins > 0 && r.binIds[0] < this._diagN;
        int n = i = hasDiag ? 1 : 0;
        while (i < r.nBins) {
            mrow = this._xx[r.binIds[i] - this._diagN];
            for (int j = 0; j <= i; ++j) {
                int n3 = r.binIds[j];
                mrow[n3] = mrow[n3] + w;
            }
            ++i;
        }
        if (hasDiag && r.nBins > 0) {
            int n4 = r.binIds[0];
            this._diag[n4] = this._diag[n4] + w;
        }
    }

    public final void addRow(DataInfo.Row row, double w) {
        if (row.numIds == null) {
            this.addRowDense(row, w);
        } else {
            this.addRowSparse(row, w);
        }
    }

    public final void addRowDense(DataInfo.Row row, double w) {
        int i;
        int intercept = this._hasIntercept ? 1 : 0;
        int denseRowStart = this._fullN - this._denseN - this._diagN - intercept;
        int denseColStart = this._fullN - this._denseN - intercept;
        assert (this._denseN + denseRowStart == this._xx.length - intercept);
        double[] interceptRow = this._hasIntercept ? this._xx[this._denseN + denseRowStart] : null;
        for (int i2 = 0; i2 < this._denseN; ++i2) {
            int j;
            if (row.numVals[i2] == 0.0) continue;
            double[] mrow = this._xx[i2 + denseRowStart];
            double d = w * row.numVals[i2];
            for (j = 0; j <= i2; ++j) {
                if (row.numVals[j] == 0.0) continue;
                int n = j + denseColStart;
                mrow[n] = mrow[n] + d * row.numVals[j];
            }
            if (this._hasIntercept) {
                int n = i2 + denseColStart;
                interceptRow[n] = interceptRow[n] + d;
            }
            for (j = 0; j < row.nBins; ++j) {
                int n = row.binIds[j];
                mrow[n] = mrow[n] + d;
            }
        }
        if (this._hasIntercept) {
            int n = this._denseN + denseColStart;
            interceptRow[n] = interceptRow[n] + w;
            for (int j = 0; j < row.nBins; ++j) {
                int n2 = row.binIds[j];
                interceptRow[n2] = interceptRow[n2] + w;
            }
        }
        boolean hasDiag = this._diagN > 0 && row.nBins > 0 && row.binIds[0] < this._diagN;
        int n = i = hasDiag ? 1 : 0;
        while (i < row.nBins) {
            double[] mrow = this._xx[row.binIds[i] - this._diagN];
            for (int j = 0; j <= i; ++j) {
                int n3 = row.binIds[j];
                mrow[n3] = mrow[n3] + w;
            }
            ++i;
        }
        if (hasDiag) {
            int n4 = row.binIds[0];
            this._diag[n4] = this._diag[n4] + w;
        }
    }

    public void mul(double x) {
        int i;
        if (this._diag != null) {
            i = 0;
            while (i < this._diag.length) {
                int n = i++;
                this._diag[n] = this._diag[n] * x;
            }
        }
        for (i = 0; i < this._xx.length; ++i) {
            int j = 0;
            while (j < this._xx[i].length) {
                double[] dArray = this._xx[i];
                int n = j++;
                dArray[n] = dArray[n] * x;
            }
        }
    }

    public double[] mul(double[] x) {
        double[] res = MemoryManager.malloc8d((int)x.length);
        this.mul(x, res);
        return res;
    }

    public void mul(double[] x, double[] res) {
        int colSize = this.fullN();
        int offsetForCat = colSize - this._xx.length;
        for (int rowIndex = 0; rowIndex < colSize; ++rowIndex) {
            int colIndex;
            double d = 0.0;
            if (rowIndex >= offsetForCat) {
                for (colIndex = 0; colIndex < rowIndex; ++colIndex) {
                    d += this._xx[rowIndex - offsetForCat][colIndex] * x[colIndex];
                }
            }
            d += rowIndex >= offsetForCat ? this._xx[rowIndex - offsetForCat][rowIndex] * x[rowIndex] : this._diag[rowIndex] * x[rowIndex];
            for (colIndex = rowIndex + 1; colIndex < colSize; ++colIndex) {
                if (rowIndex < offsetForCat) {
                    if (colIndex < offsetForCat) continue;
                    d += this._xx[colIndex - offsetForCat][rowIndex] * x[colIndex];
                    continue;
                }
                d += this._xx[colIndex - offsetForCat][rowIndex] * x[colIndex];
            }
            res[rowIndex] = d;
        }
    }

    public static class CollinearColumnsException
    extends RuntimeException {
        public CollinearColumnsException() {
        }

        public CollinearColumnsException(String msg) {
            super(msg);
        }
    }

    public static class NonSPDMatrixException
    extends RuntimeException {
        public NonSPDMatrixException() {
        }

        public NonSPDMatrixException(String msg) {
            super(msg);
        }
    }

    public static class GramTask
    extends FrameTask2<GramTask> {
        private boolean _std = true;
        public Gram _gram;
        public long _nobs;
        boolean _intercept = false;
        double _prev = 0.0;

        public GramTask(Key<Job> jobKey, DataInfo dinfo) {
            super(null, dinfo, jobKey);
        }

        public GramTask(Key<Job> jobKey, DataInfo dinfo, boolean std, boolean intercept) {
            super(null, dinfo, jobKey);
            this._std = std;
            this._intercept = intercept;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, this._intercept);
        }

        @Override
        protected void processRow(DataInfo.Row r) {
            this._gram.addRow(r, r.weight);
            ++this._nobs;
            double current = this._gram.get(this._dinfo.fullN() - 1, this._dinfo.fullN() - 1) - this._prev;
            this._prev += current;
        }

        @Override
        public void chunkDone() {
            if (this._std && this._nobs > 0L) {
                double r = 1.0 / (double)this._nobs;
                this._gram.mul(r);
            }
        }

        public void reduce(GramTask gt) {
            if (this._std && this._nobs > 0L && gt._nobs > 0L) {
                double r1 = (double)this._nobs / (double)(this._nobs + gt._nobs);
                this._gram.mul(r1);
                double r2 = (double)gt._nobs / (double)(this._nobs + gt._nobs);
                gt._gram.mul(r2);
            }
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    public static class OuterGramTask
    extends MRTask<OuterGramTask> {
        public Gram _gram;
        public long _nobs;
        boolean _intercept = false;
        int[] _catOffsets;
        double _scale;
        final Key<Job> _jobKey;
        protected final DataInfo _dinfo;

        public OuterGramTask(Key<Job> jobKey, DataInfo dinfo) {
            this._dinfo = dinfo;
            this._jobKey = jobKey;
            this._catOffsets = dinfo._catOffsets != null ? Arrays.copyOf(dinfo._catOffsets, dinfo._catOffsets.length) : null;
            this._scale = dinfo._adaptedFrame.numRows() > 0L ? 1.0 / (double)dinfo._adaptedFrame.numRows() : 0.0;
        }

        public void map(Chunk[] chks) {
            this.chunkInit();
            DataInfo.Row rowi = this._dinfo.newDenseRow();
            DataInfo.Row rowj = this._dinfo.newDenseRow();
            Chunk[] chks2 = new Chunk[chks.length];
            this.innerProductChunk(rowi, rowj, chks, chks);
            for (int chkIndex = 0; chkIndex < chks[0].cidx(); ++chkIndex) {
                for (int colIndex = 0; colIndex < chks2.length; ++colIndex) {
                    chks2[colIndex] = this._fr.vec(colIndex).chunkForChunkIdx(chkIndex);
                }
                this.innerProductChunk(rowi, rowj, chks, chks2);
            }
            this.chunkDone();
        }

        public void innerProductChunk(DataInfo.Row rowi, DataInfo.Row rowj, Chunk[] localChunk, Chunk[] alterChunk) {
            int rowOffsetLocal = (int)localChunk[0].start();
            int rowOffsetAlter = (int)alterChunk[0].start();
            int localChkRows = localChunk[0]._len;
            int alterChkRows = alterChunk[0]._len;
            for (int rowL = 0; rowL < localChkRows; ++rowL) {
                int rowJOffset;
                this._dinfo.extractDenseRow(localChunk, rowL, rowi);
                if (rowi.isBad()) continue;
                ++this._nobs;
                int rowIOffset = rowL + rowOffsetLocal;
                for (int j = 0; j < alterChkRows && (rowJOffset = j + rowOffsetAlter) <= rowIOffset; ++j) {
                    this._dinfo.extractDenseRow(alterChunk, j, rowj);
                    if (rowi.isBad() || rowi.weight == 0.0 || rowj.isBad() || rowj.weight == 0.0) continue;
                    this._gram._xx[rowIOffset][rowJOffset] = rowi.dotSame(rowj);
                }
            }
        }

        public void chunkInit() {
            this._gram = new Gram((int)this._dinfo._adaptedFrame.numRows(), 0, this._dinfo.numNums(), this._dinfo._cats, this._intercept);
        }

        public void chunkDone() {
            this._gram.mul(this._scale);
        }

        public void reduce(OuterGramTask gt) {
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    public static final class Cholesky {
        public final double[][] _xx;
        protected final double[] _diag;
        private boolean _isSPD;
        private boolean _icptFirst;

        public Cholesky(double[][] xx, double[] diag) {
            this._xx = xx;
            this._diag = diag;
            this._icptFirst = false;
        }

        public Cholesky(double[][] xx, double[] diag, boolean icptFirst) {
            this._xx = xx;
            this._diag = diag;
            this._icptFirst = icptFirst;
            this._isSPD = true;
        }

        public void solve(final double[][] ys) {
            RecursiveAction[] ras = new RecursiveAction[ys.length];
            for (int i = 0; i < ras.length; ++i) {
                final int fi = i;
                ras[i] = new RecursiveAction(){

                    protected void compute() {
                        ys[fi][fi] = 1.0;
                        this.solve(ys[fi]);
                    }
                };
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])ras);
        }

        public double[][] getInv() {
            double[][] res = new double[this._xx[this._xx.length - 1].length][this._xx[this._xx.length - 1].length];
            for (int i = 0; i < res.length; ++i) {
                res[i][i] = 1.0;
            }
            this.solve(res);
            return res;
        }

        public double[] getInvDiag() {
            final double[] res = new double[this._xx.length + this._diag.length];
            RecursiveAction[] ras = new RecursiveAction[res.length];
            for (int i = 0; i < ras.length; ++i) {
                final int fi = i;
                ras[i] = new RecursiveAction(){

                    protected void compute() {
                        double[] tmp = new double[res.length];
                        tmp[fi] = 1.0;
                        this.solve(tmp);
                        res[fi] = tmp[fi];
                    }
                };
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])ras);
            return res;
        }

        public double[][] getL() {
            int i;
            int N = this._xx.length + this._diag.length;
            double[][] xx = new double[N][];
            for (i = 0; i < N; ++i) {
                xx[i] = MemoryManager.malloc8d((int)N);
            }
            for (i = 0; i < this._diag.length; ++i) {
                xx[i][i] = this._diag[i];
            }
            for (i = 0; i < this._xx.length; ++i) {
                for (int j = 0; j < this._xx[i].length; ++j) {
                    xx[i + this._diag.length][j] = this._xx[i][j];
                }
            }
            return xx;
        }

        public final void solve(double[] y) {
            int k;
            int i;
            if (!this.isSPD()) {
                throw new NonSPDMatrixException();
            }
            if (this._icptFirst) {
                double icpt = y[y.length - 1];
                for (i = y.length - 1; i > 0; --i) {
                    y[i] = y[i - 1];
                }
                y[0] = icpt;
            }
            for (int k2 = 0; k2 < this._diag.length; ++k2) {
                int n = k2;
                y[n] = y[n] / this._diag[k2];
            }
            int n = this._xx.length == 0 ? 0 : this._xx[this._xx.length - 1].length;
            for (k = this._diag.length; k < n; ++k) {
                double d = 0.0;
                for (int i2 = 0; i2 < k; ++i2) {
                    d += y[i2] * this._xx[k - this._diag.length][i2];
                }
                y[k] = (y[k] - d) / this._xx[k - this._diag.length][k];
            }
            for (k = n - 1; k >= this._diag.length; --k) {
                int n2 = k;
                y[n2] = y[n2] / this._xx[k - this._diag.length][k];
                for (i = 0; i < k; ++i) {
                    int n3 = i;
                    y[n3] = y[n3] - y[k] * this._xx[k - this._diag.length][i];
                }
            }
            for (k = this._diag.length - 1; k >= 0; --k) {
                int n4 = k;
                y[n4] = y[n4] / this._diag[k];
            }
            if (this._icptFirst) {
                double icpt = y[0];
                for (int i3 = 1; i3 < y.length; ++i3) {
                    y[i3 - 1] = y[i3];
                }
                y[y.length - 1] = icpt;
            }
        }

        public final boolean isSPD() {
            return this._isSPD;
        }

        public final void setSPD(boolean b) {
            this._isSPD = b;
        }
    }

    public static class InPlaceCholesky {
        final double[][] _xx;
        private boolean _isSPD;

        private InPlaceCholesky(double[][] xx, boolean isspd) {
            this._xx = xx;
            this._isSPD = isspd;
        }

        public static InPlaceCholesky decompose_2(double[][] xx, int STEP, int P) {
            boolean isspd = true;
            int N = xx.length;
            P = Math.max(1, P);
            for (int j = 0; j < N; j += STEP) {
                int p;
                int i;
                int tjR = Math.min(j + STEP, N);
                for (i = j; i < tjR; ++i) {
                    double[] rowi = xx[i];
                    double d = 0.0;
                    for (int k = j; k < i; ++k) {
                        double[] rowk = xx[k];
                        double s = 0.0;
                        for (int jj = 0; jj < k; ++jj) {
                            s += rowk[jj] * rowi[jj];
                        }
                        rowi[k] = s = (rowi[k] - s) / rowk[k];
                        d += s * s;
                    }
                    for (int jj = 0; jj < j; ++jj) {
                        double s = rowi[jj];
                        d += s * s;
                    }
                    d = rowi[i] - d;
                    isspd = isspd && d > 0.0;
                    rowi[i] = Math.sqrt(Math.max(0.0, d));
                }
                if (tjR == N) break;
                i = tjR;
                Futures fs = new Futures();
                int rpb = 0;
                for (p = P; tjR * (rpb = (N - tjR) / p) < 10000 && p > 1; --p) {
                }
                while (p-- > 1) {
                    fs.add((Future)new BlockTask(xx, i, i + rpb, j, tjR).fork());
                    i += rpb;
                }
                new BlockTask(xx, i, N, j, tjR).compute();
                fs.blockForPending();
            }
            return new InPlaceCholesky(xx, isspd);
        }

        public double[][] getL() {
            return this._xx;
        }

        public boolean isSPD() {
            return this._isSPD;
        }

        private static class BlockTask
        extends RecursiveAction {
            final double[][] _xx;
            final int _i0;
            final int _i1;
            final int _j0;
            final int _j1;

            public BlockTask(double[][] xx, int ifr, int ito, int jfr, int jto) {
                this._xx = xx;
                this._i0 = ifr;
                this._i1 = ito;
                this._j0 = jfr;
                this._j1 = jto;
            }

            public void compute() {
                for (int i = this._i0; i < this._i1; ++i) {
                    double[] rowi = this._xx[i];
                    for (int k = this._j0; k < this._j1; ++k) {
                        double[] rowk = this._xx[k];
                        double s = 0.0;
                        for (int jj = 0; jj < k; ++jj) {
                            s += rowk[jj] * rowi[jj];
                        }
                        rowi[k] = (rowi[k] - s) / rowk[k];
                    }
                }
            }
        }
    }

    private static class XXCache {
        public final boolean lowerDiag;
        public final boolean icptFirst;
        public final double[][] xx;

        public XXCache(double[][] xx, boolean lowerDiag, boolean icptFirst) {
            this.xx = xx;
            this.lowerDiag = lowerDiag;
            this.icptFirst = icptFirst;
        }

        public boolean match(boolean lowerDiag, boolean icptFirst) {
            return this.lowerDiag == lowerDiag && this.icptFirst == icptFirst;
        }
    }
}

