/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm;

import hex.AUC2;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsSupervised;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class MetricBuilderPSVM<T extends MetricBuilderPSVM<T>>
extends ModelMetricsSupervised.MetricBuilderSupervised<T> {
    protected AUC2.AUCBuilder _auc = new AUC2.AUCBuilder(400);

    public MetricBuilderPSVM(String[] domain) {
        super(2, domain);
    }

    public double[] perRow(double[] ds, float[] yact, Model m) {
        return this.perRow(ds, yact, 1.0, 0.0, m);
    }

    public double[] perRow(double[] ds, float[] yact, double w, double o, Model m) {
        if (Float.isNaN(yact[0])) {
            return ds;
        }
        if (ArrayUtils.hasNaNs((double[])ds)) {
            return ds;
        }
        if (w == 0.0 || Double.isNaN(w)) {
            return ds;
        }
        int iact = (int)yact[0];
        if (iact != 0 && iact != 1) {
            return ds;
        }
        this._wY += w * (double)iact;
        this._wYY += w * (double)iact * (double)iact;
        double err = iact + 1 < ds.length ? 1.0 - ds[iact + 1] : 1.0;
        this._sumsqe += w * err * err;
        ++this._count;
        this._wcount += w;
        assert (!Double.isNaN(this._sumsqe));
        this._auc.perRow(ds[2], iact, w);
        return ds;
    }

    public void reduce(T mb) {
        super.reduce(mb);
        this._auc.reduce(((MetricBuilderPSVM)((Object)mb))._auc);
    }

    public ModelMetrics makeModelMetrics(Model m, Frame f, Frame frameWithWeights, Frame preds) {
        AUC2 auc;
        double mse = Double.NaN;
        double sigma = Double.NaN;
        if (this._wcount > 0.0) {
            sigma = this.weightedSigma();
            mse = this._sumsqe / this._wcount;
            auc = AUC2.make01AUC((AUC2.AUCBuilder)this._auc);
        } else {
            auc = AUC2.emptyAUC();
        }
        ModelMetricsBinomial mm = new ModelMetricsBinomial(m, f, this._count, mse, this._domain, sigma, auc, Double.NaN, null, this._customMetric);
        if (m != null) {
            m.addModelMetrics((ModelMetrics)mm);
        }
        return mm;
    }

    public String toString() {
        if (this._wcount == 0.0) {
            return "empty, no rows";
        }
        return "mse = " + MathUtils.roundToNDigits((double)(this._sumsqe / this._wcount), (int)3);
    }
}

