/*
 * Decompiled with CFR 0.152.
 */
package hex.splitframe;

import java.util.Random;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.MathUtils;

public class ShuffleSplitFrame {
    public static Frame[] shuffleSplitFrame(Frame fr, Key<Frame>[] keys, final double[] ratios, final long seed) {
        assert (keys.length == ratios.length);
        double sum = ratios[0];
        for (int i = 1; i < ratios.length; ++i) {
            ratios[i] = sum += ratios[i];
        }
        assert (MathUtils.equalsWithinOneSmallUlp((double)sum, (double)1.0));
        byte[] types = fr.types();
        final int ncols = fr.numCols();
        byte[] alltypes = new byte[ncols * ratios.length];
        for (int i = 0; i < ratios.length; ++i) {
            System.arraycopy(types, 0, alltypes, i * ncols, ncols);
        }
        MRTask mr = new MRTask(){

            public void map(Chunk[] cs, NewChunk[] ncs) {
                Random rng = new Random(seed * (long)cs[0].cidx());
                int nrows = cs[0]._len;
                for (int i = 0; i < nrows; ++i) {
                    int x;
                    double r = rng.nextDouble();
                    for (x = 0; x < ratios.length - 1 && !(r < ratios[x]); ++x) {
                    }
                    x *= ncols;
                    block8: for (int j = 0; j < ncols; ++j) {
                        byte colType = cs[j].vec().get_type();
                        switch (colType) {
                            case 0: {
                                continue block8;
                            }
                            case 2: {
                                ncs[x + j].addStr(cs[j], i);
                                continue block8;
                            }
                            case 1: {
                                ncs[x + j].addUUID(cs[j], i);
                                continue block8;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                ncs[x + j].addNum(cs[j].atd(i));
                                continue block8;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported vector type: " + colType);
                            }
                        }
                    }
                }
            }
        }.doAll(alltypes, fr);
        Frame[] frames = new Frame[ratios.length];
        Vec[] vecs = fr.vecs();
        String[] names = fr.names();
        Futures fs = new Futures();
        for (int i = 0; i < ratios.length; ++i) {
            Vec[] nvecs = new Vec[ncols];
            int rowLayout = mr.appendables()[i * ncols].compute_rowLayout();
            for (int c = 0; c < ncols; ++c) {
                AppendableVec av = mr.appendables()[i * ncols + c];
                av.setDomain(vecs[c].domain());
                nvecs[c] = av.close(rowLayout, fs);
            }
            frames[i] = new Frame(keys[i], fr.names(), nvecs);
            DKV.put((Keyed)frames[i], (Futures)fs);
        }
        fs.blockForPending();
        return frames;
    }
}

