/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.IcedDouble;
import water.util.IcedHashSet;

public class ExactSplitPoints
extends MRTask<ExactSplitPoints> {
    private final int _maxCardinality;
    private final IcedHashSet<IcedDouble>[] _values;

    static double[][] splitPoints(Frame trainFr, int maxCardinality) {
        Frame fr = new Frame(new Vec[0]);
        int[] frToTrain = new int[trainFr.numCols()];
        for (int i = 0; i < trainFr.numCols(); ++i) {
            if (!trainFr.vec(i).isNumeric() || trainFr.vec(i).isCategorical() || trainFr.vec(i).isBinary() || trainFr.vec(i).isConst()) continue;
            frToTrain[fr.numCols()] = i;
            fr.add(trainFr.name(i), trainFr.vec(i));
        }
        IcedHashSet<IcedDouble>[] values = ((ExactSplitPoints)new ExactSplitPoints((int)maxCardinality, (int)fr.numCols()).doAll((Frame)fr))._values;
        double[][] splitPoints = new double[trainFr.numCols()][];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            double[] vals = new double[values[i].size()];
            int valsSize = 0;
            for (IcedDouble wrapper : values[i]) {
                vals[valsSize++] = wrapper._val;
            }
            assert (valsSize == vals.length);
            Arrays.sort(vals);
            assert (ExactSplitPoints.isUniqueSequence(vals));
            splitPoints[frToTrain[i]] = vals;
        }
        return splitPoints;
    }

    static boolean isUniqueSequence(double[] seq) {
        if (seq.length == 1) {
            return true;
        }
        double lastValue = seq[0];
        for (int i = 1; i < seq.length; ++i) {
            if (lastValue >= seq[i]) {
                return false;
            }
            lastValue = seq[i];
        }
        return true;
    }

    private ExactSplitPoints(int maxCardinality, int nCols) {
        this._maxCardinality = maxCardinality;
        this._values = new IcedHashSet[nCols];
        for (int i = 0; i < this._values.length; ++i) {
            this._values[i] = new IcedHashSet();
        }
    }

    public void map(Chunk[] cs) {
        HashSet<IcedDouble> localValues = new HashSet<IcedDouble>(this._maxCardinality);
        for (int col = 0; col < cs.length; ++col) {
            localValues.clear();
            if (this._values[col] == null) continue;
            Chunk c = cs[col];
            IcedDouble wrapper = new IcedDouble();
            for (int i = 0; i < c._len; ++i) {
                double num = c.atd(i);
                if (Double.isNaN(num) || wrapper._val == num) continue;
                wrapper.setVal(num);
                if (!localValues.add(wrapper)) continue;
                if (localValues.size() > this._maxCardinality) {
                    this._values[col] = null;
                    break;
                }
                wrapper = new IcedDouble();
            }
            this.merge(col, localValues);
        }
    }

    private void merge(int col, Collection<IcedDouble> localValues) {
        IcedHashSet<IcedDouble> allValues = this._values[col];
        if (allValues == null) {
            return;
        }
        allValues.addAll(localValues);
        if (allValues.size() > this._maxCardinality) {
            this._values[col] = null;
        }
    }

    public void reduce(ExactSplitPoints mrt) {
        if (mrt._values != this._values) {
            for (int col = 0; col < this._values.length; ++col) {
                if (this._values[col] == null || mrt._values[col] == null) {
                    this._values[col] = null;
                    continue;
                }
                this.merge(col, (Collection<IcedDouble>)mrt._values[col]);
            }
        }
    }

    protected void postGlobal() {
        for (int col = 0; col < this._values.length; ++col) {
            if (this._values[col] == null || this._values[col].size() <= this._maxCardinality) continue;
            this._values[col] = null;
        }
    }
}

