/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.DistributionFactory;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.ToEigenVec;
import hex.VarImp;
import hex.genmodel.GenModel;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.CalibrationHelper;
import hex.tree.CompressedForest;
import hex.tree.CompressedTree;
import hex.tree.Constraints;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.ExactSplitPoints;
import hex.tree.GlobalInteractionConstraints;
import hex.tree.GlobalQuantilesCalc;
import hex.tree.ReconstructTreeState;
import hex.tree.Score;
import hex.tree.ScoreBuildHistogram;
import hex.tree.ScoreBuildHistogram2;
import hex.tree.SharedTreeModel;
import hex.tree.TreeStats;
import hex.tree.gbm.GBMModel;
import hex.util.CheckpointUtils;
import hex.util.LinearAlgebraUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Consumer;
import jsr166y.CountedCompleter;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Value;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.MRUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.StringUtils;
import water.util.Timer;
import water.util.TwoDimTable;
import water.util.VecUtils;

public abstract class SharedTree<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends ModelBuilder<M, P, O>
implements CalibrationHelper.ModelBuilderWithCalibration<M, P, O> {
    private static final Logger LOG = Logger.getLogger(SharedTree.class);
    private static final boolean DEBUG_PUBDEV_6686 = Boolean.getBoolean("sys.ai.h2o.debug.pubdev6686");
    protected int _mtry;
    protected int _mtry_per_tree;
    protected GlobalInteractionConstraints _ics;
    public static final int MAX_NTREES = 100000;
    protected int _ntrees;
    protected M _model;
    protected int _ncols;
    protected double _initialPrediction;
    protected transient float[] _improvPerVar;
    protected Random _rand;
    private transient Frame _calib;
    protected transient Frame _validWorkspace;
    protected transient int _lastScoredTree = 0;
    protected transient Frame _trainPredsCache;
    protected transient Frame _validPredsCache;
    private transient SharedTreeDebugParams _debugParms;
    transient long _timeLastScoreStart;
    transient long _timeLastScoreEnd;
    transient long _firstScore;

    public boolean shouldReorder(Vec v) {
        return ((SharedTreeModel.SharedTreeParameters)this._parms)._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.SortByResponse && v.cardinality() > ((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_cats;
    }

    public SharedTree(P parms) {
        super(parms);
    }

    public SharedTree(P parms, Key<M> key) {
        super(parms, key);
    }

    public SharedTree(P parms, Job job) {
        super(parms, job);
    }

    public SharedTree(P parms, boolean startup_once) {
        super(parms, startup_once);
    }

    protected final Frame validWorkspace() {
        return this._validWorkspace;
    }

    public boolean isSupervised() {
        return true;
    }

    public boolean providesVarImp() {
        return this.isSupervised();
    }

    protected Score.ScoreExtension makeScoreExtension() {
        return null;
    }

    public boolean haveMojo() {
        return true;
    }

    public boolean havePojo() {
        if (this._parms == null) {
            return true;
        }
        return ((SharedTreeModel.SharedTreeParameters)this._parms)._offset_column == null;
    }

    public boolean scoreZeroTrees() {
        return true;
    }

    protected boolean computePriorClassDistribution() {
        return true;
    }

    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    protected void ignoreInvalidColumns(int npredictors, boolean expensive) {
        new ModelBuilder.FilterCols(npredictors){

            protected boolean filter(Vec v, String name) {
                return v.max() > 3.4028234663852886E38;
            }
        }.doIt(this._train, "Dropping columns with too large numeric values: ", expensive);
    }

    public void init(boolean expensive) {
        double sumWeights;
        Value cv;
        super.init(expensive);
        if (H2O.ARGS.client && ((SharedTreeModel.SharedTreeParameters)this._parms)._build_tree_one_node) {
            this.error("_build_tree_one_node", "Cannot run on a single node in client mode.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows < 0.0) {
            this.error("_min_rows", "Requested min_rows must be greater than 0");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.OneHotInternal) {
            this.error("_categorical_encoding", "Cannot use OneHotInternal categorical encoding for tree methods.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < 0 || ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees > 100000) {
            this.error("_ntrees", "Requested ntrees must be between 1 and 100000");
        }
        this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees;
        if (((SharedTreeModel.SharedTreeParameters)this._parms).hasCheckpoint() && (cv = DKV.get((Key)((SharedTreeModel.SharedTreeParameters)this._parms)._checkpoint)) != null) {
            SharedTreeModel checkpointModel = (SharedTreeModel)((Object)CheckpointUtils.getAndValidateCheckpointModel(this, SharedTreeModel.SharedTreeParameters.CHECKPOINT_NON_MODIFIABLE_FIELDS, cv));
            this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees - ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees;
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins <= 1) {
            this.error("_nbins", "nbins must be > 1.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins >= 65536) {
            this.error("_nbins", "nbins must be < 65536");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_cats <= 1) {
            this.error("_nbins_cats", "nbins_cats must be > 1.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_cats >= 65536) {
            this.error("_nbins_cats", "nbins_cats must be < 65536");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_top_level < ((SharedTreeModel.SharedTreeParameters)this._parms)._nbins) {
            this.error("_nbins_top_level", "nbins_top_level must be >= nbins (" + ((SharedTreeModel.SharedTreeParameters)this._parms)._nbins + ").");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins_top_level >= 65536) {
            this.error("_nbins_top_level", "nbins_top_level must be < 65536");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._max_depth < 0) {
            this.error("_max_depth", "_max_depth must be >= 0.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._max_depth == 0) {
            ((SharedTreeModel.SharedTreeParameters)this._parms)._max_depth = Integer.MAX_VALUE;
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows <= 0.0) {
            this.error("_min_rows", "_min_rows must be > 0.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._r2_stopping != Double.MAX_VALUE) {
            this.warn("_r2_stopping", "_r2_stopping is no longer supported - please use stopping_rounds, stopping_metric and stopping_tolerance instead.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval < 0) {
            this.error("_score_tree_interval", "_score_tree_interval must be >= 0.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._in_training_checkpoints_tree_interval <= 0) {
            this.error("_in_training_checkpoints_tree_interval", "_in_training_checkpoints_tree_interval must be > 0.");
        }
        this.validateRowSampleRate();
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_split_improvement < 0.0) {
            this.error("_min_split_improvement", "min_split_improvement must be >= 0, but is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._min_split_improvement + ".");
        }
        if (!(0.0 < ((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_per_tree) || !(((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_per_tree <= 1.0)) {
            this.error("_col_sample_rate_per_tree", "col_sample_rate_per_tree should be in interval [0,1] but it is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_per_tree + ".");
        }
        if (!(0.0 < ((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_change_per_level) || !(((SharedTreeModel.SharedTreeParameters)this._parms)._col_sample_rate_change_per_level <= 2.0)) {
            this.error("_col_sample_rate_change_per_level", "col_sample_rate_change_per_level must be > 0 and <= 2");
        }
        if (this._train != null && (sumWeights = (double)this._train.numRows() * (this._weights != null ? this._weights.mean() : 1.0)) < 2.0 * ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows) {
            this.error("_min_rows", "The dataset size is too small to split for min_rows=" + ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows + ": must have at least " + 2.0 * ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows + " (weighted) rows, but have only " + sumWeights + ".");
        }
        if (this._train != null) {
            this._ncols = this._train.numCols() - (this.isSupervised() ? 1 : 0) - this.numSpecialCols();
        }
        CalibrationHelper.initCalibration(this, (CalibrationHelper.ParamsWithCalibration)this._parms, expensive);
        this._orig_projection_array = LinearAlgebraUtils.toEigenProjectionArray(this._origTrain, this._train, expensive);
        ((SharedTreeModel.SharedTreeParameters)this._parms)._use_best_cv_iteration = this.isSupervised() && H2O.getSysBoolProperty((String)"sharedtree.crossvalidation.useBestCVIteration", (boolean)((SharedTreeModel.SharedTreeParameters)this._parms)._use_best_cv_iteration);
        ((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building = H2O.getSysBoolProperty((String)"sharedtree.crossvalidation.parallelMainModelBuilding", (boolean)((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building);
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._max_runtime_secs > 0.0 && ((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building) {
            ((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building = false;
            this.warn("_parallel_main_model_building", "Parallel main model will be disabled because max_runtime_secs is specified.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._use_best_cv_iteration && ((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building) {
            ((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building = false;
            this.warn("_parallel_main_model_building", "Parallel main model will be disabled because use_best_cv_iteration is specified.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._build_tree_one_node) {
            this.warn("_build_tree_one_node", "Single-node tree building is not supported in this version of H2O.");
        }
        if (!StringUtils.isNullOrEmpty((String)((SharedTreeModel.SharedTreeParameters)this._parms)._in_training_checkpoints_dir) && !H2O.getPM().isWritableDirectory(((SharedTreeModel.SharedTreeParameters)this._parms)._in_training_checkpoints_dir)) {
            this.error("_in_training_checkpoints_dir", "In training checkpoints directory path must point to a writable path.");
        }
    }

    protected void validateRowSampleRate() {
        if (!(0.0 < ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate) || !(((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate <= 1.0)) {
            this.error("_sample_rate", "sample_rate should be in interval ]0,1] but it is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate + ".");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class != null) {
            this.warn("_sample_rate", "_sample_rate is ignored if _sample_rate_per_class is specified.");
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class.length != this.nclasses()) {
                this.error("_sample_rate_per_class", "_sample_rate_per_class must have " + this.nclasses() + " values (one per class).");
            }
            for (int i = 0; i < ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class.length; ++i) {
                if (0.0 < ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class[i] && ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class[i] <= 1.0) continue;
                this.error("_sample_rate_per_class", "sample_rate_per_class for class " + this.response().domain()[i] + " should be in interval ]0,1] but it is " + ((SharedTreeModel.SharedTreeParameters)this._parms)._sample_rate_per_class[i] + ".");
            }
        }
    }

    protected void checkEarlyStoppingReproducibility() {
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval == 0 && !((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration) {
            this.warn("_stopping_rounds", "early stopping is enabled but neither score_tree_interval or score_each_iteration are defined. Early stopping will not be reproducible!");
        }
    }

    private void postProcessModel() {
        if (((SharedTreeModel.SharedTreeParameters)this._parms).calibrateModel() && !((SharedTreeModel.SharedTreeParameters)this._parms)._is_cv_model) {
            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).setCalibrationModel(CalibrationHelper.buildCalibrationModel(this, (CalibrationHelper.ParamsWithCalibration)this._parms, this._job, this._model));
            this._model.update(this._job);
        }
    }

    protected ScoreKeeper.ProblemType getProblemType() {
        assert (this.isSupervised());
        return ScoreKeeper.ProblemType.forSupervised((this._nclass > 1 ? 1 : 0) != 0);
    }

    protected DHistogram[][][] buildLayer(Frame fr, int nbins, DTree[] ktrees, int[] leafs, DHistogram[][][] hcs, boolean build_tree_one_node) {
        ScoreBuildOneTree[] sb1ts = new ScoreBuildOneTree[this._nclass];
        Vec[] vecs = fr.vecs();
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            String[] fr2cols = Arrays.copyOf(fr._names, this._ncols + 1);
            Vec[] fr2vecs = Arrays.copyOf(vecs, this._ncols + 1);
            if (DEBUG_PUBDEV_6686) {
                boolean hasNull = false;
                for (Vec v : fr2vecs) {
                    if (v != null) continue;
                    hasNull = true;
                    break;
                }
                if (hasNull) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < fr2vecs.length; ++i) {
                        sb.append(fr2cols[i]).append(":").append(fr2vecs[i] == null).append("; ");
                    }
                    LOG.warn((Object)("A null Vec found in `fr2=" + fr._key + "`: " + sb.toString()));
                    LOG.warn((Object)("Training frame: " + this._train._key + "; model: " + this._result));
                    LOG.warn((Object)("Params: " + ((SharedTreeModel.SharedTreeParameters)this._parms).toJsonString()));
                }
            }
            Frame fr2 = new Frame(fr2cols, fr2vecs);
            if (this.isSupervised() && fr2.find(((SharedTreeModel.SharedTreeParameters)this._parms)._response_column) == -1) {
                fr2.add(((SharedTreeModel.SharedTreeParameters)this._parms)._response_column, fr.vec(((SharedTreeModel.SharedTreeParameters)this._parms)._response_column));
            }
            int respIdx = fr2.find(((SharedTreeModel.SharedTreeParameters)this._parms)._response_column);
            int weightIdx = fr2.find(((SharedTreeModel.SharedTreeParameters)this._parms)._weights_column);
            int treatmentIdx = -1;
            int predsIdx = fr2.numCols();
            fr2.add(fr._names[this.idx_tree(k)], vecs[this.idx_tree(k)]);
            int workIdx = fr2.numCols();
            fr2.add(fr._names[this.idx_work(k)], vecs[this.idx_work(k)]);
            int nidIdx = fr2.numCols();
            fr2.add(fr._names[this.idx_nids(k)], vecs[this.idx_nids(k)]);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Building a layer for class " + k + ":\n" + fr2.toTwoDimTable()));
            }
            sb1ts[k] = new ScoreBuildOneTree(this, k, nbins, tree, leafs, hcs, fr2, build_tree_one_node, this._improvPerVar, ((SharedTreeModel.SharedTreeParameters)((SharedTreeModel)((Object)this._model))._parms)._distribution, respIdx, weightIdx, predsIdx, workIdx, nidIdx, treatmentIdx);
            H2O.submitTask((H2O.H2OCountedCompleter)sb1ts[k]);
        }
        boolean did_split = false;
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            sb1ts[k].join();
            if (sb1ts[k]._did_split) {
                did_split = true;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Done with this layer for class " + k + ":\n" + new Frame(new String[]{"TREE", "WORK", "NIDS"}, new Vec[]{vecs[this.idx_tree(k)], vecs[this.idx_work(k)], vecs[this.idx_nids(k)]}).toTwoDimTable()));
        }
        return did_split ? hcs : (DHistogram[][][])null;
    }

    protected int idx_weight() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).weightsIdx();
    }

    protected int idx_offset() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).offsetIdx();
    }

    protected int idx_resp() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).responseIdx();
    }

    protected int idx_tree(int c) {
        return this._ncols + (this.isSupervised() ? 1 : 0) + c + this.numSpecialCols();
    }

    protected int idx_work(int c) {
        return this.idx_tree(c) + this._nclass;
    }

    protected int idx_nids(int c) {
        return this.idx_work(c) + this._nclass;
    }

    protected int idx_oobt() {
        return this.idx_nids(0) + this._nclass;
    }

    protected int idx_treatment() {
        return ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).treatmentIdx();
    }

    public Chunk chk_weight(Chunk[] chks) {
        return chks[this.idx_weight()];
    }

    protected Chunk chk_offset(Chunk[] chks) {
        return chks[this.idx_offset()];
    }

    public Chunk chk_resp(Chunk[] chks) {
        return chks[this.idx_resp()];
    }

    public Chunk chk_tree(Chunk[] chks, int c) {
        return chks[this.idx_tree(c)];
    }

    protected Chunk chk_work(Chunk[] chks, int c) {
        return chks[this.idx_work(c)];
    }

    protected Chunk chk_nids(Chunk[] chks, int c) {
        return chks[this.idx_nids(c)];
    }

    protected Chunk chk_oobt(Chunk[] chks) {
        return chks[this.idx_oobt()];
    }

    protected final Vec vec_weight(Frame fr) {
        return fr.vecs()[this.idx_weight()];
    }

    protected final Vec vec_offset(Frame fr) {
        return fr.vecs()[this.idx_offset()];
    }

    protected final Vec vec_resp(Frame fr) {
        return fr.vecs()[this.idx_resp()];
    }

    protected final Vec vec_tree(Frame fr, int c) {
        return fr.vecs()[this.idx_tree(c)];
    }

    protected final Vec vec_work(Frame fr, int c) {
        return fr.vecs()[this.idx_work(c)];
    }

    protected final Vec vec_nids(Frame fr, int c) {
        return fr.vecs()[this.idx_nids(c)];
    }

    protected final Vec vec_oobt(Frame fr) {
        return fr.vecs()[this.idx_oobt()];
    }

    protected double[] data_row(Chunk[] chks, int row, double[] data) {
        assert (data.length == this._ncols);
        for (int f = 0; f < this._ncols; ++f) {
            data[f] = chks[f].atd(row);
        }
        return data;
    }

    protected DTree.DecidedNode makeDecided(DTree.UndecidedNode udn, DHistogram[] hs, Constraints cs) {
        return new DTree.DecidedNode(udn, hs, cs, this._ics);
    }

    protected abstract double score1(Chunk[] var1, double var2, double var4, double[] var6, int var7);

    void score2(Chunk[] chks, double weight, double offset, double[] fs, int row) {
        double sum = this.score1(chks, weight, offset, fs, row);
        if (this.isClassifier()) {
            if (!Double.isInfinite(sum) && sum > 0.0 && sum != 1.0) {
                ArrayUtils.div((double[])fs, (double)sum);
            }
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._balance_classes) {
                GenModel.correctProbabilities((double[])fs, (double[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._priorClassDist, (double[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._modelClassDist);
            }
        }
    }

    protected final boolean doScoringAndSaveModel(boolean finalScoring, boolean oob, boolean build_tree_one_node) {
        boolean manualInterval;
        long now = System.currentTimeMillis();
        if (this._firstScore == 0L) {
            this._firstScore = now;
        }
        long sinceLastScore = now - this._timeLastScoreStart;
        boolean updated = false;
        this._job.update(0L, this._desc + ": Built " + ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees + " trees so far (out of " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + ").");
        boolean timeToScore = now - this._firstScore < (long)((SharedTreeModel.SharedTreeParameters)this._parms)._initial_score_interval || sinceLastScore > (long)((SharedTreeModel.SharedTreeParameters)this._parms)._score_interval && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1;
        boolean bl = manualInterval = ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval > 0 && ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees % ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval == 0;
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration || finalScoring || timeToScore && ((SharedTreeModel.SharedTreeParameters)this._parms)._score_tree_interval == 0 || manualInterval) {
            ModelMetrics mm;
            this.checkMemoryFootPrint();
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
            }
            this._model.update(this._job);
            updated = true;
            LOG.info((Object)"============================================================== ");
            SharedTreeModel.SharedTreeOutput out = (SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output;
            this._timeLastScoreStart = now;
            boolean printout = ((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration || finalScoring || sinceLastScore > (long)((SharedTreeModel.SharedTreeParameters)this._parms)._score_interval;
            this._job.update(0L, "Scoring the model.");
            ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._job = this._job;
            Score sc = new Score(this, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees > 0, oob, this.response(), ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).getModelCategory(), true, this._trainPredsCache, CFuncRef.from((String)((SharedTreeModel.SharedTreeParameters)this._parms)._custom_metric_func));
            out._training_metrics = mm = sc.scoreAndMakeModelMetrics((SharedTreeModel)((Object)this._model), ((SharedTreeModel.SharedTreeParameters)this._parms).train(), this.train(), build_tree_one_node);
            if (oob) {
                out._training_metrics._description = "Metrics reported on Out-Of-Bag training samples";
            }
            out._scored_train[out._ntrees].fillFrom(mm);
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._valid != null) {
                Score.ScoreIncInfo sii;
                Frame v = new Frame(this.valid());
                if (this.validWorkspace() != null) {
                    v = v.add(this.validWorkspace());
                    sii = new Score.ScoreIncInfo(this._lastScoredTree, this.valid().numCols(), this.validWorkspace().numCols(), this._nclass > 1 ? 1 : 0);
                } else {
                    sii = null;
                }
                Score scv = new Score(this, sii, false, this.vresponse(), ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).getModelCategory(), true, this._validPredsCache, CFuncRef.from((String)((SharedTreeModel.SharedTreeParameters)this._parms)._custom_metric_func));
                ModelMetrics mmv = scv.scoreAndMakeModelMetrics((SharedTreeModel)((Object)this._model), ((SharedTreeModel.SharedTreeParameters)this._parms).valid(), v, build_tree_one_node);
                this._lastScoredTree = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees;
                out._validation_metrics = mmv;
                out._validation_metrics._description = "Validation metrics";
                if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees > 0 || this.scoreZeroTrees()) {
                    out._scored_valid[out._ntrees].fillFrom(mmv);
                }
            }
            out._model_summary = SharedTree.createModelSummaryTable(out._ntrees, out._treeStats);
            out._scoring_history = this.createScoringHistoryTable();
            if (out._ntrees > 0 && this.providesVarImp()) {
                out._varimp = new VarImp(this._improvPerVar, out._names);
                out._variable_importances = ModelMetrics.calcVarImp((VarImp)out._varimp);
            }
            this.addCustomInfo(out);
            if (printout) {
                LOG.info((Object)this._model.toString());
            }
            this._timeLastScoreEnd = System.currentTimeMillis();
        }
        if (updated) {
            this._model.update(this._job);
        }
        return updated;
    }

    @Override
    public ModelBuilder getModelBuilder() {
        return this;
    }

    @Override
    public final Frame getCalibrationFrame() {
        return this._calib;
    }

    @Override
    public void setCalibrationFrame(Frame f) {
        this._calib = f;
    }

    protected boolean canLearnFromNAs() {
        return true;
    }

    protected void addCustomInfo(O out) {
    }

    protected TwoDimTable createScoringHistoryTable() {
        SharedTreeModel.SharedTreeOutput out = (SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output;
        return SharedTree.createScoringHistoryTable(out, out._scored_train, out._scored_valid, this._job, out._training_time_ms, ((SharedTreeModel.SharedTreeParameters)this._parms)._custom_metric_func != null, ((SharedTreeModel.SharedTreeParameters)this._parms)._custom_distribution_func != null);
    }

    public static TwoDimTable createScoringHistoryTable(Model.Output _output, ScoreKeeper[] _scored_train, ScoreKeeper[] _scored_valid, Job job, long[] _training_time_ms, boolean hasCustomMetric, boolean hasCustomDistribution) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Training RMSE");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (_output.getModelCategory() == ModelCategory.Regression) {
            colHeaders.add("Training MAE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (!hasCustomDistribution) {
                colHeaders.add("Training Deviance");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        }
        if (_output.isClassifier()) {
            colHeaders.add("Training LogLoss");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output.getModelCategory() == ModelCategory.Binomial) {
            colHeaders.add("Training AUC");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Training pr_auc");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Training Lift");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output.isClassifier()) {
            colHeaders.add("Training Classification Error");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output.getModelCategory() == ModelCategory.Multinomial) {
            colHeaders.add("Training AUC");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Training pr_auc");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (hasCustomMetric) {
            colHeaders.add("Training Custom");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (_output._validation_metrics != null) {
            colHeaders.add("Validation RMSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (_output.getModelCategory() == ModelCategory.Regression) {
                colHeaders.add("Validation MAE");
                colTypes.add("double");
                colFormat.add("%.5f");
                if (!hasCustomDistribution) {
                    colHeaders.add("Validation Deviance");
                    colTypes.add("double");
                    colFormat.add("%.5f");
                }
            }
            if (_output.isClassifier()) {
                colHeaders.add("Validation LogLoss");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (_output.getModelCategory() == ModelCategory.Binomial) {
                colHeaders.add("Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
                colHeaders.add("Validation pr_auc");
                colTypes.add("double");
                colFormat.add("%.5f");
                colHeaders.add("Validation Lift");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (_output.isClassifier()) {
                colHeaders.add("Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (_output.getModelCategory() == ModelCategory.Multinomial) {
                colHeaders.add("Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
                colHeaders.add("Validation pr_auc");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (hasCustomMetric) {
                colHeaders.add("Validation Custom");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        }
        int rows = 0;
        for (int i = 0; i < _scored_train.length; ++i) {
            if (i != 0 && _scored_train[i].isEmpty() && (_scored_valid == null || _scored_valid[i].isEmpty())) continue;
            ++rows;
        }
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 0; i < _scored_train.length; ++i) {
            if (i != 0 && _scored_train[i].isEmpty() && (_scored_valid == null || _scored_valid[i].isEmpty())) continue;
            int col = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(_training_time_ms[i]));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)(_training_time_ms[i] - job.start_time()), (boolean)true));
            table.set(row, col++, (Object)i);
            ScoreKeeper st = _scored_train[i];
            table.set(row, col++, (Object)st._rmse);
            if (_output.getModelCategory() == ModelCategory.Regression) {
                table.set(row, col++, (Object)st._mae);
                if (!hasCustomDistribution) {
                    table.set(row, col++, (Object)st._mean_residual_deviance);
                }
            }
            if (_output.isClassifier()) {
                table.set(row, col++, (Object)st._logloss);
            }
            if (_output.getModelCategory() == ModelCategory.Binomial) {
                table.set(row, col++, (Object)st._AUC);
                table.set(row, col++, (Object)st._pr_auc);
                table.set(row, col++, (Object)st._lift);
            }
            if (_output.isClassifier()) {
                table.set(row, col++, (Object)st._classError);
            }
            if (_output.getModelCategory() == ModelCategory.Multinomial) {
                table.set(row, col++, (Object)st._AUC);
                table.set(row, col++, (Object)st._pr_auc);
            }
            if (hasCustomMetric) {
                table.set(row, col++, (Object)st._custom_metric);
            }
            if (_output._validation_metrics != null) {
                st = _scored_valid[i];
                table.set(row, col++, (Object)st._rmse);
                if (_output.getModelCategory() == ModelCategory.Regression) {
                    table.set(row, col++, (Object)st._mae);
                    if (!hasCustomDistribution) {
                        table.set(row, col++, (Object)st._mean_residual_deviance);
                    }
                }
                if (_output.isClassifier()) {
                    table.set(row, col++, (Object)st._logloss);
                }
                if (_output.getModelCategory() == ModelCategory.Binomial) {
                    table.set(row, col++, (Object)st._AUC);
                    table.set(row, col++, (Object)st._pr_auc);
                    table.set(row, col++, (Object)st._lift);
                }
                if (_output.isClassifier()) {
                    table.set(row, col++, (Object)st._classError);
                }
                if (_output.getModelCategory() == ModelCategory.Multinomial) {
                    table.set(row, col++, (Object)st._AUC);
                    table.set(row, col++, (Object)st._pr_auc);
                }
                if (hasCustomMetric) {
                    table.set(row, col++, (Object)st._custom_metric);
                }
            }
            ++row;
        }
        return table;
    }

    public static TwoDimTable createModelSummaryTable(int ntrees, TreeStats treeStats) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        if (treeStats != null) {
            colHeaders.add("Number of Internal Trees");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Model Size in Bytes");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Min. Depth");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Max. Depth");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Mean Depth");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Min. Leaves");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Max. Leaves");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Mean Leaves");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        boolean rows = true;
        TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        int col = 0;
        table.set(row, col++, (Object)ntrees);
        if (treeStats != null) {
            table.set(row, col++, (Object)treeStats._num_trees);
            table.set(row, col++, (Object)treeStats._byte_size);
            table.set(row, col++, (Object)treeStats._min_depth);
            table.set(row, col++, (Object)treeStats._max_depth);
            table.set(row, col++, (Object)Float.valueOf(treeStats._mean_depth));
            table.set(row, col++, (Object)treeStats._min_leaves);
            table.set(row, col++, (Object)treeStats._max_leaves);
            table.set(row, col++, (Object)Float.valueOf(treeStats._mean_leaves));
        }
        return table;
    }

    protected void checkMemoryFootPrint_impl() {
        long model_mem_size;
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees == 0) {
            return;
        }
        int trees_so_far = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees;
        ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeStats._byte_size = model_mem_size = ((ComputeModelSize)new ComputeModelSize((int)trees_so_far, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeKeys).doAllNodes())._model_mem_size;
        double avg_tree_mem_size = (double)model_mem_size / (double)trees_so_far;
        LOG.debug((Object)("Average tree size (for all classes): " + PrettyPrint.bytes((long)((long)avg_tree_mem_size))));
        long max_mem = H2O.SELF._heartbeat.get_free_mem();
        if ((double)((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees * avg_tree_mem_size > (double)max_mem) {
            String msg = "The tree model will not fit in the driver node's memory (" + PrettyPrint.bytes((long)((long)avg_tree_mem_size)) + " per tree x " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + " > " + PrettyPrint.bytes((long)max_mem) + ") - try decreasing ntrees and/or max_depth or increasing min_rows!";
            this.error("_ntrees", msg);
        }
    }

    protected double getInitialValue() {
        return ((InitialValue)new InitialValue(this._parms, this._nclass).doAll(new Vec[]{this._response, this.hasWeightCol() ? this._weights : this._response.makeCon(1.0), this.hasOffsetCol() ? this._offset : this._response.makeCon(0.0)})).initialValue();
    }

    protected boolean cv_canBuildMainModelInParallel() {
        assert (!((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building || ((SharedTreeModel.SharedTreeParameters)this._parms)._max_runtime_secs == 0.0) : "Parallel main model building shouldn't be be enabled when max_runtime_secs is specified.";
        return ((SharedTreeModel.SharedTreeParameters)this._parms)._parallel_main_model_building;
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder<M, P, O>[] cvModelBuilders) {
        if (!this.cv_initStoppingParameters()) {
            return;
        }
        ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees = this.computeOptimalNTrees(cvModelBuilders);
        this.warn("_ntrees", "Setting optimal _ntrees to " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + " for cross-validation main model based on early stopping of cross-validation models.");
        this.warn("_stopping_rounds", "Disabling convergence-based early stopping for cross-validation main model.");
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._main_model_time_budget_factor == 0.0) {
            this.warn("_max_runtime_secs", "Disabling maximum allowed runtime for cross-validation main model.");
        }
    }

    private int computeOptimalNTrees(ModelBuilder<M, P, O>[] cvModelBuilders) {
        int totalNTrees = 0;
        for (ModelBuilder<M, P, O> mb : cvModelBuilders) {
            SharedTreeModel model = (SharedTreeModel)DKV.getGet((Key)mb.dest());
            if (model == null) continue;
            totalNTrees += ((SharedTreeModel.SharedTreeOutput)model._output)._ntrees;
        }
        return (int)((double)totalNTrees / (double)cvModelBuilders.length);
    }

    protected final boolean cv_updateOptimalParameters(ModelBuilder<M, P, O>[] cvModelBuilders) {
        int ntreesOld = this._ntrees;
        ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees = this._ntrees = this.computeOptimalNTrees(cvModelBuilders);
        return this._ntrees > ntreesOld;
    }

    protected final boolean cv_initStoppingParameters() {
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._stopping_rounds == 0 && ((SharedTreeModel.SharedTreeParameters)this._parms)._max_runtime_secs == 0.0) {
            return false;
        }
        ((SharedTreeModel.SharedTreeParameters)this._parms)._stopping_rounds = 0;
        this.setMaxRuntimeSecsForMainModel();
        ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees = this._ntrees = 1;
        return true;
    }

    SharedTreeDebugParams getDebugParams() {
        if (this._debugParms == null) {
            this._debugParms = new SharedTreeDebugParams();
        }
        return this._debugParms;
    }

    public void setDebugParams(SharedTreeDebugParams debugParms) {
        this._debugParms = debugParms;
    }

    public static class SharedTreeDebugParams
    extends Iced<SharedTreeDebugParams> {
        static SharedTreeDebugParams DEFAULT = new SharedTreeDebugParams(false);
        public boolean _reproducible_histos;
        public boolean _keep_orig_histo_precision;
        public String _histo_monitor_class;

        public SharedTreeDebugParams(boolean initFromSysProps) {
            if (initFromSysProps) {
                this._reproducible_histos = H2O.getSysBoolProperty((String)"tree.SharedTree.reproducibleHistos", (boolean)SharedTreeDebugParams.DEFAULT._reproducible_histos);
                this._keep_orig_histo_precision = H2O.getSysBoolProperty((String)"tree.SharedTree.keepOrigHistoPrecision", (boolean)SharedTreeDebugParams.DEFAULT._keep_orig_histo_precision);
                this._histo_monitor_class = H2O.getSysProperty((String)"tree.SharedTree.histoMonitorClass", (String)SharedTreeDebugParams.DEFAULT._histo_monitor_class);
            }
        }

        public SharedTreeDebugParams() {
            this(true);
        }

        boolean isDefault() {
            return this.equals((Object)DEFAULT);
        }

        public Consumer<DHistogram[][]> makeDHistogramMonitor(int treeNum, int k, int leaf) {
            if (this._histo_monitor_class == null) {
                return null;
            }
            try {
                Class<?> histoMonitorClass = Class.forName(this._histo_monitor_class);
                Constructor<?> histoMonitorConstructor = histoMonitorClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                Object histoMonitor = histoMonitorConstructor.newInstance(treeNum, k, leaf);
                return (Consumer)histoMonitor;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed initialize Histogram Monitor Class: " + this._histo_monitor_class, e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SharedTreeDebugParams that = (SharedTreeDebugParams)((Object)o);
            if (this._reproducible_histos != that._reproducible_histos) {
                return false;
            }
            if (this._keep_orig_histo_precision != that._keep_orig_histo_precision) {
                return false;
            }
            return this._histo_monitor_class != null ? this._histo_monitor_class.equals(that._histo_monitor_class) : that._histo_monitor_class == null;
        }

        public int hashCode() {
            int result = this._reproducible_histos ? 1 : 0;
            result = 31 * result + (this._keep_orig_histo_precision ? 1 : 0);
            result = 31 * result + (this._histo_monitor_class != null ? this._histo_monitor_class.hashCode() : 0);
            return result;
        }
    }

    private static class InitialValue
    extends MRTask<InitialValue> {
        private Distribution _dist;
        private final int _nclass;
        private double _num;
        private double _denom;

        public InitialValue(Model.Parameters parms, int nclass) {
            this._nclass = nclass;
            this._dist = DistributionFactory.getDistribution((Model.Parameters)parms);
        }

        protected void setupLocal() {
            super.setupLocal();
            this._dist.reset();
        }

        public double initialValue() {
            if (this._dist._family == DistributionFamily.multinomial || this._dist._family == DistributionFamily.custom && this._nclass > 2) {
                return -0.5 * DistributionFactory.getDistribution((DistributionFamily)DistributionFamily.bernoulli).link(this._num / this._denom);
            }
            return this._dist.link(this._num / this._denom);
        }

        public void map(Chunk response, Chunk weight, Chunk offset) {
            for (int i = 0; i < response._len; ++i) {
                double w;
                if (response.isNA(i) || (w = weight.atd(i)) == 0.0) continue;
                double y = response.atd(i);
                double o = offset.atd(i);
                this._num += this._dist.initFNum(w, o, y);
                this._denom += this._dist.initFDenom(w, o, y);
            }
        }

        public void reduce(InitialValue mrt) {
            this._num += mrt._num;
            this._denom += mrt._denom;
        }
    }

    private static class ComputeModelSize
    extends MRTask<ComputeModelSize> {
        long _model_mem_size;
        final int trees_so_far;
        public final Key<CompressedTree>[][] _treeKeys;

        public ComputeModelSize(int trees_so_far, Key<CompressedTree>[][] _treeKeys) {
            this.trees_so_far = trees_so_far;
            this._treeKeys = _treeKeys;
        }

        protected void setupLocal() {
            this._model_mem_size = 0L;
            for (int i = 0; i < this.trees_so_far; ++i) {
                Key<CompressedTree>[] per_class = this._treeKeys[i];
                for (int j = 0; j < per_class.length; ++j) {
                    if (per_class[j] == null || !per_class[j].home()) continue;
                    this._model_mem_size += (long)DKV.get(per_class[j])._max;
                }
            }
        }

        public void reduce(ComputeModelSize cms) {
            if (cms != null) {
                this._model_mem_size += cms._model_mem_size;
            }
        }
    }

    protected static class FrameMap
    extends Iced<FrameMap> {
        public int responseIndex;
        public int offsetIndex;
        public int weightIndex;
        public int tree0Index;
        public int work0Index;
        public int nids0Index;
        public int oobtIndex;
        public int treatmentIndex;

        public FrameMap() {
        }

        public FrameMap(SharedTree t) {
            this.responseIndex = t.idx_resp();
            this.offsetIndex = t.idx_offset();
            this.weightIndex = t.idx_weight();
            this.tree0Index = t.idx_tree(0);
            this.work0Index = t.idx_work(0);
            this.nids0Index = t.idx_nids(0);
            this.oobtIndex = t.idx_oobt();
            this.treatmentIndex = t.idx_treatment();
        }
    }

    protected static class ScoreBuildOneTree
    extends H2O.H2OCountedCompleter {
        final SharedTree _st;
        final int _k;
        final int _nbins;
        final DTree _tree;
        final int[] _leafOffsets;
        final DHistogram[][][] _hcs;
        final Frame _fr2;
        final boolean _build_tree_one_node;
        final float[] _improvPerVar;
        final DistributionFamily _family;
        final int _respIdx;
        final int _weightIdx;
        final int _predsIdx;
        final int _workIdx;
        final int _nidIdx;
        final int _treatmentIdx;
        final GlobalInteractionConstraints _ics;
        public boolean _did_split;

        public ScoreBuildOneTree(SharedTree st, int k, int nbins, DTree tree, int[] leafs, DHistogram[][][] hcs, Frame fr2, boolean build_tree_one_node, float[] improvPerVar, DistributionFamily family, int respIdx, int weightIdx, int predsIdx, int workIdx, int nidIdx, int treatmentIdx) {
            this._st = st;
            this._k = k;
            this._nbins = nbins;
            this._tree = tree;
            this._leafOffsets = leafs;
            this._hcs = hcs;
            this._fr2 = fr2;
            this._build_tree_one_node = build_tree_one_node;
            this._improvPerVar = improvPerVar;
            this._family = family;
            this._respIdx = respIdx;
            this._weightIdx = weightIdx;
            this._predsIdx = predsIdx;
            this._workIdx = workIdx;
            this._nidIdx = nidIdx;
            this._treatmentIdx = treatmentIdx;
            this._ics = st._ics;
        }

        public void compute2() {
            int treeNum = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._st._model))._output)._ntrees;
            new ScoreBuildHistogram2(this, treeNum, this._k, this._st._ncols, this._nbins, this._tree, this._leafOffsets[this._k], this._hcs[this._k], this._family, this._respIdx, this._weightIdx, this._predsIdx, this._workIdx, this._nidIdx, this._treatmentIdx).dfork2(this._fr2);
        }

        public void onCompletion(CountedCompleter caller) {
            ScoreBuildHistogram sbh = (ScoreBuildHistogram)caller;
            int leafOffset = this._leafOffsets[this._k];
            int tmax = this._tree.len();
            for (int leaf = leafOffset; leaf < tmax; ++leaf) {
                DTree.UndecidedNode udn = this._tree.undecided(leaf);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)((this._st._nclass == 1 ? "Regression" : "Class " + this._st._response.domain()[this._k]) + ",\n  Undecided node:" + (Object)((Object)udn)));
                }
                DTree.DecidedNode dn = this._st.makeDecided(udn, sbh._hcs[leaf - leafOffset], udn._cs);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)((Object)((Object)dn) + "\n" + (Object)((Object)dn._split)));
                }
                if (dn._split == null) {
                    udn.doNotSplit();
                    continue;
                }
                this._did_split = true;
                DTree.Split s = dn._split;
                float improvement = (float)(s.pre_split_se() - s.se());
                assert (improvement >= 0.0f);
                AtomicUtils.FloatArray.add((float[])this._improvPerVar, (int)s.col(), (float)improvement);
            }
            this._leafOffsets[this._k] = tmax;
            int new_leafs = this._tree.len() - tmax;
            this._hcs[this._k] = new DHistogram[new_leafs][];
            for (int nl = tmax; nl < this._tree.len(); ++nl) {
                this._hcs[this._k][nl - tmax] = this._tree.undecided((int)nl)._hs;
            }
            if (this._did_split) {
                ++this._tree._depth;
            }
        }
    }

    protected abstract class Driver
    extends ModelBuilder.Driver {
        protected Driver() {
            super((ModelBuilder)SharedTree.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            SharedTree.this._model = null;
            try {
                String[] domain;
                String[] stringArray;
                String[] actualDomain;
                boolean isQuasibinomial;
                Object model;
                SharedTree.this.init(true);
                if (SharedTree.this.error_count() > 0) {
                    throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)SharedTree.this);
                }
                if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).hasCheckpoint()) {
                    model = ((SharedTreeModel)DKV.get((Key)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._checkpoint).get()).deepClone(SharedTree.this._result);
                    ((SharedTreeModel)((Object)model))._parms = SharedTree.this._parms;
                    SharedTree.this._model = (SharedTreeModel)model.delete_and_lock(SharedTree.this._job);
                } else {
                    model = this.makeModel(SharedTree.this.dest(), (SharedTreeModel.SharedTreeParameters)SharedTree.this._parms);
                    SharedTree.this._model = (SharedTreeModel)model.delete_and_lock(SharedTree.this._job);
                    ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._init_f = SharedTree.this._initialPrediction;
                }
                boolean bl = isQuasibinomial = ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._distribution == DistributionFamily.quasibinomial;
                if (isQuasibinomial) {
                    actualDomain = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(null, 2).doAll(new Vec[]{SharedTree.this._response})).stringDomain(SharedTree.this._response.isInt());
                    ((GBMModel.GBMOutput)((GBMModel)((Object)SharedTree.this._model))._output)._quasibinomialDomains = actualDomain;
                } else {
                    actualDomain = SharedTree.this.isSupervised() ? SharedTree.this._response.domain() : null;
                }
                assert (SharedTree.this._nclass > 1 && actualDomain != null || SharedTree.this._nclass == 1 && actualDomain == null);
                if (SharedTree.this._nclass == 1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "r";
                } else {
                    stringArray = domain = actualDomain;
                }
                if (SharedTree.this._nclass > 1) {
                    if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).isClassifier() && ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._balance_classes) {
                        float[] trainSamplingFactors = new float[SharedTree.this._train.lastVec().domain().length];
                        if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors != null) {
                            if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors.length != SharedTree.this._train.lastVec().domain().length) {
                                throw new IllegalArgumentException("class_sampling_factors must have " + SharedTree.this._train.lastVec().domain().length + " elements");
                            }
                            trainSamplingFactors = (float[])((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors.clone();
                        }
                        boolean verboseSampling = Boolean.getBoolean("sys.ai.h2o.debug.sharedTree.sampleFrameStratified.verbose");
                        Frame stratified = isQuasibinomial ? MRUtils.sampleFrameStratified((Frame)SharedTree.this._train, (Vec)SharedTree.this._train.lastVec(), (Vec)SharedTree.this._train.vec(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).weightsName()), (float[])trainSamplingFactors, (long)((long)(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._max_after_balance_size * (float)SharedTree.this._train.numRows())), (long)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed, (boolean)true, (boolean)verboseSampling, (String[])domain) : MRUtils.sampleFrameStratified((Frame)SharedTree.this._train, (Vec)SharedTree.this._train.lastVec(), (Vec)SharedTree.this._train.vec(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).weightsName()), (float[])trainSamplingFactors, (long)((long)(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._max_after_balance_size * (float)SharedTree.this._train.numRows())), (long)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed, (boolean)true, (boolean)verboseSampling, null);
                        if (stratified != SharedTree.this._train) {
                            MRUtils.ClassDistQuasibinomial cdmt2;
                            SharedTree.this._train = stratified;
                            SharedTree.this._response = stratified.vec(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._response_column);
                            SharedTree.this._weights = stratified.vec(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._weights_column);
                            if (isQuasibinomial) {
                                cdmt2 = SharedTree.this._weights != null ? (MRUtils.ClassDistQuasibinomial)new MRUtils.ClassDistQuasibinomial(domain).doAll(new Vec[]{SharedTree.this._response, SharedTree.this._weights}) : (MRUtils.ClassDistQuasibinomial)new MRUtils.ClassDistQuasibinomial(domain).doAll(new Vec[]{SharedTree.this._response});
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution = cdmt2.dist();
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist = cdmt2.relDist();
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._domains[((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._domains.length] = domain;
                            } else {
                                cdmt2 = SharedTree.this._weights != null ? (MRUtils.ClassDist)new MRUtils.ClassDist(SharedTree.this._nclass).doAll(new Vec[]{SharedTree.this._response, SharedTree.this._weights}) : (MRUtils.ClassDist)new MRUtils.ClassDist(SharedTree.this._nclass).doAll(new Vec[]{SharedTree.this._response});
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution = cdmt2.dist();
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist = cdmt2.relDist();
                            }
                        }
                    }
                    LOG.info((Object)("Prior class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._priorClassDist)));
                    LOG.info((Object)("Model class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist)));
                    if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._sample_rate_per_class != null) {
                        LOG.info((Object)"Sample rates per tree (this affects the distribution of probabilities):");
                        for (int i = 0; i < SharedTree.this.nclasses(); ++i) {
                            LOG.info((Object)(" sample rate for class '" + SharedTree.this.response().domain()[i] + "' : " + ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._sample_rate_per_class[i]));
                        }
                    }
                }
                if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._histogram_type == SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal || ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._histogram_type == SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin) {
                    SharedTree.this._job.update(1L, "Computing top-level histogram split-points.");
                    Timer exactT = new Timer();
                    double[][] exactSplitPoints = ExactSplitPoints.splitPoints(SharedTree.this._train, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._nbins);
                    LOG.info((Object)("Calculating exact (low cardinality) histogram split-points took " + exactT));
                    Timer quantileT = new Timer();
                    double[][] quantileSplitPoints = GlobalQuantilesCalc.splitPoints(SharedTree.this._train, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._weights_column, exactSplitPoints, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._nbins, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._nbins_top_level);
                    Futures fs = new Futures();
                    int qCnt = 0;
                    int eCnt = 0;
                    for (int i = 0; i < quantileSplitPoints.length; ++i) {
                        double[] sp;
                        assert (exactSplitPoints[i] == null || quantileSplitPoints[i] == null);
                        Key<DHistogram.HistoSplitPoints> key = this.getGlobalSplitPointsKey(i);
                        if (key == null) continue;
                        boolean useQuantiles = exactSplitPoints[i] == null;
                        double[] dArray = sp = useQuantiles ? quantileSplitPoints[i] : exactSplitPoints[i];
                        if (sp == null) continue;
                        if (useQuantiles) {
                            ++qCnt;
                        } else {
                            ++eCnt;
                        }
                        DKV.put((Keyed)new DHistogram.HistoSplitPoints(key, sp, useQuantiles), (Futures)fs);
                    }
                    fs.blockForPending();
                    LOG.info((Object)("Split-points are defined using " + eCnt + " exact sets of points and " + qCnt + " sets of quantile values."));
                    LOG.info((Object)("Calculating top-level histogram split-points took " + quantileT));
                }
                String[] twNames = new String[SharedTree.this._nclass * 2];
                for (int i = 0; i < SharedTree.this._nclass; ++i) {
                    twNames[i] = "Tree_" + domain[i];
                    twNames[((SharedTree)SharedTree.this)._nclass + i] = "Work_" + domain[i];
                }
                Vec[] twVecs = this.templateVec().makeVolatileDoubles(SharedTree.this._nclass * 2);
                SharedTree.this._train.add(twNames, twVecs);
                String[] names = new String[SharedTree.this._nclass];
                int[] cons = new int[SharedTree.this._nclass];
                for (int i = 0; i < SharedTree.this._nclass; ++i) {
                    names[i] = "NIDs_" + domain[i];
                    cons[i] = SharedTree.this.isSupervised() && ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution[i] == 0.0 ? -1 : 0;
                }
                Vec[] vs = this.templateVec().makeVolatileInts(cons);
                SharedTree.this._train.add(names, vs);
                SharedTree.this._train.add("OUT_BAG_TREES", this.templateVec().makeZero());
                if (SharedTree.this._valid != null) {
                    SharedTree.this._validWorkspace = this.makeValidWorkspace();
                    String[] vdomain = isQuasibinomial ? actualDomain : SharedTree.this.vresponse().domain();
                    SharedTree.this._validPredsCache = Score.makePredictionCache(SharedTree.this._model, SharedTree.this.vresponse(), vdomain);
                }
                SharedTree.this._trainPredsCache = Score.makePredictionCache(SharedTree.this._model, this.templateVec(), actualDomain);
                SharedTree.this._improvPerVar = new float[SharedTree.this._ncols];
                SharedTree.this._rand = RandomUtils.getRNG((long[])new long[]{((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed});
                SharedTreeDebugParams debugParms = SharedTree.this.getDebugParams();
                if (!debugParms.isDefault()) {
                    LOG.warn((Object)("Model will be trained with debug parameters enabled: " + debugParms.toJsonString()));
                }
                this.initializeModelSpecifics();
                this.resumeFromCheckpoint(SharedTree.this);
                this.scoreAndBuildTrees(this.doOOBScoring());
                SharedTree.this.postProcessModel();
            }
            finally {
                if (SharedTree.this._eventPublisher != null) {
                    SharedTree.this._eventPublisher.onAllIterationsComplete();
                }
                if (SharedTree.this._model != null) {
                    SharedTree.this._model.unlock(SharedTree.this._job);
                }
                for (Key<DHistogram.HistoSplitPoints> k : this.getGlobalSplitPointsKeys()) {
                    Keyed.remove(k);
                }
                if (SharedTree.this._validWorkspace != null) {
                    SharedTree.this._validWorkspace.remove();
                    SharedTree.this._validWorkspace = null;
                }
                if (SharedTree.this._validPredsCache != null) {
                    SharedTree.this._validPredsCache.remove();
                    SharedTree.this._validPredsCache = null;
                }
                if (SharedTree.this._trainPredsCache != null) {
                    SharedTree.this._trainPredsCache.remove();
                    SharedTree.this._trainPredsCache = null;
                }
            }
        }

        private Vec templateVec() {
            return SharedTree.this.isSupervised() ? SharedTree.this._response : SharedTree.this._train.anyVec();
        }

        protected abstract M makeModel(Key<M> var1, P var2);

        protected abstract boolean doOOBScoring();

        protected abstract boolean buildNextKTrees();

        protected abstract void initializeModelSpecifics();

        protected void doInTrainingCheckpoint() {
            throw new UnsupportedOperationException("In training checkpoints are not supported for this algorithm");
        }

        protected Frame makeValidWorkspace() {
            return null;
        }

        protected Key<DHistogram.HistoSplitPoints> getGlobalSplitPointsKey(int i) {
            if (SharedTree.this._model == null || ((SharedTreeModel)((Object)SharedTree.this._model))._key == null || ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._histogram_type != SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal && ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._histogram_type != SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin) {
                return null;
            }
            return Key.makeSystem((String)(((SharedTreeModel)((Object)SharedTree.this._model))._key + "_splits_col_" + i));
        }

        protected Key<DHistogram.HistoSplitPoints>[] getGlobalSplitPointsKeys() {
            Key[] keys = new Key[SharedTree.this._ncols];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.getGlobalSplitPointsKey(i);
            }
            return keys;
        }

        protected final void resumeFromCheckpoint(SharedTree st) {
            if (!((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).hasCheckpoint()) {
                return;
            }
            Timer t = new Timer();
            int ntreesFromCheckpoint = ((SharedTreeModel.SharedTreeParameters)((Model)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._checkpoint.get())._parms)._ntrees;
            new ReconstructTreeState(SharedTree.this._ncols, SharedTree.this._nclass, st, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._sample_rate, new CompressedForest(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._treeKeys, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._domains), this.doOOBScoring()).doAll(SharedTree.this._train, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
            for (int i = 0; i < ntreesFromCheckpoint; ++i) {
                SharedTree.this._rand.nextLong();
            }
            LOG.info((Object)("Reconstructing OOB stats from checkpoint took " + t));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)SharedTree.this._train.toTwoDimTable());
            }
        }

        protected final void scoreAndBuildTrees(boolean oob) {
            int[] scoredNum = new int[]{};
            if (SharedTree.this._coordinator != null) {
                SharedTree.this._coordinator.initStoppingParameters();
            }
            for (int tid = 0; tid < SharedTree.this._ntrees; ++tid) {
                boolean manualCheckpointsInterval;
                boolean scored = SharedTree.this.doScoringAndSaveModel(false, oob, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
                if (scored) {
                    scoredNum = ArrayUtils.append((int[])scoredNum, (int)tid);
                    if (ScoreKeeper.stopEarly((ScoreKeeper[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).scoreKeepers(), (int)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_rounds, (ScoreKeeper.ProblemType)SharedTree.this.getProblemType(), (ScoreKeeper.IStoppingMetric)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_metric, (double)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_tolerance, (String)"model's last", (boolean)true)) {
                        if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._is_cv_model && ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._use_best_cv_iteration) {
                            ScoreKeeper[] sk = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).scoreKeepers();
                            int best = ScoreKeeper.best((ScoreKeeper[])sk, (int)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_rounds, (ScoreKeeper.IStoppingMetric)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._stopping_metric);
                            if (best != sk.length - 1) {
                                int bestNTrees = scoredNum[best];
                                LOG.info((Object)(SharedTree.this._desc + " built total of " + scoredNum[scoredNum.length - 1] + " trees, however the best score was obtained using only ntrees=" + bestNTrees + ". Trimming model to " + bestNTrees + " trees."));
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).trimTo(bestNTrees);
                                SharedTree.this._model.update(SharedTree.this._job);
                            }
                        } else if (!((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._is_cv_model) {
                            LOG.info((Object)("Stopping early and setting actual ntrees to the " + ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._ntrees));
                            ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._ntrees = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._ntrees;
                        }
                        SharedTree.this._job.update((long)(SharedTree.this._ntrees - ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._ntrees));
                        LOG.info((Object)SharedTree.this._model.toString());
                        return;
                    }
                }
                boolean bl = manualCheckpointsInterval = tid > 0 && tid % ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._in_training_checkpoints_tree_interval == 0;
                if (!StringUtils.isNullOrEmpty((String)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._in_training_checkpoints_dir) && manualCheckpointsInterval) {
                    this.doInTrainingCheckpoint();
                }
                Timer kb_timer = new Timer();
                boolean converged = this.buildNextKTrees();
                LOG.info((Object)(tid + 1 + ". tree was built in " + kb_timer.toString()));
                if (SharedTree.this._eventPublisher != null) {
                    SharedTree.this._eventPublisher.onIterationComplete();
                }
                SharedTree.this._job.update(1L);
                if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._treeStats._max_depth == 0) {
                    LOG.warn((Object)"Nothing to split on: Check that response and distribution are meaningful (e.g., you are not using laplace/quantile regression with a binary response).");
                }
                if (converged || SharedTree.this.timeout()) {
                    SharedTree.this._job.update((long)(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._ntrees - tid - 1));
                    break;
                }
                if (SharedTree.this.stop_requested()) {
                    throw new Job.JobCancelledException();
                }
                if (tid != SharedTree.this._ntrees - 1 || SharedTree.this._coordinator == null) continue;
                SharedTree.this._coordinator.updateParameters();
            }
            SharedTree.this.doScoringAndSaveModel(true, oob, ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._build_tree_one_node);
        }
    }
}

