/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.ModelMojoWriter;
import hex.glm.GLMModel;
import hex.isotonic.IsotonicRegressionModel;
import hex.tree.CalibrationHelper;
import hex.tree.CompressedTree;
import hex.tree.SharedTreeModel;
import java.io.IOException;
import water.DKV;
import water.Key;
import water.Value;

public abstract class SharedTreeMojoWriter<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends ModelMojoWriter<M, P, O> {
    public SharedTreeMojoWriter() {
    }

    public SharedTreeMojoWriter(M model) {
        super(model);
    }

    protected void writeModelData() throws IOException {
        assert (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeys.length == ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees);
        int nclasses = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output).nclasses();
        int ntreesPerClass = ((SharedTreeModel)this.model).binomialOpt() && nclasses == 2 ? 1 : nclasses;
        this.writekv("n_trees", ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees);
        this.writekv("n_trees_per_class", ntreesPerClass);
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output).isCalibrated()) {
            CalibrationHelper.CalibrationMethod calibMethod = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output).getCalibrationMethod();
            Model<?, ?, ?> calibModel = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output).calibrationModel();
            this.writekv("calib_method", calibMethod.getId());
            switch (calibMethod) {
                case PlattScaling: {
                    double[] beta = ((GLMModel)calibModel).beta();
                    assert (beta.length == nclasses);
                    this.writekv("calib_glm_beta", beta);
                    break;
                }
                case IsotonicRegression: {
                    IsotonicRegressionModel isotonic = (IsotonicRegressionModel)calibModel;
                    this.write(isotonic.toIsotonicCalibrator());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("MOJO is not (yet) support for calibration model " + (Object)((Object)calibMethod));
                }
            }
        }
        this.writekv("_genmodel_encoding", ((SharedTreeModel)this.model).getGenModelEncoding());
        String[] origNames = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origNames;
        if (origNames != null) {
            int nOrigNames = origNames.length;
            this.writekv("_n_orig_names", nOrigNames);
            this.writeStringArray(origNames, "_orig_names");
        }
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origDomains != null) {
            int nOrigDomainValues = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origDomains.length;
            this.writekv("_n_orig_domain_values", nOrigDomainValues);
            for (int i = 0; i < nOrigDomainValues; ++i) {
                String[] currOrigDomain = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._origDomains[i];
                this.writekv("_m_orig_domain_values_" + i, currOrigDomain == null ? 0 : currOrigDomain.length);
                if (currOrigDomain == null) continue;
                this.writeStringArray(currOrigDomain, "_orig_domain_values_" + i);
            }
        }
        this.writekv("_orig_projection_array", ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._orig_projection_array);
        for (int i = 0; i < ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees; ++i) {
            for (int j = 0; j < ntreesPerClass; ++j) {
                Value ctVal;
                Key<CompressedTree> key = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeys[i][j];
                Value value = ctVal = key != null ? DKV.get(key) : null;
                if (ctVal == null) continue;
                CompressedTree ct = (CompressedTree)ctVal.get();
                this.writeblob(String.format("trees/t%02d_%03d.bin", j, i), ct._bits);
                if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeysAux == null) continue;
                key = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeysAux[i][j];
                Value value2 = ctVal = key != null ? DKV.get(key) : null;
                if (ctVal == null) continue;
                ct = (CompressedTree)ctVal.get();
                this.writeblob(String.format("trees/t%02d_%03d_aux.bin", j, i), ct._bits);
            }
        }
    }
}

