/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt.binning;

import hex.tree.dt.DT;
import hex.tree.dt.DataFeaturesLimits;
import hex.tree.dt.binning.AbstractBin;
import hex.tree.dt.binning.BinningStrategy;
import hex.tree.dt.binning.FeatureBins;
import hex.tree.dt.binning.SplitStatistics;
import hex.tree.dt.mrtasks.FeaturesLimitsMRTask;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import water.fvec.Frame;

public class Histogram {
    private final List<FeatureBins> _featuresBins;
    private final BinningStrategy _binningStrategy;

    public Histogram(Frame originData, DataFeaturesLimits conditionLimits, BinningStrategy binningStrategy) {
        this._binningStrategy = binningStrategy;
        DataFeaturesLimits featuresLimitsForConditions = Histogram.getFeaturesLimitsForConditions(originData, conditionLimits);
        this._featuresBins = IntStream.range(0, originData.numCols() - 1).mapToObj(i -> new FeatureBins(this._binningStrategy.createFeatureBins(originData, featuresLimitsForConditions, i), originData.vec(i).cardinality())).collect(Collectors.toList());
    }

    public List<AbstractBin> getFeatureBins(int featureIndex) {
        return this._featuresBins.get(featureIndex).getFeatureBins();
    }

    public int featuresCount() {
        return this._featuresBins.size();
    }

    public static DataFeaturesLimits getFeaturesLimitsForConditions(Frame originData, DataFeaturesLimits conditionLimits) {
        FeaturesLimitsMRTask task = new FeaturesLimitsMRTask(conditionLimits == null ? DT.getInitialFeaturesLimits(originData).toDoubles() : conditionLimits.toDoubles());
        task.doAll(originData);
        return new DataFeaturesLimits(task._realFeatureLimits);
    }

    public List<SplitStatistics> calculateSplitStatisticsForNumericFeature(int feature) {
        return this._featuresBins.get(feature).calculateSplitStatisticsForNumericFeature();
    }

    public List<SplitStatistics> calculateSplitStatisticsForCategoricalFeature(int feature) {
        return this._featuresBins.get(feature).calculateSplitStatisticsForCategoricalFeature();
    }

    public boolean isConstant(int featureIndex) {
        return this._featuresBins.get(featureIndex).isConstant();
    }
}

