/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt.mrtasks;

import java.util.Arrays;
import org.apache.commons.math3.util.Precision;
import water.MRTask;
import water.fvec.Chunk;

public class CountBinsSamplesCountsMRTask
extends MRTask<CountBinsSamplesCountsMRTask> {
    public final int _featureSplit;
    final double[][] _featuresLimits;
    public double[][] _bins;
    public static final int NUMERICAL_FLAG = 0;
    public static final int COUNT = 1;
    public static final int COUNT_0 = 2;

    public CountBinsSamplesCountsMRTask(int featureSplit, double[][] featuresLimits, double[][] bins) {
        this._featureSplit = featureSplit;
        this._featuresLimits = featuresLimits;
        this._bins = bins;
    }

    public void map(Chunk[] cs) {
        double[][] tmpBins = new double[this._bins.length][];
        for (int b = 0; b < this._bins.length; ++b) {
            tmpBins[b] = Arrays.copyOf(this._bins[b], this._bins[b].length);
        }
        this._bins = tmpBins;
        int classFeature = cs.length - 1;
        int numRows = cs[0]._len;
        for (int row = 0; row < numRows; ++row) {
            int i;
            boolean conditionsFailed = false;
            for (int column = 0; column < cs.length - 1; ++column) {
                if (this.verifyLimits(cs[column].atd(row), column)) continue;
                conditionsFailed = true;
                break;
            }
            if (conditionsFailed) continue;
            if (!this.isNumerical(this._featureSplit)) {
                for (i = 0; i < this._bins.length; ++i) {
                    if (this._bins[i][0] != cs[this._featureSplit].atd(row)) continue;
                    double[] dArray = this._bins[i];
                    dArray[1] = dArray[1] + 1.0;
                    if (!Precision.equals((double)cs[classFeature].atd(row), (double)0.0, (double)Precision.EPSILON)) continue;
                    double[] dArray2 = this._bins[i];
                    dArray2[2] = dArray2[2] + 1.0;
                }
                continue;
            }
            for (i = 0; i < this._bins.length; ++i) {
                if (!this.checkBinBelonging(cs[this._featureSplit].atd(row), i)) continue;
                double[] dArray = this._bins[i];
                dArray[1] = dArray[1] + 1.0;
                if (!Precision.equals((double)cs[classFeature].atd(row), (double)0.0, (double)Precision.EPSILON)) continue;
                double[] dArray3 = this._bins[i];
                dArray3[2] = dArray3[2] + 1.0;
            }
        }
    }

    private boolean isNumerical(int feature) {
        return this._featuresLimits[feature][0] == -1.0;
    }

    private boolean verifyLimits(double featureValue, int column) {
        if (this.isNumerical(column)) {
            return featureValue > this._featuresLimits[column][1] && featureValue <= this._featuresLimits[column][2];
        }
        return this._featuresLimits[column][(int)featureValue] == 1.0;
    }

    private boolean checkBinBelonging(double featureValue, int bin) {
        return featureValue > this._bins[bin][3] && featureValue <= this._bins[bin][4];
    }

    public void reduce(CountBinsSamplesCountsMRTask mrt) {
        for (int i = 0; i < this._bins.length; ++i) {
            double[] dArray = this._bins[i];
            dArray[1] = dArray[1] + mrt._bins[i][1];
            double[] dArray2 = this._bins[i];
            dArray2[2] = dArray2[2] + mrt._bins[i][2];
        }
    }
}

