/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended.isolationtree;

import hex.tree.isoforextended.isolationtree.IsolationTree;

public class IsolationTreeStats {
    public int _minDepth = -1;
    public int _maxDepth = -1;
    public float _meanDepth;
    public int _minLeaves = -1;
    public int _maxLeaves = -1;
    public float _meanLeaves;
    public int _minIsolated = -1;
    public int _maxIsolated = -1;
    public float _meanIsolated;
    public long _minNotIsolated = -1L;
    public long _maxNotIsolated = -1L;
    public float _meanNotIsolated;
    public int _minZeroSplits = -1;
    public int _maxZeroSplits = -1;
    public float _meanZeroSplits;
    public int _numTrees = 0;
    private long _sumDepth = 0L;
    private long _sumLeaves = 0L;
    private long _sumIsolated = 0L;
    private long _sumNotIsolated = 0L;
    private long _sumZeroSplits = 0L;

    public void updateBy(IsolationTree tree) {
        if (tree == null) {
            return;
        }
        if (this._minDepth == -1 || this._minDepth > tree.getDepth()) {
            this._minDepth = tree.getDepth();
        }
        if (this._maxDepth == -1 || this._maxDepth < tree.getDepth()) {
            this._maxDepth = tree.getDepth();
        }
        if (this._minLeaves == -1 || this._minLeaves > tree.getLeaves()) {
            this._minLeaves = tree.getLeaves();
        }
        if (this._maxLeaves == -1 || this._maxLeaves < tree.getLeaves()) {
            this._maxLeaves = tree.getLeaves();
        }
        if (this._minIsolated == -1 || this._minIsolated > tree.getIsolatedPoints()) {
            this._minIsolated = tree.getIsolatedPoints();
        }
        if (this._maxIsolated == -1 || this._maxIsolated < tree.getIsolatedPoints()) {
            this._maxIsolated = tree.getIsolatedPoints();
        }
        if (this._minNotIsolated == -1L || this._minNotIsolated > tree.getNotIsolatedPoints()) {
            this._minNotIsolated = tree.getNotIsolatedPoints();
        }
        if (this._maxNotIsolated == -1L || this._maxNotIsolated < tree.getNotIsolatedPoints()) {
            this._maxNotIsolated = tree.getNotIsolatedPoints();
        }
        if (this._minZeroSplits == -1 || this._minZeroSplits > tree.getZeroSplits()) {
            this._minZeroSplits = tree.getZeroSplits();
        }
        if (this._maxZeroSplits == -1 || this._maxZeroSplits < tree.getZeroSplits()) {
            this._maxZeroSplits = tree.getZeroSplits();
        }
        this._sumDepth += (long)tree.getDepth();
        this._sumLeaves += (long)tree.getLeaves();
        this._sumIsolated += (long)tree.getIsolatedPoints();
        this._sumNotIsolated += tree.getNotIsolatedPoints();
        this._sumZeroSplits += (long)tree.getZeroSplits();
        ++this._numTrees;
        this.updateMeans();
    }

    private void updateMeans() {
        this._meanDepth = (float)this._sumDepth / (float)this._numTrees;
        this._meanLeaves = (float)this._sumLeaves / (float)this._numTrees;
        this._meanIsolated = (float)this._sumIsolated / (float)this._numTrees;
        this._meanNotIsolated = (float)this._sumNotIsolated / (float)this._numTrees;
        this._meanZeroSplits = (float)this._sumZeroSplits / (float)this._numTrees;
    }
}

