/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import java.util.Arrays;
import water.Key;
import water.Keyed;

class HBWTree
extends Keyed<HBWTree> {
    private static final int MAX_CODE_LENGTH = 40;
    int[][] _code;
    int[][] _point;

    public HBWTree() {
    }

    private HBWTree(Key<HBWTree> key, int size) {
        super(key);
        this._code = new int[size][];
        this._point = new int[size][];
    }

    static HBWTree buildHuffmanBinaryWordTree(long[] wordCounts) {
        int size = wordCounts.length;
        long[] count = new long[size * 2 - 1];
        int[] binary = new int[size * 2 - 1];
        int[] parent_node = new int[size * 2 - 1];
        System.arraycopy(wordCounts, 0, count, 0, size);
        Arrays.fill(count, size, size * 2 - 1, 1000000000000000L);
        int pos1 = size - 1;
        int pos2 = size;
        for (int i = 0; i < size - 1; ++i) {
            int min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            int min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            count[size + i] = count[min1i] + count[min2i];
            parent_node[min1i] = size + i;
            parent_node[min2i] = size + i;
            binary[min2i] = 1;
        }
        HBWTree t = new HBWTree((Key<HBWTree>)Key.make(), size);
        int[] point = new int[40];
        int[] code = new int[40];
        for (int j = 0; j < size; ++j) {
            int k = j;
            int m = 0;
            do {
                int val;
                code[m] = val = binary[k];
                point[m] = k;
                ++m;
            } while ((k = parent_node[k]) != 0);
            t._code[j] = new int[m];
            t._point[j] = new int[m + 1];
            t._point[j][0] = size - 2;
            for (int l = 0; l < m; ++l) {
                t._code[j][m - l - 1] = code[l];
                t._point[j][m - l] = point[l] - size;
            }
        }
        return t;
    }
}

