/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import water.AutoBuffer;
import water.MRTask;
import water.fvec.Chunk;
import water.parser.BufferedString;
import water.util.IcedHashMap;
import water.util.IcedLong;

public class WordCountTask
extends MRTask<WordCountTask> {
    IcedHashMap<BufferedString, IcedLong> _counts;

    WordCountTask() {
    }

    public void map(Chunk cs) {
        this._counts = new IcedHashMap();
        for (int i = 0; i < cs._len; ++i) {
            if (cs.isNA(i)) continue;
            BufferedString str = cs.atStr(new BufferedString(), i);
            IcedLong count = (IcedLong)this._counts.get((Object)str);
            if (count != null) {
                ++count._val;
                continue;
            }
            this._counts.put((Object)str, (Object)new IcedLong(1L));
        }
    }

    public void reduce(WordCountTask other) {
        assert (this._counts != null);
        assert (other._counts != null);
        for (BufferedString str : other._counts.keySet()) {
            IcedLong myCount = (IcedLong)this._counts.get((Object)str);
            if (myCount == null) {
                this._counts.put((Object)str, other._counts.get((Object)str));
                continue;
            }
            myCount._val += ((IcedLong)other._counts.get((Object)str))._val;
        }
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        if (this._counts != null) {
            for (BufferedString key : this._counts.keySet()) {
                ab.put2((char)key.length()).putA1(key.getBuffer(), key.getOffset(), key.getOffset() + key.length()).put8(((IcedLong)this._counts.get((Object)key))._val);
            }
        }
        return ab.put2('\uffff');
    }

    public final WordCountTask read_impl(AutoBuffer ab) {
        char len;
        this._counts = new IcedHashMap();
        while ((len = ab.get2()) != '\uffff') {
            byte[] bs = ab.getA1((int)len);
            long cnt = ab.get8();
            this._counts.put((Object)new BufferedString(new String(bs)), (Object)new IcedLong(cnt));
        }
        return this;
    }
}

