/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.prims.tree;

import hex.Model;
import water.fvec.Frame;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValStr;

public class AstTreeUpdateWeights
extends AstPrimitive<AstTreeUpdateWeights> {
    public String[] args() {
        return new String[]{"model"};
    }

    public int nargs() {
        return 4;
    }

    public String str() {
        return "tree.update.weights";
    }

    public ValStr apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        String weightsColumn;
        Frame frame;
        Model.UpdateAuxTreeWeights model = (Model.UpdateAuxTreeWeights)stk.track(asts[1].exec(env)).getModel();
        Model.UpdateAuxTreeWeights.UpdateAuxTreeWeightsReport report = model.updateAuxTreeWeights(frame = stk.track(asts[2].exec(env)).getFrame(), weightsColumn = stk.track(asts[3].exec(env)).getStr());
        if (report.hasWarnings()) {
            return new ValStr(AstTreeUpdateWeights.makeShortWarning(report));
        }
        return new ValStr("OK");
    }

    private static String makeShortWarning(Model.UpdateAuxTreeWeights.UpdateAuxTreeWeightsReport report) {
        return "Some of the updated nodes have zero weights (eg.: tree #" + (report._warn_trees[0] + 1) + ", class #" + (report._warn_classes[0] + 1) + ").";
    }
}

