/*
 * Decompiled with CFR 0.152.
 */
package water.tools;

import hex.generic.Generic;
import hex.generic.GenericModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import water.ExtensionManager;
import water.H2O;
import water.Paxos;

public class MojoConvertTool {
    private final File _mojo_file;
    private final File _pojo_file;

    public MojoConvertTool(File mojoFile, File pojoFile) {
        this._mojo_file = mojoFile;
        this._pojo_file = pojoFile;
    }

    void convert() throws IOException {
        GenericModel mojo = Generic.importMojoModel(this._mojo_file.getAbsolutePath(), true);
        String pojo = mojo.toJava(false, true);
        Path pojoPath = Paths.get(this._pojo_file.toURI());
        Files.write(pojoPath, pojo.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void usage() {
        System.err.println("java -cp h2o.jar " + MojoConvertTool.class.getName() + " source_mojo.zip target_pojo.java");
    }

    public static void main(String[] args) throws IOException {
        File pojoFile;
        File mojoFile;
        if (args.length < 2) {
            MojoConvertTool.usage();
            System.exit(1);
        }
        if (!(mojoFile = new File(args[0])).isFile()) {
            System.err.println("Specified MOJO file (" + mojoFile.getAbsolutePath() + ") doesn't exist!");
            System.exit(2);
        }
        if ((pojoFile = new File(args[1])).isDirectory() || pojoFile.getParentFile() != null && !pojoFile.getParentFile().isDirectory()) {
            System.err.println("Invalid target POJO file (" + pojoFile.getAbsolutePath() + ")! Please specify a file in an existing directory.");
            System.exit(3);
        }
        System.out.println();
        System.out.println("Starting local H2O instance to facilitate MOJO to POJO conversion.");
        System.out.println();
        H2O.main((String[])new String[]{"-disable_web", "-ip", "localhost", "-disable_net"});
        ExtensionManager.getInstance().registerRestApiExtensions();
        H2O.waitForCloudSize((int)1, (long)60000L);
        Paxos.lockCloud((Object)"H2O is started in a single node configuration.");
        System.out.println();
        System.out.println("Converting " + mojoFile + " to " + pojoFile + "...");
        new MojoConvertTool(mojoFile, pojoFile).convert();
        System.out.println("DONE");
    }
}

