/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.IdentityFunction;
import hex.LinkFunction;
import hex.Model;
import hex.genmodel.utils.DistributionFamily;
import water.H2O;
import water.Iced;

public abstract class Distribution
extends Iced<Distribution> {
    public final double _tweediePower;
    public final double _quantileAlpha;
    public double _huberDelta;
    public LinkFunction _linkFunction;
    public final DistributionFamily _family;

    public Distribution(DistributionFamily family, LinkFunction lf) {
        this._tweediePower = 1.5;
        this._quantileAlpha = 0.5;
        this._huberDelta = Double.NaN;
        this._linkFunction = lf;
        this._family = family;
    }

    public Distribution(DistributionFamily family) {
        this._tweediePower = 1.5;
        this._quantileAlpha = 0.5;
        this._huberDelta = Double.NaN;
        this._linkFunction = new IdentityFunction();
        this._family = family;
    }

    public Distribution(Model.Parameters params, LinkFunction lf) {
        this._tweediePower = params._tweedie_power;
        this._quantileAlpha = params._quantile_alpha;
        this._huberDelta = 1.0;
        assert (this._tweediePower > 1.0 && this._tweediePower < 2.0);
        this._linkFunction = lf;
        this._family = params._distribution;
    }

    public Distribution(Model.Parameters params) {
        this._tweediePower = params._tweedie_power;
        this._quantileAlpha = params._quantile_alpha;
        this._huberDelta = 1.0;
        assert (this._tweediePower > 1.0 && this._tweediePower < 2.0);
        this._linkFunction = new IdentityFunction();
        this._family = params._distribution;
    }

    public void setHuberDelta(double huberDelta) {
        this._huberDelta = huberDelta;
    }

    public double link(double f) {
        return this._linkFunction.link(f);
    }

    public double linkInv(double f) {
        return this._linkFunction.linkInv(f);
    }

    public String linkInvString(String f) {
        return this._linkFunction.linkInvString(f);
    }

    public double deviance(double w, double y, double f) {
        throw H2O.unimpl();
    }

    public double negHalfGradient(double y, double f) {
        throw H2O.unimpl();
    }

    public double negHalfGradient(double y, double f, int l) {
        throw H2O.unimpl();
    }

    public double initFNum(double w, double o, double y) {
        throw H2O.unimpl();
    }

    public double initFDenom(double w, double o, double y) {
        throw H2O.unimpl();
    }

    public double gammaNum(double w, double y, double z, double f) {
        throw H2O.unimpl();
    }

    public double gammaDenom(double w, double y, double z, double f) {
        throw H2O.unimpl();
    }

    public void reset() {
    }
}

