/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.Model;

class HuberDistribution
extends Distribution {
    public HuberDistribution(Model.Parameters params) {
        super(params);
    }

    @Override
    public double deviance(double w, double y, double f) {
        if (Math.abs(y - f) <= this._huberDelta) {
            return w * (y - f) * (y - f);
        }
        return w * (2.0 * Math.abs(y - f) - this._huberDelta) * this._huberDelta;
    }

    @Override
    public double negHalfGradient(double y, double f) {
        if (Math.abs(y - f) <= this._huberDelta) {
            return y - f;
        }
        return f >= y ? -this._huberDelta : this._huberDelta;
    }
}

