/*
 * Decompiled with CFR 0.152.
 */
package hex;

import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.Value;

public class ObjectConsistencyChecker
extends MRTask<ObjectConsistencyChecker> {
    private final Key<?> _key;
    private final byte[] _bytes;

    public ObjectConsistencyChecker(Key<?> key) {
        this._key = key;
        Object pojo = DKV.getGet(key);
        if (pojo == null) {
            throw new IllegalArgumentException("Object with key='" + key + "' doesn't exist in DKV.");
        }
        this._bytes = ((Iced)pojo).asBytes();
    }

    @Override
    protected void setupLocal() {
        Value val = H2O.STORE.get(this._key);
        if (val == null) {
            return;
        }
        if (!val.isConsistent()) {
            throw new IllegalStateException("Object " + this._key + " is locally modified on node " + H2O.SELF + ".");
        }
    }
}

