/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.columns;

import hex.createframe.CreateFrameColumnMaker;
import java.util.Random;
import water.fvec.NewChunk;

public class CategoricalColumnCfcm
extends CreateFrameColumnMaker {
    private String name;
    private int numFactors;
    private String[] domain;
    private static String[] _animals = new String[]{"cat", "dog", "fish", "cow", "horse", "pig", "bird", "lion", "sheep", "rhino", "bull", "eagle", "crab", "wolf", "duck", "crow", "fox", "bear", "hare", "camel", "bat", "frog", "ant", "otter", "tiger", "rat", "snake", "zebra", "seal", "bison", "newt", "deer", "mouse", "turkey"};

    public CategoricalColumnCfcm() {
    }

    public CategoricalColumnCfcm(String colName, int nFactors) {
        this.name = colName;
        this.numFactors = nFactors;
        if (this.name.equals("response")) {
            this.prepareAnimalDomain();
        } else {
            this.prepareSimpleDomain();
        }
    }

    @Override
    public void exec(int nrows, NewChunk[] ncs, Random rng) {
        for (int row = 0; row < nrows; ++row) {
            ncs[this.index].addNum((int)(rng.nextDouble() * (double)this.numFactors));
        }
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.name};
    }

    @Override
    public byte[] columnTypes() {
        return new byte[]{4};
    }

    @Override
    public String[][] columnDomains() {
        return new String[][]{this.domain};
    }

    @Override
    public float byteSizePerRow() {
        return this.numFactors < 128 ? 1.0f : (this.numFactors < 32768 ? 2.0f : 4.0f);
    }

    private void prepareSimpleDomain() {
        this.domain = new String[this.numFactors];
        for (int i = 0; i < this.numFactors; ++i) {
            this.domain[i] = "c" + this.index + ".l" + i;
        }
    }

    private void prepareAnimalDomain() {
        this.domain = new String[this.numFactors];
        System.arraycopy(_animals, 0, this.domain, 0, Math.min(this.numFactors, _animals.length));
        if (this.numFactors > _animals.length) {
            int k = _animals.length;
            block0: for (int i = 0; i < _animals.length; ++i) {
                for (int j = 0; j < _animals.length; ++j) {
                    if (i == j) continue;
                    this.domain[k++] = _animals[i] + _animals[j];
                    if (k == this.numFactors) break block0;
                }
            }
        }
    }
}

