/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe.columns;

import hex.createframe.CreateFrameColumnMaker;
import java.util.Random;
import water.fvec.NewChunk;

public class IntegerColumnCfcm
extends CreateFrameColumnMaker {
    private String name;
    private long lowerBound;
    private long upperBound;

    public IntegerColumnCfcm() {
    }

    public IntegerColumnCfcm(String colName, int lBound, int uBound) {
        this.name = colName;
        this.lowerBound = lBound;
        this.upperBound = uBound;
    }

    @Override
    public void exec(int nrows, NewChunk[] ncs, Random rng) {
        long span = this.upperBound - this.lowerBound + 1L;
        if (span == 1L) {
            for (int row = 0; row < nrows; ++row) {
                ncs[this.index].addNum(this.lowerBound);
            }
        } else {
            for (int row = 0; row < nrows; ++row) {
                ncs[this.index].addNum(this.lowerBound + (long)(rng.nextDouble() * (double)span));
            }
        }
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.name};
    }

    @Override
    public byte[] columnTypes() {
        return new byte[]{3};
    }

    @Override
    public float byteSizePerRow() {
        long integer_range = Math.max(Math.abs(this.upperBound), Math.abs(this.lowerBound));
        if (integer_range < 128L) {
            return 1.0f;
        }
        if (integer_range < 32768L) {
            return 2.0f;
        }
        if (integer_range < 0x80000000L) {
            return 4.0f;
        }
        return 8.0f;
    }
}

