/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Random;
import water.AutoBuffer;
import water.Freezable;
import water.HeartBeat;
import water.TypeMap;
import water.util.UnsafeUtils;

public class JavaSelfCheck {
    public static boolean checkCompatibility() {
        if (!JavaSelfCheck.checkUnsafe()) {
            return false;
        }
        if (!JavaSelfCheck.checkWeaver()) {
            return false;
        }
        return JavaSelfCheck.checkSerialization();
    }

    private static boolean checkSerialization() {
        byte[] bytes = AutoBuffer.serializeBootstrapFreezable(new HeartBeat());
        return AutoBuffer.deserializeBootstrapFreezable(bytes) instanceof HeartBeat;
    }

    private static boolean checkWeaver() {
        Freezable f = TypeMap.newFreezable(HeartBeat.class.getName());
        if (!(f instanceof HeartBeat)) {
            return false;
        }
        return TypeMap.getIcer(f) != null;
    }

    private static boolean checkUnsafe() {
        int i;
        int N = 1024;
        Random r = new Random();
        double[] doubleData = new double[1024];
        byte[] doubleBytes = new byte[8192];
        long[] longData = new long[1024];
        byte[] longBytes = new byte[8192];
        for (i = 0; i < 1024; ++i) {
            doubleData[i] = r.nextDouble();
            UnsafeUtils.set8d(doubleBytes, i * 8, doubleData[i]);
            longData[i] = r.nextLong();
            UnsafeUtils.set8(longBytes, i * 8, longData[i]);
        }
        for (i = 0; i < 1024; ++i) {
            double d = UnsafeUtils.get8d(doubleBytes, i * 8);
            if (d != doubleData[i]) {
                return false;
            }
            long l = UnsafeUtils.get8(longBytes, i * 8);
            if (l == longData[i]) continue;
            return false;
        }
        return true;
    }
}

