/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import java.util.Properties;
import water.TypeMap;
import water.api.Route;
import water.api.Schema;
import water.api.schemas3.ModelParametersSchemaV3;

public class ModelBuilderHandlerUtils {
    static <B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchemaV3> S makeBuilderSchema(int version, String algoURLName, Properties parms, B builder) {
        String algoName = ModelBuilder.algoName(algoURLName);
        String schemaDir = ModelBuilder.schemaDirectory(algoURLName);
        String schemaName = schemaDir + algoName + "V" + version;
        ModelBuilderSchema schema = (ModelBuilderSchema)TypeMap.newFreezable(schemaName);
        schema.init_meta();
        String parmName = schemaDir + algoName + "V" + version + "$" + algoName + "ParametersV" + version;
        schema.parameters = (ModelParametersSchemaV3)TypeMap.newFreezable(parmName);
        ((ModelParametersSchemaV3)schema.parameters).fillFromImpl(builder._parms);
        ((Schema)schema.parameters).fillFromParms(parms);
        ((ModelParametersSchemaV3)schema.parameters).fillImpl(builder._parms);
        ((ModelParametersSchemaV3)schema.parameters).fillImpl(builder._input_parms);
        return (S)schema;
    }

    static <B extends ModelBuilder> B makeBuilder(int version, String algoURLName, Properties parms) {
        Object builder = ModelBuilder.make(algoURLName, null, null);
        ModelBuilderHandlerUtils.makeBuilderSchema(version, algoURLName, parms, builder);
        return builder;
    }

    static String parseAlgoURLName(Route route) {
        String[] ss = route._url.split("/");
        return ss[3];
    }
}

