/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.fvec.WrappedVec;

public class OneChunkVec
extends WrappedVec {
    private int _chunkIdx;
    private transient Chunk _chunk;

    public OneChunkVec(Key<Vec> key, int rowLayout, Key<Vec> masterVecKey, int chunkIdx) {
        super(key, rowLayout, masterVecKey.get().domain(), masterVecKey);
        this._chunkIdx = chunkIdx;
        this._type = this.masterVec()._type;
    }

    public static OneChunkVec make(Vec v, int cidx, Futures fs) {
        OneChunkVec ocv = new OneChunkVec(Vec.newKey(Key.make(v._key + "_oneChunkVec_" + cidx)), -1, v._key, cidx);
        DKV.put(ocv, fs);
        return ocv;
    }

    @Override
    public int elem2ChunkIdx(long i) {
        return 0;
    }

    @Override
    public Vec masterVec() {
        return super.masterVec();
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        assert (cidx == 0);
        if (null == this._chunk) {
            this._chunk = (Chunk)this.masterVec().chunkForChunkIdx(this._chunkIdx).clone();
            this._chunk.setStart(0L);
            this._chunk._vec = this;
        }
        return this._chunk;
    }

    @Override
    public long length() {
        return this.chunkLen(0);
    }

    @Override
    public int nChunks() {
        return 1;
    }

    @Override
    public int chunkLen(int cidx) {
        assert (cidx == 0);
        return this.chunkForChunkIdx(0).len();
    }

    @Override
    long chunk2StartElem(int cidx) {
        return 0L;
    }

    @Override
    public String toString() {
        return "OneChunkVec[" + this._chunkIdx + "] (" + this.masterVec().toString() + ")";
    }
}

