/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.advmath.AstKFold;
import water.rapids.vals.ValFrame;

public class AstModuloKFold
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "nfolds"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "modulo_kfold_column";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Vec foldVec = stk.track(asts[1].exec(env)).getFrame().anyVec().makeZero();
        int nfolds = (int)asts[2].exec(env).getNum();
        return new ValFrame(new Frame(AstKFold.moduloKfoldColumn(foldVec, nfolds)));
    }
}

