/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.misc;

import water.MRTask;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValStr;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.StringUtils;

public class AstSetProperty
extends AstBuiltin<AstSetProperty> {
    @Override
    public String[] args() {
        return new String[]{"property", "value"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "setproperty";
    }

    @Override
    protected ValStr exec(Val[] args) {
        String property = args[1].getStr();
        String value = args[2].getStr();
        String debugMessage = AstSetProperty.setClusterProperty(property, value);
        return new ValStr(debugMessage);
    }

    private static String setClusterProperty(String property, String value) {
        String[] oldValues = ((SetClusterPropertyTask)new SetClusterPropertyTask(property, value).doAllNodes())._oldValues;
        return "Old values of " + property + " (per node): " + StringUtils.join(",", oldValues);
    }

    private static class SetClusterPropertyTask
    extends MRTask<SetClusterPropertyTask> {
        private String _property;
        private String _value;
        private String[] _oldValues;

        private SetClusterPropertyTask(String property, String value) {
            this._property = property;
            this._value = value;
            this._oldValues = new String[0];
        }

        @Override
        protected void setupLocal() {
            this._oldValues = ArrayUtils.append(this._oldValues, String.valueOf(System.getProperty(this._property)));
            Log.info("Setting property: " + this._property + "=" + this._value);
            System.setProperty(this._property, this._value);
        }

        @Override
        public void reduce(SetClusterPropertyTask mrt) {
            this._oldValues = ArrayUtils.append(this._oldValues, mrt._oldValues);
        }
    }
}

