/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.rapids.ast.prims.operators.AstBinOp;
import water.rapids.vals.ValFrame;
import water.util.MathUtils;
import water.util.StringUtils;

public class AstEq
extends AstBinOp {
    @Override
    public String str() {
        return "==";
    }

    @Override
    public double op(double l, double r) {
        return MathUtils.equalsWithinOneSmallUlp(l, r) ? 1.0 : 0.0;
    }

    @Override
    public ValFrame frame_op_scalar(Frame fr, final double d) {
        return new ValFrame(((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c = 0; c < chks.length; ++c) {
                    int i;
                    Chunk chk = chks[c];
                    NewChunk cres = cress[c];
                    BufferedString bStr = new BufferedString();
                    if (chk.vec().isString()) {
                        for (i = 0; i < chk._len; ++i) {
                            cres.addNum(AstEq.this.str_op(chk.atStr(bStr, i), Double.isNaN(d) ? null : new BufferedString(String.valueOf(d))));
                        }
                        continue;
                    }
                    if (!chk.vec().isNumeric()) {
                        cres.addZeros(chk._len);
                        continue;
                    }
                    for (i = 0; i < chk._len; ++i) {
                        cres.addNum(AstEq.this.op(chk.atd(i), d));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame());
    }

    @Override
    public boolean categoricalOK() {
        return true;
    }

    @Override
    public double str_op(BufferedString l, BufferedString r) {
        if (StringUtils.isNullOrEmpty(l)) {
            return StringUtils.isNullOrEmpty(r) ? 1.0 : 0.0;
        }
        return l.equals(r) ? 1.0 : 0.0;
    }
}

