/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.repeaters;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstSeqLen
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"length"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "seq_len";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        int len = (int)Math.ceil(asts[1].exec(env).getNum());
        if (len <= 0) {
            throw new IllegalArgumentException("Error in seq_len(" + len + "): argument must be coercible to positive integer");
        }
        return new ValFrame(new Frame(Vec.makeSeq((long)len, true)));
    }
}

