/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.RPC;
import water.util.Log;
import water.util.LogArchiveContainer;
import water.util.LogArchiveWriter;
import water.util.StringUtils;

public class GetLogsFromNode
extends Iced {
    static final int MB = 0x100000;
    static final int MAX_SIZE = 0x1900000;
    private final int nodeidx;
    private final LogArchiveContainer container;
    public byte[] bytes;

    public GetLogsFromNode(int nodeidx, LogArchiveContainer container) {
        this.nodeidx = nodeidx;
        this.container = container;
    }

    public void doIt() {
        if (this.nodeidx == -1) {
            GetLogsTask t = new GetLogsTask(this.container);
            t.doIt();
            this.bytes = t._bytes;
        } else {
            H2ONode node = H2O.CLOUD._memary[this.nodeidx];
            GetLogsTask t = new GetLogsTask(this.container);
            Log.trace("GetLogsTask starting to node " + this.nodeidx + "...");
            new RPC<GetLogsTask>(node, t).call().get();
            Log.trace("GetLogsTask completed to node " + this.nodeidx);
            this.bytes = t._bytes;
        }
    }

    private static class GetLogsTask
    extends DTask<GetLogsTask> {
        private final LogArchiveContainer _container;
        private byte[] _bytes;

        public GetLogsTask(LogArchiveContainer container) {
            super((byte)119);
            this._container = container;
            this._bytes = null;
        }

        public void doIt() {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 LogArchiveWriter archiveWriter = this._container.createLogArchiveWriter(baos);){
                String archiveRoot = String.format("h2ologs_node%d_%s_%d", H2O.SELF.index(), H2O.SELF_ADDRESS.getHostAddress(), H2O.API_PORT);
                this.archiveDir(Log.getLogDir(), archiveRoot, baos, archiveWriter);
                archiveWriter.close();
                this._bytes = baos.toByteArray();
            }
            catch (Exception e) {
                this._bytes = StringUtils.toBytes(e);
            }
        }

        @Override
        public void compute2() {
            this.doIt();
            this.tryComplete();
        }

        private void archiveDir(String dir, String pathInArchive, ByteArrayOutputStream baos, LogArchiveWriter writer) {
            try {
                File sourceDir = new File(dir);
                File destinationDir = new File(pathInArchive);
                String[] dirList = sourceDir.list();
                if (dirList == null) {
                    return;
                }
                byte[] readBuffer = new byte[4096];
                for (int i = 0; i < dirList.length; ++i) {
                    int bytesIn;
                    File sourceFile = new File(sourceDir, dirList[i]);
                    File destinationFile = new File(destinationDir, dirList[i]);
                    if (sourceFile.isDirectory()) {
                        this.archiveDir(sourceFile.getPath(), destinationFile.getPath(), baos, writer);
                        continue;
                    }
                    if (sourceFile.toString().endsWith(".jar")) continue;
                    FileInputStream fis = new FileInputStream(sourceFile.getPath());
                    LogArchiveWriter.ArchiveEntry anEntry = new LogArchiveWriter.ArchiveEntry(destinationFile.getPath(), sourceFile.lastModified());
                    writer.putNextEntry(anEntry);
                    boolean stopEarlyBecauseTooMuchData = false;
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        writer.write(readBuffer, 0, bytesIn);
                        if (baos.size() <= 0x1900000) continue;
                        stopEarlyBecauseTooMuchData = true;
                        break;
                    }
                    fis.close();
                    writer.closeEntry();
                    if (!stopEarlyBecauseTooMuchData) continue;
                    Log.warn("GetLogsTask stopEarlyBecauseTooMuchData");
                    break;
                }
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }
}

