/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import water.AutoBuffer;
import water.nbhm.NonBlockingHashMap;
import water.util.IcedHashMapBase;

public class IcedHashMap<K, V>
extends IcedHashMapBase<K, V>
implements ConcurrentMap<K, V> {
    transient NonBlockingHashMap<K, V> _map;

    public IcedHashMap() {
        this.init();
    }

    @Override
    protected Map<K, V> map() {
        return this._map;
    }

    @Override
    protected Map<K, V> init() {
        this._map = new NonBlockingHashMap();
        return this._map;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this._map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this._map.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this._map.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this._map.replace(key, value);
    }

    public K getk(K key) {
        return this._map.getk(key);
    }

    @Override
    protected void writeMap(AutoBuffer ab, byte mode) {
        Object[] kvs = this._map.raw_array();
        IcedHashMapBase.KeyType keyType = IcedHashMap.keyType(mode);
        IcedHashMapBase.ValueType valueType = IcedHashMap.valueType(mode);
        IcedHashMapBase.ArrayType valueArrayType = IcedHashMap.arrayType(mode);
        for (int i = 2; i < kvs.length; i += 2) {
            Object value;
            Object key = kvs[i];
            if (!this.isValidKey(key, keyType) || !this.isValidValue(value = kvs[i + 1], valueType, valueArrayType)) continue;
            this.writeKey(ab, keyType, key);
            this.writeValue(ab, valueType, valueArrayType, value);
        }
    }

    @Override
    protected boolean writeable() {
        return true;
    }
}

