/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr;

import com.aetrion.flickr.Response;
import com.aetrion.flickr.util.XMLUtilities;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RESTResponse
implements Response {
    private String stat;
    private Collection payload;
    private String errorCode;
    private String errorMessage;

    @Override
    public void parse(Document document) {
        Element rspElement = document.getDocumentElement();
        rspElement.normalize();
        this.stat = rspElement.getAttribute("stat");
        if ("ok".equals(this.stat)) {
            this.payload = XMLUtilities.getChildElements(rspElement);
        } else if ("fail".equals(this.stat)) {
            Element errElement = (Element)rspElement.getElementsByTagName("err").item(0);
            this.errorCode = errElement.getAttribute("code");
            this.errorMessage = errElement.getAttribute("msg");
        }
    }

    public String getStat() {
        return this.stat;
    }

    @Override
    public Element getPayload() {
        Iterator iter = this.payload.iterator();
        if (iter.hasNext()) {
            return (Element)iter.next();
        }
        throw new RuntimeException("REST response payload has no elements");
    }

    @Override
    public Collection getPayloadCollection() {
        return this.payload;
    }

    @Override
    public boolean isError() {
        return this.errorCode != null;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

