/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.SOAPResponse;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.util.UrlUtilities;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SOAP
extends Transport {
    public static final String URN = "urn:flickr";
    public static final String BODYELEMENT = "FlickrRequest";
    public static final String PATH = "/services/soap/";

    public SOAP() throws ParserConfigurationException {
        this.setTransportType("SOAP");
        this.setResponseClass(SOAPResponse.class);
        this.setPath(PATH);
    }

    public SOAP(String host) throws ParserConfigurationException {
        this();
        this.setHost(host);
    }

    public SOAP(String host, int port) throws ParserConfigurationException {
        this();
        this.setHost(host);
        this.setPort(port);
    }

    @Override
    public Response get(String path, List parameters) throws IOException, SAXException {
        return this.post(path, parameters);
    }

    @Override
    public Response post(String path, List parameters, boolean multipart) throws IOException, SAXException {
        URL url = UrlUtilities.buildUrl(this.getHost(), this.getPort(), path, Collections.EMPTY_LIST);
        try {
            SOAPEnvelope env = new SOAPEnvelope();
            env.addNamespaceDeclaration("xsi", "http://www.w3.org/1999/XMLSchema-instance");
            env.addNamespaceDeclaration("xsd", "http://www.w3.org/1999/XMLSchema");
            Name bodyName = env.createName(BODYELEMENT, "x", URN);
            SOAPBodyElement body = new SOAPBodyElement(bodyName);
            Element e = XMLUtils.StringToElement((String)"", (String)"format", (String)"soap2");
            SOAPBodyElement sbe = new SOAPBodyElement(e);
            body.addChildElement((SOAPElement)sbe);
            for (Parameter p : parameters) {
                e = XMLUtils.StringToElement((String)"", (String)p.getName(), (String)p.getValue().toString());
                sbe = new SOAPBodyElement(e);
                body.addChildElement((SOAPElement)sbe);
            }
            env.addBodyElement(body);
            if (Flickr.debugStream) {
                System.out.println("SOAP ENVELOPE:");
                System.out.println(env.toString());
            }
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(url);
            SOAPEnvelope envelope = call.invoke(env);
            if (Flickr.debugStream) {
                System.out.println("SOAP RESPONSE:");
                System.out.println(envelope.toString());
            }
            SOAPResponse response = new SOAPResponse(envelope);
            response.parse(null);
            return response;
        }
        catch (SOAPException se) {
            se.printStackTrace();
            throw new RuntimeException(se);
        }
        catch (ServiceException se) {
            se.printStackTrace();
            throw new RuntimeException(se);
        }
    }
}

