/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.util.XMLUtilities;
import java.util.Collection;
import java.util.Iterator;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPResponse
implements Response {
    private String stat;
    private Collection payload;
    private String errorCode;
    private String errorMessage;
    private SOAPEnvelope envelope;

    public SOAPResponse(SOAPEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public void parse(Document document) {
        try {
            SOAPFault fault;
            SOAPBody body = (SOAPBody)this.envelope.getBody();
            if (Flickr.debugStream) {
                System.out.println("SOAP RESPONSE.parse");
                System.out.println(body.getAsString());
            }
            if ((fault = (SOAPFault)body.getFault()) != null) {
                System.err.println("FAULT: " + fault.getAsString());
                this.errorCode = fault.getFaultCode();
                this.errorMessage = fault.getFaultString();
            } else {
                Iterator i = body.getChildElements();
                while (i.hasNext()) {
                    Element bodyelement = (Element)i.next();
                    bodyelement.normalize();
                    this.payload = XMLUtilities.getChildElements(bodyelement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getStat() {
        return null;
    }

    @Override
    public Element getPayload() {
        Iterator iter = this.payload.iterator();
        if (iter.hasNext()) {
            return (Element)iter.next();
        }
        throw new RuntimeException("SOAP response payload has no elements");
    }

    @Override
    public Collection getPayloadCollection() {
        return this.payload;
    }

    @Override
    public boolean isError() {
        return this.errorCode != null;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

